/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.SolrDocumentBase;
import org.apache.solr.common.util.NamedList;

public class SolrDocument
extends SolrDocumentBase<Object, SolrDocument>
implements Iterable<Map.Entry<String, Object>> {
    private final Map<String, Object> _fields = new LinkedHashMap<String, Object>();
    private List<SolrDocument> _childDocuments;

    @Override
    public Collection<String> getFieldNames() {
        return this.keySet();
    }

    @Override
    public void clear() {
        this._fields.clear();
        if (this._childDocuments != null) {
            this._childDocuments.clear();
        }
    }

    public boolean removeFields(String name) {
        return this.remove(name) != null;
    }

    @Override
    public void setField(String name, Object value2) {
        if (value2 instanceof Object[]) {
            value2 = new ArrayList<Object>(Arrays.asList((Object[])value2));
        } else if (!(value2 instanceof Collection) && !(value2 instanceof NamedList) && value2 instanceof Iterable) {
            ArrayList lst = new ArrayList();
            for (Object o : (Iterable)value2) {
                lst.add(o);
            }
            value2 = lst;
        }
        this._fields.put(name, value2);
    }

    @Override
    public void addField(String name, Object value2) {
        Object existing = this._fields.get(name);
        if (existing == null) {
            if (value2 instanceof Collection) {
                ArrayList c = new ArrayList(3);
                for (Object o : (Collection)value2) {
                    c.add(o);
                }
                this.setField(name, c);
            } else {
                this.setField(name, value2);
            }
            return;
        }
        ArrayList<Object> vals = null;
        if (existing instanceof Collection) {
            vals = (ArrayList<Object>)existing;
        } else {
            vals = new ArrayList<Object>(3);
            vals.add(existing);
        }
        if (value2 instanceof Iterable) {
            for (Object o : (Iterable)value2) {
                vals.add(o);
            }
        } else if (value2 instanceof Object[]) {
            for (Object o : (Object[])value2) {
                vals.add(o);
            }
        } else {
            vals.add(value2);
        }
        this._fields.put(name, vals);
    }

    public Object getFirstValue(String name) {
        Object v = this._fields.get(name);
        if (v == null || !(v instanceof Collection)) {
            return v;
        }
        Collection c = (Collection)v;
        if (c.size() > 0) {
            return c.iterator().next();
        }
        return null;
    }

    @Override
    public Object getFieldValue(String name) {
        return this._fields.get(name);
    }

    @Override
    public Collection<Object> getFieldValues(String name) {
        Object v = this._fields.get(name);
        if (v instanceof Collection) {
            return (Collection)v;
        }
        if (v != null) {
            ArrayList<Object> arr = new ArrayList<Object>(1);
            arr.add(v);
            return arr;
        }
        return null;
    }

    public String toString() {
        return "SolrDocument" + this._fields;
    }

    @Override
    public Iterator<Map.Entry<String, Object>> iterator() {
        return this._fields.entrySet().iterator();
    }

    public Map<String, Collection<Object>> getFieldValuesMap() {
        return new Map<String, Collection<Object>>(){

            @Override
            public Collection<Object> get(Object key) {
                return SolrDocument.this.getFieldValues((String)key);
            }

            @Override
            public boolean containsKey(Object key) {
                return SolrDocument.this._fields.containsKey(key);
            }

            @Override
            public Set<String> keySet() {
                return SolrDocument.this._fields.keySet();
            }

            @Override
            public int size() {
                return SolrDocument.this._fields.size();
            }

            @Override
            public boolean isEmpty() {
                return SolrDocument.this._fields.isEmpty();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsValue(Object value2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Set<Map.Entry<String, Collection<Object>>> entrySet() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends String, ? extends Collection<Object>> t) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<Collection<Object>> values() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<Object> put(String key, Collection<Object> value2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<Object> remove(Object key) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return SolrDocument.this._fields.toString();
            }
        };
    }

    public Map<String, Object> getFieldValueMap() {
        return new Map<String, Object>(){

            @Override
            public Object get(Object key) {
                return SolrDocument.this.getFirstValue((String)key);
            }

            @Override
            public boolean containsKey(Object key) {
                return SolrDocument.this._fields.containsKey(key);
            }

            @Override
            public Set<String> keySet() {
                return SolrDocument.this._fields.keySet();
            }

            @Override
            public int size() {
                return SolrDocument.this._fields.size();
            }

            @Override
            public boolean isEmpty() {
                return SolrDocument.this._fields.isEmpty();
            }

            @Override
            public void clear() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean containsValue(Object value2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Set<Map.Entry<String, Object>> entrySet() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void putAll(Map<? extends String, ? extends Object> t) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<Object> values() {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<Object> put(String key, Object value2) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Collection<Object> remove(Object key) {
                throw new UnsupportedOperationException();
            }

            public String toString() {
                return SolrDocument.this._fields.toString();
            }
        };
    }

    @Override
    public boolean containsKey(Object key) {
        return this._fields.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value2) {
        return this._fields.containsValue(value2);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this._fields.entrySet();
    }

    @Override
    public Object get(Object key) {
        return this._fields.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this._fields.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this._fields.keySet();
    }

    @Override
    public Object put(String key, Object value2) {
        return this._fields.put(key, value2);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> t) {
        this._fields.putAll(t);
    }

    @Override
    public Object remove(Object key) {
        return this._fields.remove(key);
    }

    @Override
    public int size() {
        return this._fields.size();
    }

    @Override
    public Collection<Object> values() {
        return this._fields.values();
    }

    @Override
    public void addChildDocument(SolrDocument child) {
        if (this._childDocuments == null) {
            this._childDocuments = new ArrayList<SolrDocument>();
        }
        this._childDocuments.add(child);
    }

    @Override
    public void addChildDocuments(Collection<SolrDocument> children) {
        for (SolrDocument child : children) {
            this.addChildDocument(child);
        }
    }

    @Override
    public List<SolrDocument> getChildDocuments() {
        return this._childDocuments;
    }

    @Override
    public boolean hasChildDocuments() {
        boolean isEmpty2 = this._childDocuments == null || this._childDocuments.isEmpty();
        return !isEmpty2;
    }

    @Override
    public int getChildDocumentCount() {
        return this._childDocuments.size();
    }
}

