/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkStateReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterStateUtil {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int TIMEOUT_POLL_MS = 1000;

    public static boolean waitForAllActiveAndLiveReplicas(ZkStateReader zkStateReader, int timeoutInMs) {
        return ClusterStateUtil.waitForAllActiveAndLiveReplicas(zkStateReader, null, timeoutInMs);
    }

    public static boolean waitForAllActiveAndLiveReplicas(ZkStateReader zkStateReader, String collection, int timeoutInMs) {
        long timeout = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeoutInMs, TimeUnit.MILLISECONDS);
        boolean success = false;
        while (!success && System.nanoTime() < timeout) {
            success = true;
            ClusterState clusterState = zkStateReader.getClusterState();
            if (clusterState == null) continue;
            Set<String> collections = collection != null ? Collections.singleton(collection) : clusterState.getCollections();
            for (String coll : collections) {
                DocCollection docCollection = clusterState.getCollection(coll);
                Collection<Slice> slices = docCollection.getSlices();
                for (Slice slice2 : slices) {
                    if (slice2.getState() != Slice.State.ACTIVE) continue;
                    Collection<Replica> replicas = slice2.getReplicas();
                    for (Replica replica : replicas) {
                        boolean isActive;
                        boolean live = clusterState.liveNodesContain(replica.getNodeName());
                        boolean bl = isActive = replica.getState() == Replica.State.ACTIVE;
                        if (live && isActive) continue;
                        success = false;
                    }
                }
            }
            if (success) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted");
            }
        }
        return success;
    }

    public static boolean waitToSeeLiveReplica(ZkStateReader zkStateReader, String collection, String coreNodeName, String baseUrl, int timeoutInMs) {
        long timeout = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeoutInMs, TimeUnit.MILLISECONDS);
        while (System.nanoTime() < timeout) {
            log.debug("waiting to see replica just created live collection={} replica={} baseUrl={}", collection, coreNodeName, baseUrl);
            ClusterState clusterState = zkStateReader.getClusterState();
            if (clusterState == null) continue;
            DocCollection docCollection = clusterState.getCollection(collection);
            Collection<Slice> slices = docCollection.getSlices();
            for (Slice slice2 : slices) {
                if (slice2.getState() != Slice.State.ACTIVE) continue;
                Collection<Replica> replicas = slice2.getReplicas();
                for (Replica replica : replicas) {
                    boolean live = clusterState.liveNodesContain(replica.getNodeName());
                    String rcoreNodeName = replica.getName();
                    String rbaseUrl = replica.getStr("base_url");
                    if (!live || !coreNodeName.equals(rcoreNodeName) || !baseUrl.equals(rbaseUrl)) continue;
                    return true;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted");
            }
        }
        log.error("Timed out waiting to see replica just created in cluster state. Continuing...");
        return false;
    }

    public static boolean waitForAllReplicasNotLive(ZkStateReader zkStateReader, int timeoutInMs) {
        return ClusterStateUtil.waitForAllReplicasNotLive(zkStateReader, null, timeoutInMs);
    }

    public static boolean waitForAllReplicasNotLive(ZkStateReader zkStateReader, String collection, int timeoutInMs) {
        long timeout = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeoutInMs, TimeUnit.MILLISECONDS);
        boolean success = false;
        while (!success && System.nanoTime() < timeout) {
            success = true;
            ClusterState clusterState = zkStateReader.getClusterState();
            if (clusterState == null) continue;
            Set<String> collections = collection == null ? clusterState.getCollections() : Collections.singleton(collection);
            for (String coll : collections) {
                DocCollection docCollection = clusterState.getCollection(coll);
                Collection<Slice> slices = docCollection.getSlices();
                for (Slice slice2 : slices) {
                    if (slice2.getState() != Slice.State.ACTIVE) continue;
                    Collection<Replica> replicas = slice2.getReplicas();
                    for (Replica replica : replicas) {
                        boolean live = clusterState.liveNodesContain(replica.getNodeName());
                        if (!live) continue;
                        success = false;
                    }
                }
            }
            if (success) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted");
            }
        }
        return success;
    }

    public static int getLiveAndActiveReplicaCount(ZkStateReader zkStateReader, String collection) {
        Collection<Slice> slices = zkStateReader.getClusterState().getActiveSlices(collection);
        int liveAndActive = 0;
        for (Slice slice2 : slices) {
            for (Replica replica : slice2.getReplicas()) {
                boolean active;
                boolean live = zkStateReader.getClusterState().liveNodesContain(replica.getNodeName());
                boolean bl = active = replica.getState() == Replica.State.ACTIVE;
                if (!live || !active) continue;
                ++liveAndActive;
            }
        }
        return liveAndActive;
    }

    public static boolean waitForLiveAndActiveReplicaCount(ZkStateReader zkStateReader, String collection, int replicaCount, int timeoutInMs) {
        long timeout = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeoutInMs, TimeUnit.MILLISECONDS);
        boolean success = false;
        while (!success && System.nanoTime() < timeout) {
            success = ClusterStateUtil.getLiveAndActiveReplicaCount(zkStateReader, collection) == replicaCount;
            if (success) continue;
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted");
            }
        }
        return success;
    }

    public static boolean isAutoAddReplicas(ZkStateReader reader, String collection) {
        DocCollection docCollection;
        ClusterState clusterState = reader.getClusterState();
        if (clusterState != null && (docCollection = clusterState.getCollectionOrNull(collection)) != null) {
            return docCollection.getAutoAddReplicas();
        }
        return false;
    }
}

