/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.CompositeIdRouter;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.ImplicitDocRouter;
import org.apache.solr.common.cloud.PlainIdRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.noggit.JSONWriter;

public abstract class DocRouter {
    public static final String DEFAULT_NAME = "compositeId";
    public static final DocRouter DEFAULT = new CompositeIdRouter();
    private static final Map<String, DocRouter> routerMap = new HashMap<String, DocRouter>();

    public static DocRouter getDocRouter(String routerName) {
        DocRouter router = routerMap.get(routerName);
        if (router != null) {
            return router;
        }
        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown document router '" + routerName + "'");
    }

    protected String getRouteField(DocCollection coll) {
        if (coll == null) {
            return null;
        }
        Object o = coll.get("router");
        if (o instanceof String) {
            return null;
        }
        Map m = (Map)o;
        if (m == null) {
            return null;
        }
        return (String)m.get("field");
    }

    public static Map<String, Object> getRouterSpec(ZkNodeProps props) {
        LinkedHashMap<String, Object> map2 = new LinkedHashMap<String, Object>();
        for (String s2 : props.keySet()) {
            if (!s2.startsWith("router.")) continue;
            map2.put(s2.substring(7), props.get(s2));
        }
        Object o = props.get("router");
        if (o instanceof String) {
            map2.put("name", o);
        } else if (map2.get("name") == null) {
            map2.put("name", DEFAULT_NAME);
        }
        return map2;
    }

    public Range fromString(String range2) {
        int middle = range2.indexOf(45);
        String minS = range2.substring(0, middle);
        String maxS = range2.substring(middle + 1);
        long min2 = Long.parseLong(minS, 16);
        long max2 = Long.parseLong(maxS, 16);
        return new Range((int)min2, (int)max2);
    }

    public Range fullRange() {
        return new Range(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public List<Range> partitionRange(int partitions, Range range2) {
        long start;
        int min2 = range2.min;
        int max2 = range2.max;
        assert (max2 >= min2);
        if (partitions == 0) {
            return Collections.EMPTY_LIST;
        }
        long rangeSize = (long)max2 - (long)min2;
        long rangeStep = Math.max(1L, rangeSize / (long)partitions);
        ArrayList<Range> ranges = new ArrayList<Range>(partitions);
        long end = start = (long)min2;
        while (end < (long)max2) {
            end = start + rangeStep;
            if (ranges.size() == partitions - 1) {
                end = max2;
            }
            ranges.add(new Range((int)start, (int)end));
            start = end + 1L;
        }
        return ranges;
    }

    public abstract Slice getTargetSlice(String var1, SolrInputDocument var2, String var3, SolrParams var4, DocCollection var5);

    public abstract Collection<Slice> getSearchSlicesSingle(String var1, SolrParams var2, DocCollection var3);

    public abstract boolean isTargetSlice(String var1, SolrInputDocument var2, SolrParams var3, String var4, DocCollection var5);

    public Collection<Slice> getSearchSlices(String shardKeys, SolrParams params, DocCollection collection) {
        if (shardKeys == null || shardKeys.indexOf(44) < 0) {
            return this.getSearchSlicesSingle(shardKeys, params, collection);
        }
        List<String> shardKeyList = StrUtils.splitSmart(shardKeys, ",", true);
        HashSet<Slice> allSlices = new HashSet<Slice>();
        for (String shardKey : shardKeyList) {
            allSlices.addAll(this.getSearchSlicesSingle(shardKey, params, collection));
        }
        return allSlices;
    }

    static {
        PlainIdRouter plain = new PlainIdRouter();
        routerMap.put(null, plain);
        routerMap.put("plain", plain);
        routerMap.put(DEFAULT_NAME, DEFAULT_NAME.equals(DEFAULT_NAME) ? DEFAULT : new CompositeIdRouter());
        routerMap.put("implicit", new ImplicitDocRouter());
    }

    public static class Range
    implements JSONWriter.Writable,
    Comparable<Range> {
        public int min;
        public int max;

        public Range(int min2, int max2) {
            assert (min2 <= max2);
            this.min = min2;
            this.max = max2;
        }

        public boolean includes(int hash) {
            return hash >= this.min && hash <= this.max;
        }

        public boolean isSubsetOf(Range superset) {
            return superset.min <= this.min && superset.max >= this.max;
        }

        public boolean overlaps(Range other) {
            return this.includes(other.min) || this.includes(other.max) || this.isSubsetOf(other);
        }

        public String toString() {
            return Integer.toHexString(this.min) + '-' + Integer.toHexString(this.max);
        }

        public int hashCode() {
            return (this.min >> 28) + (this.min >> 25) + (this.min >> 21) + this.min;
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Range other = (Range)obj;
            return this.min == other.min && this.max == other.max;
        }

        @Override
        public void write(JSONWriter writer) {
            writer.write(this.toString());
        }

        @Override
        public int compareTo(Range that) {
            int mincomp = Integer.valueOf(this.min).compareTo(that.min);
            return mincomp == 0 ? Integer.valueOf(this.max).compareTo(that.max) : mincomp;
        }
    }
}

