/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Collection;
import java.util.Collections;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.Hash;

public abstract class HashBasedRouter
extends DocRouter {
    @Override
    public Slice getTargetSlice(String id, SolrInputDocument sdoc, String route, SolrParams params, DocCollection collection) {
        int hash;
        if (route != null) {
            hash = this.sliceHash(route, sdoc, params, collection);
        } else {
            if (id == null) {
                id = this.getId(sdoc, params);
            }
            hash = this.sliceHash(id, sdoc, params, collection);
        }
        return this.hashToSlice(hash, collection);
    }

    @Override
    public boolean isTargetSlice(String id, SolrInputDocument sdoc, SolrParams params, String shardId, DocCollection collection) {
        if (id == null) {
            id = this.getId(sdoc, params);
        }
        int hash = this.sliceHash(id, sdoc, params, collection);
        DocRouter.Range range2 = collection.getSlice(shardId).getRange();
        return range2 != null && range2.includes(hash);
    }

    public int sliceHash(String id, SolrInputDocument sdoc, SolrParams params, DocCollection collection) {
        return Hash.murmurhash3_x86_32(id, 0, id.length(), 0);
    }

    protected String getId(SolrInputDocument sdoc, SolrParams params) {
        Object idObj = sdoc.getFieldValue("id");
        String id = idObj != null ? idObj.toString() : "null";
        return id;
    }

    protected Slice hashToSlice(int hash, DocCollection collection) {
        for (Slice slice2 : collection.getActiveSlices()) {
            DocRouter.Range range2 = slice2.getRange();
            if (range2 == null || !range2.includes(hash)) continue;
            return slice2;
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No active slice servicing hash code " + Integer.toHexString(hash) + " in " + collection);
    }

    @Override
    public Collection<Slice> getSearchSlicesSingle(String shardKey, SolrParams params, DocCollection collection) {
        if (shardKey == null) {
            return collection.getActiveSlices();
        }
        Slice slice2 = this.getTargetSlice(shardKey, null, null, params, collection);
        return slice2 == null ? Collections.emptyList() : Collections.singletonList(slice2);
    }
}

