/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.params;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class MultiMapSolrParams
extends SolrParams {
    protected final Map<String, String[]> map;

    public static void addParam(String name, String val, Map<String, String[]> map2) {
        String[] arr = map2.get(name);
        if (arr == null) {
            arr = new String[]{val};
        } else {
            String[] newarr = new String[arr.length + 1];
            System.arraycopy(arr, 0, newarr, 0, arr.length);
            newarr[arr.length] = val;
            arr = newarr;
        }
        map2.put(name, arr);
    }

    public static void addParam(String name, String[] vals, Map<String, String[]> map2) {
        String[] arr = map2.put(name, vals);
        if (arr == null) {
            return;
        }
        String[] newarr = new String[arr.length + vals.length];
        System.arraycopy(arr, 0, newarr, 0, arr.length);
        System.arraycopy(vals, 0, newarr, arr.length, vals.length);
        arr = newarr;
        map2.put(name, arr);
    }

    public MultiMapSolrParams(Map<String, String[]> map2) {
        this.map = map2;
    }

    @Override
    public String get(String name) {
        String[] arr = this.map.get(name);
        return arr == null ? null : arr[0];
    }

    @Override
    public String[] getParams(String name) {
        return this.map.get(name);
    }

    @Override
    public Iterator<String> getParameterNamesIterator() {
        return this.map.keySet().iterator();
    }

    public Map<String, String[]> getMap() {
        return this.map;
    }

    public static Map<String, String[]> asMultiMap(SolrParams params) {
        return MultiMapSolrParams.asMultiMap(params, false);
    }

    public static Map<String, String[]> asMultiMap(SolrParams params, boolean newCopy) {
        if (params instanceof MultiMapSolrParams) {
            Map<String, String[]> map2 = ((MultiMapSolrParams)params).getMap();
            if (newCopy) {
                return new HashMap<String, String[]>(map2);
            }
            return map2;
        }
        if (params instanceof ModifiableSolrParams) {
            Map<String, String[]> map3 = ((ModifiableSolrParams)params).getMap();
            if (newCopy) {
                return new HashMap<String, String[]>(map3);
            }
            return map3;
        }
        HashMap<String, String[]> map4 = new HashMap<String, String[]>();
        Iterator<String> iterator2 = params.getParameterNamesIterator();
        while (iterator2.hasNext()) {
            String name = iterator2.next();
            map4.put(name, params.getParams(name));
        }
        return map4;
    }
}

