/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.params;

import java.util.Iterator;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;

public class RequiredSolrParams
extends SolrParams {
    protected final SolrParams params;

    public RequiredSolrParams(SolrParams params) {
        this.params = params;
    }

    @Override
    public String get(String param2) {
        String val = this.params.get(param2);
        if (val == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter: " + param2);
        }
        return val;
    }

    @Override
    public String getFieldParam(String field2, String param2) {
        String fpname = this.fpname(field2, param2);
        String val = this.params.get(fpname);
        if (null == val && null == (val = this.params.get(param2))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter: " + fpname + " (or default: " + param2 + ")");
        }
        return val;
    }

    @Override
    public String[] getFieldParams(String field2, String param2) {
        String fpname = this.fpname(field2, param2);
        String[] val = this.params.getParams(fpname);
        if (null == val && null == (val = this.params.getParams(param2))) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter: " + fpname + " (or default: " + param2 + ")");
        }
        return val;
    }

    @Override
    public String[] getParams(String param2) {
        String[] vals = this.params.getParams(param2);
        if (vals == null || vals.length == 0) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Missing required parameter: " + param2);
        }
        return vals;
    }

    @Override
    public Iterator<String> getParameterNamesIterator() {
        return this.params.getParameterNamesIterator();
    }

    @Override
    public String toString() {
        return "{required(" + this.params + ")}";
    }

    @Override
    public String get(String param2, String def) {
        return this.params.get(param2, def);
    }

    @Override
    public int getInt(String param2, int def) {
        return this.params.getInt(param2, def);
    }

    @Override
    public float getFloat(String param2, float def) {
        return this.params.getFloat(param2, def);
    }

    @Override
    public boolean getBool(String param2, boolean def) {
        return this.params.getBool(param2, def);
    }

    @Override
    public int getFieldInt(String field2, String param2, int def) {
        return this.params.getFieldInt(field2, param2, def);
    }

    @Override
    public boolean getFieldBool(String field2, String param2, boolean def) {
        return this.params.getFieldBool(field2, param2, def);
    }

    @Override
    public float getFieldFloat(String field2, String param2, float def) {
        return this.params.getFieldFloat(field2, param2, def);
    }

    @Override
    public String getFieldParam(String field2, String param2, String def) {
        return this.params.getFieldParam(field2, param2, def);
    }

    public void check(String ... params) {
        for (String param2 : params) {
            this.get(param2);
        }
    }
}

