/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.solr.common.SolrException;

public class StrUtils {
    public static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static List<String> splitSmart(String s2, char separator) {
        ArrayList<String> lst = new ArrayList<String>(4);
        int pos = 0;
        int start = 0;
        int end = s2.length();
        char inString = '\u0000';
        char ch = '\u0000';
        while (pos < end) {
            char prevChar = ch;
            if ((ch = s2.charAt(pos++)) == '\\') {
                ++pos;
                continue;
            }
            if (inString != '\u0000' && ch == inString) {
                inString = '\u0000';
                continue;
            }
            if (ch == '\'' || ch == '\"') {
                if (Character.isLetterOrDigit(prevChar)) continue;
                inString = ch;
                continue;
            }
            if (ch != separator || inString != '\u0000') continue;
            lst.add(s2.substring(start, pos - 1));
            start = pos;
        }
        if (start < end) {
            lst.add(s2.substring(start, end));
        }
        return lst;
    }

    public static List<String> splitSmart(String s2, String separator, boolean decode) {
        ArrayList<String> lst = new ArrayList<String>(2);
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int end = s2.length();
        while (pos < end) {
            int ch;
            if (s2.startsWith(separator, pos)) {
                if (sb.length() > 0) {
                    lst.add(sb.toString());
                    sb = new StringBuilder();
                }
                pos += separator.length();
                continue;
            }
            if ((ch = s2.charAt(pos++)) == 92) {
                if (!decode) {
                    sb.append((char)ch);
                }
                if (pos >= end) break;
                ch = s2.charAt(pos++);
                if (decode) {
                    switch (ch) {
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 102: {
                            ch = 12;
                        }
                    }
                }
            }
            sb.append((char)ch);
        }
        if (sb.length() > 0) {
            lst.add(sb.toString());
        }
        return lst;
    }

    public static List<String> splitFileNames(String fileNames) {
        if (fileNames == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result2 = new ArrayList<String>();
        for (String file : fileNames.split("(?<!\\\\),")) {
            result2.add(file.replaceAll("\\\\(?=,)", ""));
        }
        return result2;
    }

    public static String join(List<?> items, char separator) {
        StringBuilder sb = new StringBuilder(items.size() << 3);
        boolean first = true;
        for (Object o : items) {
            String item = o.toString();
            if (first) {
                first = false;
            } else {
                sb.append(separator);
            }
            StrUtils.appendEscapedTextToBuilder(sb, item, separator);
        }
        return sb.toString();
    }

    public static List<String> splitWS(String s2, boolean decode) {
        ArrayList<String> lst = new ArrayList<String>(2);
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        int end = s2.length();
        while (pos < end) {
            int ch;
            if (Character.isWhitespace((char)(ch = s2.charAt(pos++)))) {
                if (sb.length() <= 0) continue;
                lst.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            if (ch == 92) {
                if (!decode) {
                    sb.append((char)ch);
                }
                if (pos >= end) break;
                ch = s2.charAt(pos++);
                if (decode) {
                    switch (ch) {
                        case 110: {
                            ch = 10;
                            break;
                        }
                        case 116: {
                            ch = 9;
                            break;
                        }
                        case 114: {
                            ch = 13;
                            break;
                        }
                        case 98: {
                            ch = 8;
                            break;
                        }
                        case 102: {
                            ch = 12;
                        }
                    }
                }
            }
            sb.append((char)ch);
        }
        if (sb.length() > 0) {
            lst.add(sb.toString());
        }
        return lst;
    }

    public static List<String> toLower(List<String> strings) {
        ArrayList<String> ret = new ArrayList<String>(strings.size());
        for (String str : strings) {
            ret.add(str.toLowerCase(Locale.ROOT));
        }
        return ret;
    }

    public static boolean parseBoolean(String s2) {
        char ch = s2.length() > 0 ? s2.charAt(0) : (char)'\u0000';
        return ch == '1' || ch == 't' || ch == 'T';
    }

    public static boolean parseBool(String s2) {
        if (s2 != null) {
            if (s2.startsWith("true") || s2.startsWith("on") || s2.startsWith("yes")) {
                return true;
            }
            if (s2.startsWith("false") || s2.startsWith("off") || s2.equals("no")) {
                return false;
            }
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "invalid boolean value: " + s2);
    }

    public static boolean parseBool(String s2, boolean def) {
        if (s2 != null) {
            if (s2.startsWith("true") || s2.startsWith("on") || s2.startsWith("yes")) {
                return true;
            }
            if (s2.startsWith("false") || s2.startsWith("off") || s2.equals("no")) {
                return false;
            }
        }
        return def;
    }

    public static void partialURLEncodeVal(Appendable dest, String val) throws IOException {
        block7: for (int i = 0; i < val.length(); ++i) {
            char ch = val.charAt(i);
            if (ch < ' ') {
                dest.append('%');
                if (ch < '\u0010') {
                    dest.append('0');
                }
                dest.append(Integer.toHexString(ch));
                continue;
            }
            switch (ch) {
                case ' ': {
                    dest.append('+');
                    continue block7;
                }
                case '&': {
                    dest.append("%26");
                    continue block7;
                }
                case '%': {
                    dest.append("%25");
                    continue block7;
                }
                case '=': {
                    dest.append("%3D");
                    continue block7;
                }
                case '+': {
                    dest.append("%2B");
                    continue block7;
                }
                default: {
                    dest.append(ch);
                }
            }
        }
    }

    public static String escapeTextWithSeparator(String item, char separator) {
        StringBuilder sb = new StringBuilder(item.length() * 2);
        StrUtils.appendEscapedTextToBuilder(sb, item, separator);
        return sb.toString();
    }

    public static void appendEscapedTextToBuilder(StringBuilder out, String item, char separator) {
        for (int i = 0; i < item.length(); ++i) {
            char ch = item.charAt(i);
            if (ch == '\\' || ch == separator) {
                out.append('\\');
            }
            out.append(ch);
        }
    }

    public static String formatString(String pattern, Object ... args) {
        return new MessageFormat(pattern, Locale.ROOT).format(args);
    }
}

