/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jute.BinaryInputArchive;
import org.apache.jute.BinaryOutputArchive;
import org.apache.jute.Record;
import org.apache.zookeeper.Environment;
import org.apache.zookeeper.Version;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.proto.ReplyHeader;
import org.apache.zookeeper.proto.WatcherEvent;
import org.apache.zookeeper.server.DataTree;
import org.apache.zookeeper.server.NettyServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerStats;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperSaslServer;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.ZooTrace;
import org.apache.zookeeper.server.quorum.Leader;
import org.apache.zookeeper.server.quorum.LeaderZooKeeperServer;
import org.apache.zookeeper.server.quorum.ReadOnlyZooKeeperServer;
import org.apache.zookeeper.server.util.OSMXBean;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.MessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyServerCnxn
extends ServerCnxn {
    Logger LOG = LoggerFactory.getLogger(NettyServerCnxn.class);
    Channel channel;
    ChannelBuffer queuedBuffer;
    volatile boolean throttled;
    ByteBuffer bb;
    ByteBuffer bbLen = ByteBuffer.allocate(4);
    long sessionId;
    int sessionTimeout;
    AtomicLong outstandingCount = new AtomicLong();
    private volatile ZooKeeperServer zkServer;
    NettyServerCnxnFactory factory;
    boolean initialized;
    private static final byte[] fourBytes = new byte[4];
    private static final String ZK_NOT_SERVING = "This ZooKeeper instance is not currently serving requests";

    NettyServerCnxn(Channel channel, ZooKeeperServer zks, NettyServerCnxnFactory factory) {
        this.channel = channel;
        this.zkServer = zks;
        this.factory = factory;
        if (this.factory.login != null) {
            this.zooKeeperSaslServer = new ZooKeeperSaslServer(factory.login);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("close called for sessionid:0x" + Long.toHexString(this.sessionId));
        }
        HashSet hashSet = this.factory.cnxns;
        synchronized (hashSet) {
            if (!this.factory.cnxns.remove(this)) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug("cnxns size:" + this.factory.cnxns.size());
                }
                return;
            }
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("close in progress for sessionid:0x" + Long.toHexString(this.sessionId));
            }
            HashMap<InetAddress, Set<NettyServerCnxn>> hashMap = this.factory.ipMap;
            synchronized (hashMap) {
                Set<NettyServerCnxn> s2 = this.factory.ipMap.get(((InetSocketAddress)this.channel.getRemoteAddress()).getAddress());
                s2.remove(this);
            }
        }
        if (this.channel.isOpen()) {
            this.channel.close();
        }
        this.factory.unregisterConnection(this);
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void process(WatchedEvent event) {
        ReplyHeader h = new ReplyHeader(-1, -1L, 0);
        if (this.LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(this.LOG, 64L, "Deliver event " + event + " to 0x" + Long.toHexString(this.sessionId) + " through " + this);
        }
        WatcherEvent e = event.getWrapper();
        try {
            this.sendResponse(h, e, "notification");
        }
        catch (IOException e1) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Problem sending to " + this.getRemoteSocketAddress(), e1);
            }
            this.close();
        }
    }

    public void sendResponse(ReplyHeader h, Record r, String tag) throws IOException {
        if (!this.channel.isOpen()) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryOutputArchive bos = BinaryOutputArchive.getArchive(baos);
        try {
            baos.write(fourBytes);
            bos.writeRecord(h, "header");
            if (r != null) {
                bos.writeRecord(r, tag);
            }
            baos.close();
        }
        catch (IOException e) {
            this.LOG.error("Error serializing response");
        }
        byte[] b = baos.toByteArray();
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.putInt(b.length - 4).rewind();
        this.sendBuffer(bb);
        if (h.getXid() > 0 && !this.zkServer.shouldThrottle(this.outstandingCount.decrementAndGet())) {
            this.enableRecv();
        }
    }

    public void setSessionId(long sessionId) {
        this.sessionId = sessionId;
    }

    public void enableRecv() {
        if (this.throttled) {
            this.throttled = false;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug("Sending unthrottle event " + this);
            }
            this.channel.getPipeline().sendUpstream(new ResumeMessageEvent(this.channel));
        }
    }

    public void sendBuffer(ByteBuffer sendBuffer) {
        if (sendBuffer == ServerCnxnFactory.closeConn) {
            this.close();
            return;
        }
        this.channel.write(ChannelBuffers.wrappedBuffer(sendBuffer));
        this.packetSent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void cleanupWriterSocket(PrintWriter pwriter) {
        block9: {
            block8: {
                if (pwriter == null) break block8;
                pwriter.flush();
                pwriter.close();
            }
            Object var4_2 = null;
            try {
                this.close();
            }
            catch (Exception e2) {
                this.LOG.error("Error closing a command socket ", e2);
            }
            break block9;
            {
                catch (Exception e) {
                    this.LOG.info("Error closing PrintWriter ", e);
                    Object var4_3 = null;
                    try {
                        this.close();
                    }
                    catch (Exception e2) {
                        this.LOG.error("Error closing a command socket ", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    this.close();
                }
                catch (Exception e2) {
                    this.LOG.error("Error closing a command socket ", e2);
                }
                throw throwable;
            }
        }
    }

    private boolean checkFourLetterWord(Channel channel, ChannelBuffer message, int len) throws IOException {
        String cmd = (String)cmd2String.get(len);
        if (cmd == null) {
            return false;
        }
        channel.setInterestOps(0).awaitUninterruptibly();
        this.LOG.info("Processing " + cmd + " command from " + channel.getRemoteAddress());
        this.packetReceived();
        PrintWriter pwriter = new PrintWriter(new BufferedWriter(new SendBufferWriter()));
        if (len == ruokCmd) {
            RuokCommand ruok = new RuokCommand(pwriter);
            ruok.start();
            return true;
        }
        if (len == getTraceMaskCmd) {
            TraceMaskCommand tmask = new TraceMaskCommand(pwriter);
            tmask.start();
            return true;
        }
        if (len == setTraceMaskCmd) {
            ByteBuffer mask = ByteBuffer.allocate(4);
            message.readBytes(mask);
            this.bb.flip();
            long traceMask = mask.getLong();
            ZooTrace.setTextTraceLevel(traceMask);
            SetTraceMaskCommand setMask = new SetTraceMaskCommand(pwriter, traceMask);
            setMask.start();
            return true;
        }
        if (len == enviCmd) {
            EnvCommand env = new EnvCommand(pwriter);
            env.start();
            return true;
        }
        if (len == confCmd) {
            ConfCommand ccmd = new ConfCommand(pwriter);
            ccmd.start();
            return true;
        }
        if (len == srstCmd) {
            StatResetCommand strst = new StatResetCommand(pwriter);
            strst.start();
            return true;
        }
        if (len == crstCmd) {
            CnxnStatResetCommand crst = new CnxnStatResetCommand(pwriter);
            crst.start();
            return true;
        }
        if (len == dumpCmd) {
            DumpCommand dump = new DumpCommand(pwriter);
            dump.start();
            return true;
        }
        if (len == statCmd || len == srvrCmd) {
            StatCommand stat = new StatCommand(pwriter, len);
            stat.start();
            return true;
        }
        if (len == consCmd) {
            ConsCommand cons = new ConsCommand(pwriter);
            cons.start();
            return true;
        }
        if (len == wchpCmd || len == wchcCmd || len == wchsCmd) {
            WatchCommand wcmd = new WatchCommand(pwriter, len);
            wcmd.start();
            return true;
        }
        if (len == mntrCmd) {
            MonitorCommand mntr = new MonitorCommand(pwriter);
            mntr.start();
            return true;
        }
        if (len == isroCmd) {
            IsroCommand isro = new IsroCommand(pwriter);
            isro.start();
            return true;
        }
        return false;
    }

    public void receiveMessage(ChannelBuffer message) {
        try {
            while (message.readable() && !this.throttled) {
                if (this.bb != null) {
                    ByteBuffer dat;
                    if (this.LOG.isTraceEnabled()) {
                        this.LOG.trace("message readable " + message.readableBytes() + " bb len " + this.bb.remaining() + " " + this.bb);
                        dat = this.bb.duplicate();
                        dat.flip();
                        this.LOG.trace(Long.toHexString(this.sessionId) + " bb 0x" + ChannelBuffers.hexDump(ChannelBuffers.copiedBuffer(dat)));
                    }
                    if (this.bb.remaining() > message.readableBytes()) {
                        int newLimit = this.bb.position() + message.readableBytes();
                        this.bb.limit(newLimit);
                    }
                    message.readBytes(this.bb);
                    this.bb.limit(this.bb.capacity());
                    if (this.LOG.isTraceEnabled()) {
                        this.LOG.trace("after readBytes message readable " + message.readableBytes() + " bb len " + this.bb.remaining() + " " + this.bb);
                        dat = this.bb.duplicate();
                        dat.flip();
                        this.LOG.trace("after readbytes " + Long.toHexString(this.sessionId) + " bb 0x" + ChannelBuffers.hexDump(ChannelBuffers.copiedBuffer(dat)));
                    }
                    if (this.bb.remaining() != 0) continue;
                    this.packetReceived();
                    this.bb.flip();
                    ZooKeeperServer zks = this.zkServer;
                    if (zks == null) {
                        throw new IOException("ZK down");
                    }
                    if (this.initialized) {
                        zks.processPacket(this, this.bb);
                        if (zks.shouldThrottle(this.outstandingCount.incrementAndGet())) {
                            this.disableRecvNoWait();
                        }
                    } else {
                        this.LOG.debug("got conn req request from " + this.getRemoteSocketAddress());
                        zks.processConnectRequest(this, this.bb);
                        this.initialized = true;
                    }
                    this.bb = null;
                    continue;
                }
                if (this.LOG.isTraceEnabled()) {
                    this.LOG.trace("message readable " + message.readableBytes() + " bblenrem " + this.bbLen.remaining());
                    ByteBuffer dat = this.bbLen.duplicate();
                    dat.flip();
                    this.LOG.trace(Long.toHexString(this.sessionId) + " bbLen 0x" + ChannelBuffers.hexDump(ChannelBuffers.copiedBuffer(dat)));
                }
                if (message.readableBytes() < this.bbLen.remaining()) {
                    this.bbLen.limit(this.bbLen.position() + message.readableBytes());
                }
                message.readBytes(this.bbLen);
                this.bbLen.limit(this.bbLen.capacity());
                if (this.bbLen.remaining() != 0) continue;
                this.bbLen.flip();
                if (this.LOG.isTraceEnabled()) {
                    this.LOG.trace(Long.toHexString(this.sessionId) + " bbLen 0x" + ChannelBuffers.hexDump(ChannelBuffers.copiedBuffer(this.bbLen)));
                }
                int len = this.bbLen.getInt();
                if (this.LOG.isTraceEnabled()) {
                    this.LOG.trace(Long.toHexString(this.sessionId) + " bbLen len is " + len);
                }
                this.bbLen.clear();
                if (!this.initialized && this.checkFourLetterWord(this.channel, message, len)) {
                    return;
                }
                if (len < 0 || len > BinaryInputArchive.maxBuffer) {
                    throw new IOException("Len error " + len);
                }
                this.bb = ByteBuffer.allocate(len);
            }
        }
        catch (IOException e) {
            this.LOG.warn("Closing connection to " + this.getRemoteSocketAddress(), e);
            this.close();
        }
    }

    public void disableRecv() {
        this.disableRecvNoWait().awaitUninterruptibly();
    }

    private ChannelFuture disableRecvNoWait() {
        this.throttled = true;
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("Throttling - disabling recv " + this);
        }
        return this.channel.setReadable(false);
    }

    public long getOutstandingRequests() {
        return this.outstandingCount.longValue();
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public int getInterestOps() {
        return this.channel.getInterestOps();
    }

    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this.channel.getRemoteAddress();
    }

    public void sendCloseSession() {
        this.sendBuffer(ServerCnxnFactory.closeConn);
    }

    protected ServerStats serverStats() {
        if (this.zkServer == null) {
            return null;
        }
        return this.zkServer.serverStats();
    }

    private class IsroCommand
    extends CommandThread {
        public IsroCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NettyServerCnxn.this.zkServer == null) {
                this.pw.print("null");
            } else if (NettyServerCnxn.this.zkServer instanceof ReadOnlyZooKeeperServer) {
                this.pw.print("ro");
            } else {
                this.pw.print("rw");
            }
        }
    }

    private class MonitorCommand
    extends CommandThread {
        MonitorCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NettyServerCnxn.this.zkServer == null) {
                this.pw.println(NettyServerCnxn.ZK_NOT_SERVING);
                return;
            }
            ZKDatabase zkdb = NettyServerCnxn.this.zkServer.getZKDatabase();
            ServerStats stats = NettyServerCnxn.this.zkServer.serverStats();
            this.print("version", Version.getFullVersion());
            this.print("avg_latency", stats.getAvgLatency());
            this.print("max_latency", stats.getMaxLatency());
            this.print("min_latency", stats.getMinLatency());
            this.print("packets_received", stats.getPacketsReceived());
            this.print("packets_sent", stats.getPacketsSent());
            this.print("num_alive_connections", stats.getNumAliveClientConnections());
            this.print("outstanding_requests", stats.getOutstandingRequests());
            this.print("server_state", stats.getServerState());
            this.print("znode_count", zkdb.getNodeCount());
            this.print("watch_count", zkdb.getDataTree().getWatchCount());
            this.print("ephemerals_count", zkdb.getDataTree().getEphemeralsCount());
            this.print("approximate_data_size", zkdb.getDataTree().approximateDataSize());
            OSMXBean osMbean = new OSMXBean();
            if (osMbean != null && osMbean.getUnix()) {
                this.print("open_file_descriptor_count", osMbean.getOpenFileDescriptorCount());
                this.print("max_file_descriptor_count", osMbean.getMaxFileDescriptorCount());
            }
            if (stats.getServerState().equals("leader")) {
                Leader leader = ((LeaderZooKeeperServer)NettyServerCnxn.this.zkServer).getLeader();
                this.print("followers", leader.getLearners().size());
                this.print("synced_followers", leader.getForwardingFollowers().size());
                this.print("pending_syncs", leader.getNumPendingSyncs());
            }
        }

        private void print(String key, long number) {
            this.print(key, "" + number);
        }

        private void print(String key, String value2) {
            this.pw.print("zk_");
            this.pw.print(key);
            this.pw.print("\t");
            this.pw.println(value2);
        }
    }

    private class WatchCommand
    extends CommandThread {
        int len;

        public WatchCommand(PrintWriter pw, int len) {
            super(pw);
            this.len = 0;
            this.len = len;
        }

        public void commandRun() {
            if (NettyServerCnxn.this.zkServer == null) {
                this.pw.println(NettyServerCnxn.ZK_NOT_SERVING);
            } else {
                DataTree dt = NettyServerCnxn.this.zkServer.getZKDatabase().getDataTree();
                if (this.len == ServerCnxn.wchsCmd) {
                    dt.dumpWatchesSummary(this.pw);
                } else if (this.len == ServerCnxn.wchpCmd) {
                    dt.dumpWatches(this.pw, true);
                } else {
                    dt.dumpWatches(this.pw, false);
                }
                this.pw.println();
            }
        }
    }

    private class ConsCommand
    extends CommandThread {
        public ConsCommand(PrintWriter pw) {
            super(pw);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandRun() {
            if (NettyServerCnxn.this.zkServer == null) {
                this.pw.println(NettyServerCnxn.ZK_NOT_SERVING);
            } else {
                HashSet cnxns;
                HashSet hashSet = NettyServerCnxn.this.factory.cnxns;
                synchronized (hashSet) {
                    cnxns = new HashSet(NettyServerCnxn.this.factory.cnxns);
                }
                for (ServerCnxn c : cnxns) {
                    c.dumpConnectionInfo(this.pw, false);
                    this.pw.println();
                }
                this.pw.println();
            }
        }
    }

    private class StatCommand
    extends CommandThread {
        int len;

        public StatCommand(PrintWriter pw, int len) {
            super(pw);
            this.len = len;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandRun() {
            if (NettyServerCnxn.this.zkServer == null) {
                this.pw.println(NettyServerCnxn.ZK_NOT_SERVING);
            } else {
                this.pw.print("Zookeeper version: ");
                this.pw.println(Version.getFullVersion());
                if (NettyServerCnxn.this.zkServer instanceof ReadOnlyZooKeeperServer) {
                    this.pw.println("READ-ONLY mode; serving only read-only clients");
                }
                if (this.len == ServerCnxn.statCmd) {
                    HashSet cnxns;
                    NettyServerCnxn.this.LOG.info("Stat command output");
                    this.pw.println("Clients:");
                    HashSet hashSet = NettyServerCnxn.this.factory.cnxns;
                    synchronized (hashSet) {
                        cnxns = new HashSet(NettyServerCnxn.this.factory.cnxns);
                    }
                    for (ServerCnxn c : cnxns) {
                        c.dumpConnectionInfo(this.pw, true);
                        this.pw.println();
                    }
                    this.pw.println();
                }
                this.pw.print(NettyServerCnxn.this.zkServer.serverStats().toString());
                this.pw.print("Node count: ");
                this.pw.println(NettyServerCnxn.this.zkServer.getZKDatabase().getNodeCount());
            }
        }
    }

    private class DumpCommand
    extends CommandThread {
        public DumpCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NettyServerCnxn.this.zkServer == null) {
                this.pw.println(NettyServerCnxn.ZK_NOT_SERVING);
            } else {
                this.pw.println("SessionTracker dump:");
                ((NettyServerCnxn)NettyServerCnxn.this).zkServer.sessionTracker.dumpSessions(this.pw);
                this.pw.println("ephemeral nodes dump:");
                NettyServerCnxn.this.zkServer.dumpEphemerals(this.pw);
            }
        }
    }

    private class CnxnStatResetCommand
    extends CommandThread {
        public CnxnStatResetCommand(PrintWriter pw) {
            super(pw);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandRun() {
            if (NettyServerCnxn.this.zkServer == null) {
                this.pw.println(NettyServerCnxn.ZK_NOT_SERVING);
            } else {
                HashSet hashSet = NettyServerCnxn.this.factory.cnxns;
                synchronized (hashSet) {
                    for (ServerCnxn c : NettyServerCnxn.this.factory.cnxns) {
                        c.resetStats();
                    }
                }
                this.pw.println("Connection stats reset.");
            }
        }
    }

    private class StatResetCommand
    extends CommandThread {
        public StatResetCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NettyServerCnxn.this.zkServer == null) {
                this.pw.println(NettyServerCnxn.ZK_NOT_SERVING);
            } else {
                NettyServerCnxn.this.zkServer.serverStats().reset();
                this.pw.println("Server stats reset.");
            }
        }
    }

    private class ConfCommand
    extends CommandThread {
        ConfCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            if (NettyServerCnxn.this.zkServer == null) {
                this.pw.println(NettyServerCnxn.ZK_NOT_SERVING);
            } else {
                NettyServerCnxn.this.zkServer.dumpConf(this.pw);
            }
        }
    }

    private class EnvCommand
    extends CommandThread {
        EnvCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            List<Environment.Entry> env = Environment.list();
            this.pw.println("Environment:");
            for (Environment.Entry e : env) {
                this.pw.print(e.getKey());
                this.pw.print("=");
                this.pw.println(e.getValue());
            }
        }
    }

    private class SetTraceMaskCommand
    extends CommandThread {
        long trace;

        SetTraceMaskCommand(PrintWriter pw, long trace) {
            super(pw);
            this.trace = 0L;
            this.trace = trace;
        }

        public void commandRun() {
            this.pw.print(this.trace);
        }
    }

    private class TraceMaskCommand
    extends CommandThread {
        TraceMaskCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            long traceMask = ZooTrace.getTextTraceLevel();
            this.pw.print(traceMask);
        }
    }

    private class RuokCommand
    extends CommandThread {
        public RuokCommand(PrintWriter pw) {
            super(pw);
        }

        public void commandRun() {
            this.pw.print("imok");
        }
    }

    private abstract class CommandThread {
        PrintWriter pw;

        CommandThread(PrintWriter pw) {
            this.pw = pw;
        }

        public void start() {
            this.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    this.commandRun();
                }
                catch (IOException ie) {
                    NettyServerCnxn.this.LOG.error("Error in running command ", ie);
                    Object var3_2 = null;
                    NettyServerCnxn.this.cleanupWriterSocket(this.pw);
                    return;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                NettyServerCnxn.this.cleanupWriterSocket(this.pw);
                throw throwable;
            }
            NettyServerCnxn.this.cleanupWriterSocket(this.pw);
        }

        public abstract void commandRun() throws IOException;
    }

    private class SendBufferWriter
    extends Writer {
        private StringBuffer sb = new StringBuffer();

        private SendBufferWriter() {
        }

        private void checkFlush(boolean force) {
            if (force && this.sb.length() > 0 || this.sb.length() > 2048) {
                NettyServerCnxn.this.sendBuffer(ByteBuffer.wrap(this.sb.toString().getBytes()));
                this.sb.setLength(0);
            }
        }

        public void close() throws IOException {
            if (this.sb == null) {
                return;
            }
            this.checkFlush(true);
            this.sb = null;
        }

        public void flush() throws IOException {
            this.checkFlush(true);
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            this.sb.append(cbuf, off, len);
            this.checkFlush(false);
        }
    }

    static class ResumeMessageEvent
    implements MessageEvent {
        Channel channel;

        ResumeMessageEvent(Channel channel) {
            this.channel = channel;
        }

        public Object getMessage() {
            return null;
        }

        public SocketAddress getRemoteAddress() {
            return null;
        }

        public Channel getChannel() {
            return this.channel;
        }

        public ChannelFuture getFuture() {
            return null;
        }
    }
}

