/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ForUpdateClause;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.history.DecoratedDatabaseTable;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DB2MainframePlatform;

public class OuterJoinExpressionHolder
implements Comparable,
Serializable {
    final ObjectExpression joinExpression;
    DatabaseTable targetTable;
    DatabaseTable sourceTable;
    DatabaseTable targetAlias;
    DatabaseTable sourceAlias;
    List<DatabaseTable> additionalTargetTables;
    List<DatabaseTable> additionalTargetAliases;
    List<Expression> additionalJoinOnExpression;
    List<Boolean> additionalTargetIsDescriptorTable;
    Boolean hasInheritance;
    List<Integer> indexList;
    OuterJoinExpressionHolder mapKeyHolder;
    boolean isMapKeyHolder;
    Expression outerJoinedMappingCriteria;
    Map<DatabaseTable, Expression> outerJoinedAdditionalJoinCriteria;
    ClassDescriptor descriptor;
    SQLSelectStatement statement;

    public OuterJoinExpressionHolder(SQLSelectStatement statement, ObjectExpression joinExpression, Expression outerJoinedMappingCriteria, Map<DatabaseTable, Expression> outerJoinedAdditionalJoinCriteria, ClassDescriptor descriptor) {
        this.statement = statement;
        this.joinExpression = joinExpression;
        this.outerJoinedMappingCriteria = outerJoinedMappingCriteria;
        this.outerJoinedAdditionalJoinCriteria = outerJoinedAdditionalJoinCriteria;
        this.descriptor = descriptor;
    }

    public OuterJoinExpressionHolder(OuterJoinExpressionHolder holder) {
        this.joinExpression = holder.joinExpression;
        this.outerJoinedMappingCriteria = holder.outerJoinedMappingCriteria;
        this.outerJoinedAdditionalJoinCriteria = holder.outerJoinedAdditionalJoinCriteria;
        this.descriptor = holder.descriptor;
    }

    protected void process(boolean usesHistory) {
        this.process(usesHistory, false);
    }

    protected void process(boolean usesHistory, boolean isMapKeyHolder) {
        this.isMapKeyHolder = isMapKeyHolder;
        if (this.joinExpression instanceof QueryKeyExpression) {
            QueryKeyExpression expression = (QueryKeyExpression)this.joinExpression;
            if (isMapKeyHolder) {
                this.descriptor = expression.getMapKeyDescriptor();
                this.targetTable = this.descriptor.getTables().get(0);
                this.targetAlias = this.outerJoinedMappingCriteria.aliasForTable(this.targetTable);
            } else {
                if (expression.isMapKeyObjectRelationship()) {
                    this.mapKeyHolder = new OuterJoinExpressionHolder(this);
                    this.mapKeyHolder.process(usesHistory, true);
                }
                this.descriptor = expression.getDescriptor();
                this.targetTable = expression.getReferenceTable();
                this.targetAlias = expression.aliasForTable(this.targetTable);
            }
            this.sourceTable = expression.getSourceTable();
            this.sourceAlias = expression.getBaseExpression().aliasForTable(this.sourceTable);
        } else if (this.joinExpression != null) {
            this.sourceTable = ((ObjectExpression)this.joinExpression.getJoinSource()).getDescriptor().getTables().get(0);
            this.sourceAlias = this.joinExpression.getJoinSource().aliasForTable(this.sourceTable);
            this.targetTable = this.joinExpression.getDescriptor().getTables().get(0);
            this.targetAlias = this.joinExpression.aliasForTable(this.targetTable);
        } else {
            this.sourceTable = this.descriptor.getTables().get(0);
            this.targetTable = this.descriptor.getInheritancePolicy().getChildrenTables().get(0);
            Expression exp = this.outerJoinedAdditionalJoinCriteria.get(this.targetTable);
            this.sourceAlias = exp.aliasForTable(this.sourceTable);
            this.targetAlias = exp.aliasForTable(this.targetTable);
        }
        if (usesHistory) {
            this.sourceTable = this.getTableAliases().get(this.sourceAlias);
            this.targetTable = this.getTableAliases().get(this.targetAlias);
        }
        if (this.outerJoinedAdditionalJoinCriteria != null && !this.outerJoinedAdditionalJoinCriteria.isEmpty()) {
            if (this.descriptor == null) {
                this.descriptor = this.joinExpression.getDescriptor();
            }
            Vector targetTables = this.descriptor.getTables();
            int nDescriptorTables = targetTables.size();
            this.hasInheritance = this.descriptor.hasInheritance();
            if (this.hasInheritance.booleanValue()) {
                targetTables = this.descriptor.getInheritancePolicy().getAllTables();
            }
            int tablesSize = targetTables.size();
            int i = 1;
            while (i < tablesSize) {
                DatabaseTable table = (DatabaseTable)targetTables.get(i);
                Expression onExpression = this.outerJoinedAdditionalJoinCriteria.get(table);
                if (onExpression != null) {
                    DatabaseTable alias = onExpression.aliasForTable(table);
                    if (usesHistory) {
                        table = this.getTableAliases().get(alias);
                    }
                    if (this.additionalTargetAliases == null) {
                        this.additionalTargetAliases = new ArrayList<DatabaseTable>();
                        this.additionalTargetTables = new ArrayList<DatabaseTable>();
                        this.additionalJoinOnExpression = new ArrayList<Expression>();
                        this.additionalTargetIsDescriptorTable = new ArrayList<Boolean>();
                    }
                    this.additionalTargetAliases.add(alias);
                    this.additionalTargetTables.add(table);
                    this.additionalJoinOnExpression.add(onExpression);
                    this.additionalTargetIsDescriptorTable.add(i < nDescriptorTables);
                }
                ++i;
            }
        }
    }

    public boolean hasAdditionalJoinExpressions() {
        return this.additionalTargetTables != null;
    }

    public boolean hasMapKeyHolder() {
        return this.mapKeyHolder != null;
    }

    public void createIndexList(Map<DatabaseTable, OuterJoinExpressionHolder> targetAliasToHolders, Map<DatabaseTable, Integer> aliasToIndexes) {
        if (this.indexList != null) {
            return;
        }
        this.indexList = new ArrayList<Integer>();
        OuterJoinExpressionHolder baseHolder = targetAliasToHolders.get(this.sourceAlias);
        if (baseHolder != null) {
            baseHolder.createIndexList(targetAliasToHolders, aliasToIndexes);
            this.indexList.addAll(baseHolder.indexList);
        } else {
            this.indexList.add(aliasToIndexes.get(this.sourceAlias));
        }
        this.indexList.add(aliasToIndexes.get(this.targetAlias));
    }

    public int compareTo(Object other) {
        if (other == this) {
            return 0;
        }
        List<Integer> otherIndexList = ((OuterJoinExpressionHolder)other).indexList;
        int nMinSize = this.indexList.size();
        int nCompare = -1;
        int nOtherSize = otherIndexList.size();
        if (nMinSize > nOtherSize) {
            nMinSize = nOtherSize;
            nCompare = 1;
        } else if (nMinSize == nOtherSize) {
            nCompare = 0;
        }
        int i = 0;
        while (i < nMinSize) {
            int otherIndex;
            int index = this.indexList.get(i);
            if (index < (otherIndex = otherIndexList.get(i).intValue())) {
                return -1;
            }
            if (index > otherIndex) {
                return 1;
            }
            ++i;
        }
        return nCompare;
    }

    void printAdditionalJoins(ExpressionSQLPrinter printer, List<DatabaseTable> outerJoinedAliases, Collection aliasesOfTablesToBeLocked, boolean shouldPrintUpdateClauseForAllTables) throws IOException {
        Writer writer = printer.getWriter();
        AbstractSession session = printer.getSession();
        int size2 = this.additionalTargetAliases.size();
        int i = 0;
        while (i < size2) {
            DatabaseTable table = this.additionalTargetTables.get(i);
            if (this.additionalTargetIsDescriptorTable.get(i).booleanValue()) {
                if (!session.getPlatform().supportsANSIInnerJoinSyntax()) {
                    if (this.hasInheritance.booleanValue()) {
                        writer.write(" RIGHT OUTER");
                    } else {
                        writer.write(" LEFT OUTER");
                    }
                }
                writer.write(" JOIN ");
            } else {
                writer.write(" LEFT OUTER JOIN ");
            }
            DatabaseTable alias = this.additionalTargetAliases.get(i);
            table.printSQL(printer);
            writer.write(" ");
            if (alias.isDecorated()) {
                ((DecoratedDatabaseTable)alias).getAsOfClause().printSQL(printer);
                writer.write(" ");
            }
            outerJoinedAliases.add(alias);
            alias.printSQL(printer);
            if (shouldPrintUpdateClauseForAllTables || aliasesOfTablesToBeLocked != null && aliasesOfTablesToBeLocked.remove(alias)) {
                this.getForUpdateClause().printSQL(printer, this.statement);
            }
            writer.write(" ON ");
            if (session.getPlatform() instanceof DB2MainframePlatform) {
                ((RelationExpression)this.additionalJoinOnExpression.get(i)).printSQLNoParens(printer);
            } else {
                this.additionalJoinOnExpression.get(i).printSQL(printer);
            }
            ++i;
        }
    }

    public Map<DatabaseTable, DatabaseTable> getTableAliases() {
        return this.statement.getTableAliases();
    }

    protected ForUpdateClause getForUpdateClause() {
        return this.statement.getForUpdateClause();
    }
}

