/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import org.eclipse.persistence.internal.jpa.deployment.ArchiveBase;
import org.eclipse.persistence.jpa.Archive;

public class JarFileArchive
extends ArchiveBase
implements Archive {
    private JarFile jarFile;
    private Logger logger;

    public JarFileArchive(URL rootUrl, JarFile jarFile, String descriptorLocation) throws MalformedURLException {
        this(rootUrl, jarFile, descriptorLocation, Logger.global);
    }

    public JarFileArchive(URL rootUrl, JarFile jarFile, String descriptorLocation, Logger logger) throws MalformedURLException {
        super(rootUrl, descriptorLocation);
        logger.entering("JarFileArchive", "JarFileArchive", new Object[]{jarFile});
        this.logger = logger;
        this.jarFile = jarFile;
        this.descriptorLocation = descriptorLocation;
        logger.logp(Level.FINER, "JarFileArchive", "JarFileArchive", "rootURL = {0}", this.rootURL);
    }

    @Override
    public Iterator<String> getEntries() {
        Enumeration<JarEntry> jarEntries = this.jarFile.entries();
        ArrayList<String> result2 = new ArrayList<String>();
        while (jarEntries.hasMoreElements()) {
            JarEntry jarEntry = jarEntries.nextElement();
            if (jarEntry.isDirectory()) continue;
            result2.add(jarEntry.getName());
        }
        return result2.iterator();
    }

    @Override
    public InputStream getEntry(String entryPath) throws IOException {
        InputStream is = null;
        ZipEntry entry2 = this.jarFile.getEntry(entryPath);
        if (entry2 != null) {
            is = this.jarFile.getInputStream(entry2);
        }
        return is;
    }

    @Override
    public URL getEntryAsURL(String entryPath) throws IOException {
        return this.jarFile.getEntry(entryPath) != null ? new URL("jar:" + new File(this.jarFile.getName()).toURI().toURL() + "!/" + entryPath) : null;
    }

    @Override
    public void close() {
        try {
            this.jarFile.close();
        }
        catch (IOException iOException) {}
    }
}

