/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.descriptors.InstanceVariableAttributeAccessor;
import org.eclipse.persistence.internal.descriptors.MethodAttributeAccessor;
import org.eclipse.persistence.internal.jpa.jpql.Declaration;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.internal.jpa.jpql.NumericTypeComparator;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.MappedKeyMapContainerPolicy;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.parser.AbsExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractEclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.AbstractPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSchemaName;
import org.eclipse.persistence.jpa.jpql.parser.AdditionExpression;
import org.eclipse.persistence.jpa.jpql.parser.AllOrAnyExpression;
import org.eclipse.persistence.jpa.jpql.parser.AndExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticExpression;
import org.eclipse.persistence.jpa.jpql.parser.ArithmeticFactor;
import org.eclipse.persistence.jpa.jpql.parser.AsOfClause;
import org.eclipse.persistence.jpa.jpql.parser.AvgFunction;
import org.eclipse.persistence.jpa.jpql.parser.BadExpression;
import org.eclipse.persistence.jpa.jpql.parser.BetweenExpression;
import org.eclipse.persistence.jpa.jpql.parser.CaseExpression;
import org.eclipse.persistence.jpa.jpql.parser.CastExpression;
import org.eclipse.persistence.jpa.jpql.parser.CoalesceExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.CollectionMemberExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionValuedPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.ComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConcatExpression;
import org.eclipse.persistence.jpa.jpql.parser.ConnectByClause;
import org.eclipse.persistence.jpa.jpql.parser.ConstructorExpression;
import org.eclipse.persistence.jpa.jpql.parser.CountFunction;
import org.eclipse.persistence.jpa.jpql.parser.DatabaseType;
import org.eclipse.persistence.jpa.jpql.parser.DateTime;
import org.eclipse.persistence.jpa.jpql.parser.DeleteClause;
import org.eclipse.persistence.jpa.jpql.parser.DeleteStatement;
import org.eclipse.persistence.jpa.jpql.parser.DivisionExpression;
import org.eclipse.persistence.jpa.jpql.parser.EclipseLinkExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.EmptyCollectionComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.EntityTypeLiteral;
import org.eclipse.persistence.jpa.jpql.parser.EntryExpression;
import org.eclipse.persistence.jpa.jpql.parser.ExistsExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExtractExpression;
import org.eclipse.persistence.jpa.jpql.parser.FromClause;
import org.eclipse.persistence.jpa.jpql.parser.FunctionExpression;
import org.eclipse.persistence.jpa.jpql.parser.GroupByClause;
import org.eclipse.persistence.jpa.jpql.parser.HavingClause;
import org.eclipse.persistence.jpa.jpql.parser.HierarchicalQueryClause;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.InExpression;
import org.eclipse.persistence.jpa.jpql.parser.IndexExpression;
import org.eclipse.persistence.jpa.jpql.parser.InputParameter;
import org.eclipse.persistence.jpa.jpql.parser.JPQLExpression;
import org.eclipse.persistence.jpa.jpql.parser.Join;
import org.eclipse.persistence.jpa.jpql.parser.KeyExpression;
import org.eclipse.persistence.jpa.jpql.parser.KeywordExpression;
import org.eclipse.persistence.jpa.jpql.parser.LengthExpression;
import org.eclipse.persistence.jpa.jpql.parser.LikeExpression;
import org.eclipse.persistence.jpa.jpql.parser.LocateExpression;
import org.eclipse.persistence.jpa.jpql.parser.LowerExpression;
import org.eclipse.persistence.jpa.jpql.parser.MaxFunction;
import org.eclipse.persistence.jpa.jpql.parser.MinFunction;
import org.eclipse.persistence.jpa.jpql.parser.ModExpression;
import org.eclipse.persistence.jpa.jpql.parser.MultiplicationExpression;
import org.eclipse.persistence.jpa.jpql.parser.NotExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullComparisonExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullExpression;
import org.eclipse.persistence.jpa.jpql.parser.NullIfExpression;
import org.eclipse.persistence.jpa.jpql.parser.NumericLiteral;
import org.eclipse.persistence.jpa.jpql.parser.ObjectExpression;
import org.eclipse.persistence.jpa.jpql.parser.OnClause;
import org.eclipse.persistence.jpa.jpql.parser.OrExpression;
import org.eclipse.persistence.jpa.jpql.parser.OrderByClause;
import org.eclipse.persistence.jpa.jpql.parser.OrderByItem;
import org.eclipse.persistence.jpa.jpql.parser.OrderSiblingsByClause;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.RegexpExpression;
import org.eclipse.persistence.jpa.jpql.parser.ResultVariable;
import org.eclipse.persistence.jpa.jpql.parser.SelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SimpleFromClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectClause;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.jpa.jpql.parser.SizeExpression;
import org.eclipse.persistence.jpa.jpql.parser.SqrtExpression;
import org.eclipse.persistence.jpa.jpql.parser.StartWithClause;
import org.eclipse.persistence.jpa.jpql.parser.StateFieldPathExpression;
import org.eclipse.persistence.jpa.jpql.parser.StringLiteral;
import org.eclipse.persistence.jpa.jpql.parser.SubExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubstringExpression;
import org.eclipse.persistence.jpa.jpql.parser.SubtractionExpression;
import org.eclipse.persistence.jpa.jpql.parser.SumFunction;
import org.eclipse.persistence.jpa.jpql.parser.TableExpression;
import org.eclipse.persistence.jpa.jpql.parser.TableVariableDeclaration;
import org.eclipse.persistence.jpa.jpql.parser.TreatExpression;
import org.eclipse.persistence.jpa.jpql.parser.TrimExpression;
import org.eclipse.persistence.jpa.jpql.parser.TypeExpression;
import org.eclipse.persistence.jpa.jpql.parser.UnionClause;
import org.eclipse.persistence.jpa.jpql.parser.UnknownExpression;
import org.eclipse.persistence.jpa.jpql.parser.UpdateClause;
import org.eclipse.persistence.jpa.jpql.parser.UpdateItem;
import org.eclipse.persistence.jpa.jpql.parser.UpdateStatement;
import org.eclipse.persistence.jpa.jpql.parser.UpperExpression;
import org.eclipse.persistence.jpa.jpql.parser.ValueExpression;
import org.eclipse.persistence.jpa.jpql.parser.WhenClause;
import org.eclipse.persistence.jpa.jpql.parser.WhereClause;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.DirectMapMapping;
import org.eclipse.persistence.mappings.querykeys.DirectQueryKey;
import org.eclipse.persistence.mappings.querykeys.ForeignReferenceQueryKey;
import org.eclipse.persistence.mappings.querykeys.QueryKey;

final class TypeResolver
implements EclipseLinkExpressionVisitor {
    private CollectionExpressionVisitor collectionExpressionVisitor;
    private Comparator<Class<?>> numericTypeComparator;
    private PathResolver pathResolver;
    private final JPQLQueryContext queryContext;
    private Class<?> type;
    private static final Class<?> UNRESOLVABLE_TYPE = TypeResolver.class;

    TypeResolver(JPQLQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    Class<?> calculateMappingType(DatabaseMapping mapping) {
        AttributeAccessor accessor;
        ClassDescriptor descriptor;
        if (mapping.isAggregateMapping() && (descriptor = ((AggregateMapping)mapping).getReferenceDescriptor()) != null) {
            return descriptor.getJavaClass();
        }
        if (mapping.isForeignReferenceMapping()) {
            descriptor = mapping.getReferenceDescriptor();
            if (descriptor != null) {
                return descriptor.getJavaClass();
            }
        } else if (mapping.isCollectionMapping()) {
            return mapping.getContainerPolicy().getContainerClass();
        }
        if ((accessor = mapping.getAttributeAccessor()).isInstanceVariableAttributeAccessor()) {
            InstanceVariableAttributeAccessor attributeAccessor = (InstanceVariableAttributeAccessor)accessor;
            Field field2 = attributeAccessor.getAttributeField();
            if (field2 == null) {
                try {
                    field2 = mapping.getDescriptor().getJavaClass().getDeclaredField(attributeAccessor.getAttributeName());
                }
                catch (Exception exception) {}
            }
            return field2.getType();
        }
        if (accessor.isMethodAttributeAccessor()) {
            MethodAttributeAccessor methodAccessor = (MethodAttributeAccessor)accessor;
            Method method = methodAccessor.getGetMethod();
            if (method == null) {
                try {
                    method = mapping.getDescriptor().getJavaClass().getDeclaredMethod(methodAccessor.getGetMethodName(), new Class[0]);
                }
                catch (Exception exception) {}
            }
            return method.getReturnType();
        }
        return accessor.getAttributeClass();
    }

    Class<?> calculateQueryKeyType(QueryKey queryKey) {
        if (queryKey.isForeignReferenceQueryKey()) {
            ForeignReferenceQueryKey foreignReferenceQueryKey = (ForeignReferenceQueryKey)queryKey;
            return foreignReferenceQueryKey.getReferenceClass();
        }
        DirectQueryKey key = (DirectQueryKey)queryKey;
        Class<Object> type = key.getField().getType();
        return type != null ? type : Object.class;
    }

    protected CollectionExpressionVisitor collectionExpressionVisitor() {
        if (this.collectionExpressionVisitor == null) {
            this.collectionExpressionVisitor = new CollectionExpressionVisitor();
        }
        return this.collectionExpressionVisitor;
    }

    Class<?> compareCollectionEquivalentTypes(List<Class<?>> types) {
        Class<?> localType = null;
        for (Class<?> anotherType : types) {
            if (anotherType == UNRESOLVABLE_TYPE) continue;
            if (localType == null) {
                localType = anotherType;
                continue;
            }
            if (localType == anotherType) continue;
            return Object.class;
        }
        if (localType == null) {
            localType = UNRESOLVABLE_TYPE;
        }
        return localType;
    }

    Class<?> convertSumFunctionType(Class<?> type) {
        if (type == Integer.TYPE || type == Integer.class || type == Long.TYPE || type == Long.class || type == Byte.TYPE || type == Byte.class || type == Short.TYPE || type == Short.class || type == Character.TYPE || type == Character.class) {
            type = Long.class;
        } else if (type == Float.TYPE || type == Float.class || type == Double.TYPE || type == Double.class) {
            type = Double.class;
        } else if (type != BigDecimal.class && type != BigInteger.class) {
            type = Object.class;
        }
        return type;
    }

    private CollectionExpression getCollectionExpression(Expression expression) {
        CollectionExpressionVisitor visitor = this.collectionExpressionVisitor();
        try {
            expression.accept(visitor);
            CollectionExpression collectionExpression = visitor.expression;
            return collectionExpression;
        }
        finally {
            visitor.expression = null;
        }
    }

    private boolean isNumericType() {
        return this.type == Integer.TYPE || this.type == Integer.class || this.type == Long.TYPE || this.type == Long.class || this.type == Float.TYPE || this.type == Float.class || this.type == Double.TYPE || this.type == Double.class || this.type == BigInteger.class || this.type == BigDecimal.class;
    }

    private PathResolver pathResolver() {
        if (this.pathResolver == null) {
            this.pathResolver = new PathResolver();
        }
        return this.pathResolver;
    }

    Class<?> resolve(Expression expression) {
        Class<?> oldType = this.type;
        try {
            expression.accept(this);
            Class clazz = this.type == UNRESOLVABLE_TYPE ? Object.class : this.type;
            return clazz;
        }
        finally {
            this.type = oldType;
        }
    }

    ClassDescriptor resolveDescriptor(Expression expression) {
        PathResolver resolver = this.pathResolver();
        DatabaseMapping oldMapping = resolver.mapping;
        ClassDescriptor oldDescriptor = resolver.descriptor;
        try {
            resolver.mapping = null;
            resolver.descriptor = null;
            expression.accept(resolver);
            ClassDescriptor classDescriptor = resolver.descriptor;
            return classDescriptor;
        }
        finally {
            resolver.mapping = oldMapping;
            resolver.descriptor = oldDescriptor;
        }
    }

    DatabaseMapping resolveMapping(Expression expression) {
        PathResolver resolver = this.pathResolver();
        QueryKey oldQueryKey = resolver.queryKey;
        DatabaseMapping oldMapping = resolver.mapping;
        ClassDescriptor oldDescriptor = resolver.descriptor;
        try {
            resolver.mapping = null;
            resolver.descriptor = null;
            resolver.queryKey = null;
            expression.accept(resolver);
            DatabaseMapping databaseMapping = resolver.mapping;
            return databaseMapping;
        }
        finally {
            resolver.mapping = oldMapping;
            resolver.queryKey = oldQueryKey;
            resolver.descriptor = oldDescriptor;
        }
    }

    Object resolveMappingObject(Expression expression) {
        PathResolver resolver = this.pathResolver();
        QueryKey oldQueryKey = resolver.queryKey;
        DatabaseMapping oldMapping = resolver.mapping;
        ClassDescriptor oldDescriptor = resolver.descriptor;
        try {
            resolver.mapping = null;
            resolver.descriptor = null;
            resolver.queryKey = null;
            expression.accept(resolver);
            Cloneable cloneable = resolver.mapping != null ? resolver.mapping : resolver.queryKey;
            return cloneable;
        }
        finally {
            resolver.mapping = oldMapping;
            resolver.queryKey = oldQueryKey;
            resolver.descriptor = oldDescriptor;
        }
    }

    private Class<?> resolveMappingType(AbstractPathExpression expression) {
        PathResolver resolver = this.pathResolver();
        QueryKey oldQueryKey = resolver.queryKey;
        DatabaseMapping oldMapping = resolver.mapping;
        ClassDescriptor oldDescriptor = resolver.descriptor;
        try {
            resolver.mapping = null;
            resolver.descriptor = null;
            resolver.queryKey = null;
            expression.accept(resolver);
            if (resolver.mapping != null) {
                Class<?> clazz = this.calculateMappingType(resolver.mapping);
                return clazz;
            }
            if (resolver.queryKey != null) {
                Class<?> clazz = this.calculateQueryKeyType(resolver.queryKey);
                return clazz;
            }
            Class<?> clazz = this.queryContext.getEnumType(expression.toParsedText());
            return clazz;
        }
        finally {
            resolver.mapping = oldMapping;
            resolver.queryKey = oldQueryKey;
            resolver.descriptor = oldDescriptor;
        }
    }

    QueryKey resolveQueryKey(Expression expression) {
        PathResolver resolver = this.pathResolver();
        QueryKey oldQueryKey = resolver.queryKey;
        DatabaseMapping oldMapping = resolver.mapping;
        ClassDescriptor oldDescriptor = resolver.descriptor;
        try {
            resolver.mapping = null;
            resolver.descriptor = null;
            resolver.queryKey = null;
            expression.accept(resolver);
            QueryKey queryKey = resolver.queryKey;
            return queryKey;
        }
        finally {
            resolver.mapping = oldMapping;
            resolver.queryKey = oldQueryKey;
            resolver.descriptor = oldDescriptor;
        }
    }

    @Override
    public void visit(AbsExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(AbstractSchemaName expression) {
        ClassDescriptor descriptor = this.queryContext.getDescriptor(expression.getText());
        this.type = descriptor.getJavaClass();
    }

    @Override
    public void visit(AdditionExpression expression) {
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(AllOrAnyExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(AndExpression expression) {
        this.type = Boolean.class;
    }

    @Override
    public void visit(ArithmeticFactor expression) {
        expression.getExpression().accept(this);
        if (!this.isNumericType()) {
            this.type = Object.class;
        }
    }

    @Override
    public void visit(AsOfClause expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(AvgFunction expression) {
        this.type = Double.class;
    }

    @Override
    public void visit(BadExpression expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(BetweenExpression expression) {
        this.type = Boolean.class;
    }

    @Override
    public void visit(CaseExpression expression) {
        this.visitCollectionEquivalentExpression(expression.getWhenClauses(), expression.getElseExpression());
    }

    @Override
    public void visit(CastExpression expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(CoalesceExpression expression) {
        this.visitCollectionEquivalentExpression(expression.getExpression(), null);
    }

    @Override
    public void visit(CollectionExpression expression) {
        expression.acceptChildren(this);
    }

    @Override
    public void visit(CollectionMemberDeclaration expression) {
        expression.getCollectionValuedPathExpression().accept(this);
    }

    @Override
    public void visit(CollectionMemberExpression expression) {
        this.type = Boolean.class;
    }

    @Override
    public void visit(CollectionValuedPathExpression expression) {
        this.type = this.resolveMappingType(expression);
    }

    @Override
    public void visit(ComparisonExpression expression) {
        this.type = Boolean.class;
    }

    @Override
    public void visit(ConcatExpression expression) {
        this.type = String.class;
    }

    @Override
    public void visit(ConnectByClause expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(ConstructorExpression expression) {
        this.type = this.queryContext.getType(expression.getClassName());
    }

    @Override
    public void visit(CountFunction expression) {
        this.type = Long.class;
    }

    @Override
    public void visit(DatabaseType expression) {
    }

    @Override
    public void visit(DateTime expression) {
        String text;
        this.type = expression.isCurrentDate() ? Date.class : (expression.isCurrentTime() ? Time.class : (expression.isCurrentTimestamp() ? Timestamp.class : ((text = expression.getText()).startsWith("{d") ? Date.class : (text.startsWith("{ts") ? Timestamp.class : (text.startsWith("{t") ? Time.class : Object.class)))));
    }

    @Override
    public void visit(DeleteClause expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(DeleteStatement expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(DivisionExpression expression) {
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(EmptyCollectionComparisonExpression expression) {
        this.type = Boolean.class;
    }

    @Override
    public void visit(EntityTypeLiteral expression) {
        String entityTypeName = expression.getEntityTypeName();
        ClassDescriptor descriptor = this.queryContext.getDescriptor(entityTypeName);
        this.type = descriptor.getJavaClass();
    }

    @Override
    public void visit(EntryExpression expression) {
        this.type = Map.Entry.class;
    }

    @Override
    public void visit(ExistsExpression expression) {
        this.type = Boolean.class;
    }

    @Override
    public void visit(ExtractExpression expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(FromClause expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(FunctionExpression expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(GroupByClause expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(HavingClause expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(HierarchicalQueryClause expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(IdentificationVariable expression) {
        PathResolver resolver = this.pathResolver();
        DatabaseMapping oldMapping = resolver.mapping;
        ClassDescriptor oldDescriptor = resolver.descriptor;
        try {
            resolver.mapping = null;
            resolver.descriptor = null;
            expression.accept(resolver);
            this.type = resolver.mapping != null ? this.calculateMappingType(resolver.mapping) : (resolver.descriptor != null ? resolver.descriptor.getJavaClass() : Object.class);
        }
        finally {
            resolver.mapping = oldMapping;
            resolver.descriptor = oldDescriptor;
        }
    }

    @Override
    public void visit(IdentificationVariableDeclaration expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(IndexExpression expression) {
        this.type = Integer.class;
    }

    @Override
    public void visit(InExpression expression) {
        this.type = Boolean.class;
    }

    @Override
    public void visit(InputParameter expression) {
        this.type = UNRESOLVABLE_TYPE;
    }

    @Override
    public void visit(Join expression) {
        expression.getJoinAssociationPath().accept(this);
    }

    @Override
    public void visit(JPQLExpression expression) {
        expression.getQueryStatement().accept(this);
    }

    @Override
    public void visit(KeyExpression expression) {
        IdentificationVariable identificationVariable = (IdentificationVariable)expression.getExpression();
        Declaration declaration = this.queryContext.findDeclaration(identificationVariable.getVariableName());
        DatabaseMapping mapping = declaration.getMapping();
        MappedKeyMapContainerPolicy mapContainerPolicy = (MappedKeyMapContainerPolicy)mapping.getContainerPolicy();
        this.type = (Class)mapContainerPolicy.getKeyType();
    }

    @Override
    public void visit(KeywordExpression expression) {
        String text = expression.getText();
        this.type = text == "FALSE" || text == "TRUE" ? Boolean.class : Object.class;
    }

    @Override
    public void visit(LengthExpression expression) {
        this.type = Integer.class;
    }

    @Override
    public void visit(LikeExpression expression) {
        this.type = Boolean.class;
    }

    @Override
    public void visit(LocateExpression expression) {
        this.type = Integer.class;
    }

    @Override
    public void visit(LowerExpression expression) {
        this.type = String.class;
    }

    @Override
    public void visit(MaxFunction expression) {
        expression.getExpression().accept(this);
        if (!this.isNumericType()) {
            this.type = Object.class;
        }
    }

    @Override
    public void visit(MinFunction expression) {
        expression.getExpression().accept(this);
        if (!this.isNumericType()) {
            this.type = Object.class;
        }
    }

    @Override
    public void visit(ModExpression expression) {
        this.type = Integer.class;
    }

    @Override
    public void visit(MultiplicationExpression expression) {
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(NotExpression expression) {
        this.type = Boolean.class;
    }

    @Override
    public void visit(NullComparisonExpression expression) {
        this.type = Boolean.class;
    }

    @Override
    public void visit(NullExpression expression) {
        this.type = UNRESOLVABLE_TYPE;
    }

    @Override
    public void visit(NullIfExpression expression) {
        expression.getFirstExpression().accept(this);
    }

    @Override
    public void visit(NumericLiteral expression) {
        try {
            String text = expression.getText();
            if (ExpressionTools.LONG_REGEXP.matcher(text).matches() || ExpressionTools.INTEGER_REGEXP.matcher(text).matches()) {
                Long value2;
                this.type = text.endsWith("L") || text.endsWith("l") ? Long.class : ((value2 = Long.valueOf(Long.parseLong(text))) <= Integer.MAX_VALUE ? Integer.class : Long.class);
            } else if (ExpressionTools.FLOAT_REGEXP.matcher(text).matches()) {
                this.type = Float.class;
            } else if (ExpressionTools.DOUBLE_REGEXP.matcher(text).matches()) {
                this.type = Double.class;
            }
        }
        catch (Exception exception) {
            this.type = Object.class;
        }
    }

    @Override
    public void visit(ObjectExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(OnClause expression) {
        expression.getConditionalExpression().accept(this);
    }

    @Override
    public void visit(OrderByClause expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(OrderByItem expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(OrderSiblingsByClause expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(OrExpression expression) {
        this.type = Boolean.class;
    }

    @Override
    public void visit(RangeVariableDeclaration expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(RegexpExpression expression) {
        this.type = Boolean.class;
    }

    @Override
    public void visit(ResultVariable expression) {
        expression.getSelectExpression().accept(this);
    }

    @Override
    public void visit(SelectClause expression) {
        Expression selectExpression = expression.getSelectExpression();
        CollectionExpression collectionExpression = this.getCollectionExpression(selectExpression);
        if (collectionExpression != null) {
            this.type = Object[].class;
        } else {
            selectExpression.accept(this);
        }
    }

    @Override
    public void visit(SelectStatement expression) {
        expression.getSelectClause().accept(this);
    }

    @Override
    public void visit(SimpleFromClause expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(SimpleSelectClause expression) {
        expression.getSelectExpression().accept(this);
    }

    @Override
    public void visit(SimpleSelectStatement expression) {
        this.queryContext.newSubQueryContext(expression, null);
        try {
            expression.getSelectClause().accept(this);
        }
        finally {
            this.queryContext.disposeSubqueryContext();
        }
    }

    @Override
    public void visit(SizeExpression expression) {
        this.type = Integer.class;
    }

    @Override
    public void visit(SqrtExpression expression) {
        this.type = Double.class;
    }

    @Override
    public void visit(StartWithClause expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(StateFieldPathExpression expression) {
        this.type = this.resolveMappingType(expression);
    }

    @Override
    public void visit(StringLiteral expression) {
        this.type = String.class;
    }

    @Override
    public void visit(SubExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(SubstringExpression expression) {
        this.type = String.class;
    }

    @Override
    public void visit(SubtractionExpression expression) {
        this.visitArithmeticExpression(expression);
    }

    @Override
    public void visit(SumFunction expression) {
        expression.getExpression().accept(this);
        this.type = this.convertSumFunctionType(this.type);
    }

    @Override
    public void visit(TableExpression expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(TableVariableDeclaration expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(TreatExpression expression) {
        expression.getEntityType().accept(this);
    }

    @Override
    public void visit(TrimExpression expression) {
        this.type = String.class;
    }

    @Override
    public void visit(TypeExpression expression) {
        expression.getExpression().accept(this);
    }

    @Override
    public void visit(UnionClause expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(UnknownExpression expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(UpdateClause expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(UpdateItem expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(UpdateStatement expression) {
        this.type = Object.class;
    }

    @Override
    public void visit(UpperExpression expression) {
        this.type = String.class;
    }

    @Override
    public void visit(ValueExpression expression) {
        IdentificationVariable identificationVariable = (IdentificationVariable)expression.getExpression();
        Declaration declaration = this.queryContext.findDeclaration(identificationVariable.getVariableName());
        DatabaseMapping mapping = declaration.getMapping();
        if (mapping.isDirectMapMapping()) {
            DirectMapMapping mapMapping = (DirectMapMapping)mapping;
            this.type = mapMapping.getValueClass();
            if (this.type == null) {
                this.type = mapMapping.getDirectField().getType();
            }
        } else {
            this.type = this.calculateMappingType(declaration.getMapping());
        }
    }

    @Override
    public void visit(WhenClause expression) {
        expression.getThenExpression().accept(this);
    }

    @Override
    public void visit(WhereClause expression) {
        expression.getConditionalExpression().accept(this);
    }

    private void visitArithmeticExpression(ArithmeticExpression expression) {
        ArrayList types = new ArrayList(2);
        expression.getLeftExpression().accept(this);
        if (this.isNumericType()) {
            types.add(this.type);
        }
        expression.getRightExpression().accept(this);
        if (this.isNumericType()) {
            types.add(this.type);
        }
        if (types.size() == 2) {
            Collections.sort(types, NumericTypeComparator.instance());
            this.type = (Class)types.get(0);
        } else {
            this.type = Object.class;
        }
    }

    private void visitCollectionEquivalentExpression(Expression expression, Expression extraExpression) {
        ArrayList types = new ArrayList();
        CollectionExpression collectionExpression = this.getCollectionExpression(expression);
        if (collectionExpression != null) {
            for (Expression child : collectionExpression.children()) {
                child.accept(this);
                types.add(this.type);
            }
        } else {
            expression.accept(this);
            types.add(this.type);
        }
        if (extraExpression != null) {
            extraExpression.accept(this);
            types.add(this.type);
        }
        this.type = this.compareCollectionEquivalentTypes(types);
    }

    private static class CollectionExpressionVisitor
    extends AbstractExpressionVisitor {
        protected CollectionExpression expression;

        @Override
        public void visit(CollectionExpression expression) {
            this.expression = expression;
        }
    }

    private class PathResolver
    extends AbstractEclipseLinkExpressionVisitor {
        ClassDescriptor descriptor;
        DatabaseMapping mapping;
        QueryKey queryKey;

        private PathResolver() {
        }

        @Override
        public void visit(AbstractSchemaName expression) {
            this.descriptor = TypeResolver.this.queryContext.getDescriptor(expression.getText());
        }

        @Override
        public void visit(CollectionValuedPathExpression expression) {
            this.visitPathExpression(expression);
        }

        @Override
        public void visit(EntityTypeLiteral expression) {
            this.descriptor = TypeResolver.this.queryContext.getDescriptor(expression.getEntityTypeName());
        }

        @Override
        public void visit(IdentificationVariable expression) {
            StateFieldPathExpression pathExpression;
            StateFieldPathExpression stateFieldPathExpression = pathExpression = expression.isVirtual() ? expression.getStateFieldPathExpression() : null;
            if (pathExpression != null) {
                pathExpression.accept(this);
            } else {
                Declaration declaration = TypeResolver.this.queryContext.findDeclaration(expression.getVariableName());
                if (declaration != null) {
                    this.descriptor = declaration.getDescriptor();
                }
            }
        }

        @Override
        public void visit(Join expression) {
            expression.getJoinAssociationPath().accept(this);
        }

        @Override
        public void visit(KeyExpression expression) {
            IdentificationVariable identificationVariable = (IdentificationVariable)expression.getExpression();
            Declaration declaration = TypeResolver.this.queryContext.getDeclaration(identificationVariable.getVariableName());
            DatabaseMapping mapping = declaration.getMapping();
            ContainerPolicy containerPolicy = mapping.getContainerPolicy();
            MappedKeyMapContainerPolicy mapPolicy = (MappedKeyMapContainerPolicy)containerPolicy;
            this.descriptor = mapPolicy.getKeyMapping().getReferenceDescriptor();
        }

        @Override
        public void visit(RangeVariableDeclaration expression) {
            expression.getIdentificationVariable().accept(this);
        }

        @Override
        public void visit(StateFieldPathExpression expression) {
            this.visitPathExpression(expression);
        }

        @Override
        public void visit(TreatExpression expression) {
            expression.getEntityType().accept(this);
        }

        @Override
        public void visit(ValueExpression expression) {
            IdentificationVariable identificationVariable = (IdentificationVariable)expression.getExpression();
            Declaration declaration = TypeResolver.this.queryContext.getDeclaration(identificationVariable.getVariableName());
            this.descriptor = declaration.getDescriptor();
        }

        private void visitPathExpression(AbstractPathExpression expression) {
            expression.getIdentificationVariable().accept(this);
            if (this.descriptor == null) {
                return;
            }
            int index = expression.hasVirtualIdentificationVariable() ? 0 : 1;
            int count2 = expression.pathSize();
            while (index < count2) {
                String path = expression.getPath(index);
                this.mapping = this.descriptor.getObjectBuilder().getMappingForAttributeName(path);
                if (this.mapping == null) {
                    this.queryKey = this.descriptor.getQueryKeyNamed(path);
                    if (this.queryKey != null && this.queryKey.isForeignReferenceQueryKey()) {
                        ForeignReferenceQueryKey referenceQueryKey = (ForeignReferenceQueryKey)this.queryKey;
                        this.descriptor = TypeResolver.this.queryContext.getDescriptor(referenceQueryKey.getReferenceClass());
                    } else {
                        if (index + 1 < count2) {
                            this.mapping = null;
                        }
                        this.descriptor = null;
                    }
                } else if (this.mapping.isCollectionMapping() && index + 1 < count2) {
                    this.mapping = null;
                    this.descriptor = null;
                } else {
                    this.descriptor = this.mapping.getReferenceDescriptor();
                }
                if (this.descriptor == null) {
                    if (index + 1 >= count2) break;
                    this.mapping = null;
                    break;
                }
                ++index;
            }
        }
    }
}

