/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.mappings.EmbeddableMapping;

public class EmbeddedIdAccessor
extends EmbeddedAccessor {
    protected HashMap<String, DatabaseField> m_idFields = new HashMap();
    protected HashMap<DatabaseField, MappingAccessor> m_idAccessors = new HashMap();

    public EmbeddedIdAccessor() {
        super("<embedded-id>");
    }

    public EmbeddedIdAccessor(MetadataAnnotation embeddedId, MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(embeddedId, accessibleObject, classAccessor);
    }

    @Override
    protected void addFieldNameTranslation(EmbeddableMapping embeddableMapping, String overrideName, DatabaseField overrideField, MappingAccessor mappingAccessor) {
        super.addFieldNameTranslation(embeddableMapping, overrideName, overrideField, mappingAccessor);
        this.m_idFields.put(mappingAccessor.getAttributeName(), overrideField);
    }

    protected void addIdFieldFromAccessor(MappingAccessor accessor) {
        String attributeName = accessor.getAttributeName();
        if (this.m_idFields.containsKey(attributeName)) {
            this.m_idAccessors.put(this.m_idFields.get(attributeName), accessor);
        } else {
            DatabaseField field2 = accessor.getMapping().getField();
            this.m_idFields.put(attributeName, field2);
            this.m_idAccessors.put(field2, accessor);
        }
    }

    protected void addIdFieldsFromAccessors(Collection<MappingAccessor> accessors) {
        for (MappingAccessor accessor : accessors) {
            if (accessor.isBasic()) {
                this.addIdFieldFromAccessor(accessor);
                continue;
            }
            if (accessor.isDerivedIdClass() || accessor.isEmbedded()) {
                this.addIdFieldsFromAccessors(accessor.getReferenceAccessors());
                continue;
            }
            throw ValidationException.invalidMappingForEmbeddedId(this.getAttributeName(), this.getJavaClass(), accessor.getAttributeName(), this.getReferenceDescriptor().getJavaClass());
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        return super.equals(objectToCompare) && objectToCompare instanceof EmbeddedIdAccessor;
    }

    @Override
    public boolean isEmbeddedId() {
        return true;
    }

    @Override
    public void process() {
        super.process();
        if (this.getReferenceAccessors().isEmpty()) {
            throw ValidationException.embeddedIdHasNoAttributes(this.getDescriptor().getJavaClass(), this.getReferenceDescriptor().getJavaClass(), this.getReferenceDescriptor().getClassAccessor().getAccessType());
        }
        this.addIdFieldsFromAccessors(this.getReferenceAccessors());
        this.getMapping().setIsJPAId();
        for (MetadataDescriptor owningDescriptor : this.getOwningDescriptors()) {
            if (owningDescriptor.hasPrimaryKeyFields()) {
                throw ValidationException.embeddedIdAndIdAnnotationFound(this.getJavaClass(), this.getAttributeName(), owningDescriptor.getIdAttributeName());
            }
            owningDescriptor.setPKClass(this.getReferenceClass());
            owningDescriptor.setEmbeddedIdAccessor(this);
            for (DatabaseField field2 : this.m_idFields.values()) {
                if (owningDescriptor.getPrimaryKeyFields().contains(field2)) continue;
                DatabaseField clone2 = field2.clone();
                if (clone2.getTableName().equals("")) {
                    clone2.setTable(owningDescriptor.getPrimaryTable());
                }
                owningDescriptor.addPrimaryKeyField(clone2, this.m_idAccessors.get(clone2));
            }
        }
    }
}

