/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import org.eclipse.persistence.descriptors.SingleTableMultitenantPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MultitenantIdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.columns.DiscriminatorColumnMetadata;

public class TenantDiscriminatorColumnMetadata
extends DiscriminatorColumnMetadata {
    public static final String NAME_DEFAULT = "TENANT_ID";
    private Boolean m_primaryKey;
    private String m_table;
    private String m_contextProperty;

    public TenantDiscriminatorColumnMetadata() {
        super("<tenant-discriminator-column>");
    }

    public TenantDiscriminatorColumnMetadata(MetadataAccessor accessor) {
        super(accessor);
    }

    public TenantDiscriminatorColumnMetadata(MetadataAnnotation tenantDiscriminator, MetadataAccessor accessor) {
        super(tenantDiscriminator, accessor);
        this.m_table = tenantDiscriminator.getAttributeString("table");
        this.m_primaryKey = tenantDiscriminator.getAttributeBooleanDefaultFalse("primaryKey");
        this.m_contextProperty = tenantDiscriminator.getAttributeString("contextProperty");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (super.equals(objectToCompare) && objectToCompare instanceof TenantDiscriminatorColumnMetadata) {
            TenantDiscriminatorColumnMetadata tenantDiscriminator = (TenantDiscriminatorColumnMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_primaryKey, tenantDiscriminator.getPrimaryKey())) {
                return false;
            }
            if (!this.valuesMatch(this.m_contextProperty, tenantDiscriminator.getContextProperty())) {
                return false;
            }
            return this.valuesMatch(this.m_table, tenantDiscriminator.getTable());
        }
        return false;
    }

    public String getContextProperty() {
        return this.m_contextProperty;
    }

    @Override
    public DatabaseField getDatabaseField() {
        DatabaseField field2 = super.getDatabaseField();
        if (this.m_table != null) {
            field2.setTableName(this.m_table);
        }
        field2.setPrimaryKey(this.m_primaryKey == null ? false : this.m_primaryKey);
        return field2;
    }

    public Boolean getPrimaryKey() {
        return this.m_primaryKey;
    }

    public String getTable() {
        return this.m_table;
    }

    public void process(MetadataDescriptor descriptor, SingleTableMultitenantPolicy policy) {
        DatabaseField tenantDiscriminatorField = this.getDatabaseField();
        this.setFieldName(tenantDiscriminatorField, NAME_DEFAULT, "metadata_default_tenant_discriminator_column");
        if (!tenantDiscriminatorField.hasTableName()) {
            tenantDiscriminatorField.setTable(descriptor.getPrimaryTable());
        }
        if (this.m_contextProperty == null) {
            this.getLogger().logWarningMessage("metadata_default_tenant_discriminator_context_property", this.getAccessibleObject(), tenantDiscriminatorField, "eclipselink.tenant-id");
            this.m_contextProperty = "eclipselink.tenant-id";
        }
        policy.addTenantDiscriminatorField(this.m_contextProperty, tenantDiscriminatorField);
        if (tenantDiscriminatorField.isPrimaryKey()) {
            MultitenantIdAccessor idAccessor = new MultitenantIdAccessor(this.m_contextProperty, tenantDiscriminatorField, this.getAccessibleObject(), descriptor.getClassAccessor());
            descriptor.addMappingAccessor(idAccessor);
        }
    }

    public void setContextProperty(String contextProperty) {
        this.m_contextProperty = contextProperty;
    }

    public void setPrimaryKey(Boolean primaryKey) {
        this.m_primaryKey = primaryKey;
    }

    public void setTable(String table) {
        this.m_table = table;
    }
}

