/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.mappings;

import org.eclipse.persistence.annotations.BatchFetchType;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;

public class BatchFetchMetadata
extends ORMetadata {
    private Integer m_size;
    private String m_type;

    public BatchFetchMetadata() {
        super("<batch-fetch>");
    }

    public BatchFetchMetadata(MetadataAnnotation batchFetch, MetadataAccessor accessor) {
        super(batchFetch, accessor);
        this.m_type = batchFetch.getAttributeString("value");
        this.m_size = batchFetch.getAttributeInteger("size");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof BatchFetchMetadata) {
            BatchFetchMetadata batchFetch = (BatchFetchMetadata)objectToCompare;
            if (!this.valuesMatch(this.m_type, batchFetch.getType())) {
                return false;
            }
            return this.valuesMatch(this.m_size, batchFetch.getSize());
        }
        return false;
    }

    public Integer getSize() {
        return this.m_size;
    }

    public String getType() {
        return this.m_type;
    }

    public void process(ForeignReferenceMapping mapping) {
        mapping.setBatchFetchType(BatchFetchType.valueOf(this.getType()));
    }

    public void setSize(Integer size2) {
        this.m_size = size2;
    }

    public void setType(String type) {
        this.m_type = type;
    }
}

