/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.partitioning;

import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;

public class RangePartitionMetadata
extends ORMetadata {
    protected String connectionPool;
    protected String startValue;
    protected String endValue;

    public RangePartitionMetadata() {
        super("<range-partition>");
    }

    public RangePartitionMetadata(MetadataAnnotation annotation, MetadataAccessor accessor) {
        super(annotation, accessor);
        this.connectionPool = annotation.getAttributeString("connectionPool");
        this.startValue = annotation.getAttributeString("startValue");
        this.endValue = annotation.getAttributeString("endValue");
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof RangePartitionMetadata) {
            RangePartitionMetadata partition2 = (RangePartitionMetadata)objectToCompare;
            return this.valuesMatch(this.connectionPool, partition2.getConnectionPool()) && this.valuesMatch(this.startValue, partition2.getStartValue()) && this.valuesMatch(this.endValue, partition2.getEndValue());
        }
        return false;
    }

    public String getConnectionPool() {
        return this.connectionPool;
    }

    public String getEndValue() {
        return this.endValue;
    }

    public String getStartValue() {
        return this.startValue;
    }

    public void setConnectionPool(String connectionPool) {
        this.connectionPool = connectionPool;
    }

    public void setEndValue(String endValue) {
        this.endValue = endValue;
    }

    public void setStartValue(String startValue) {
        this.startValue = startValue;
    }
}

