/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.queries.ColumnResult;

public class ColumnResultMetadata
extends ORMetadata {
    private MetadataClass type;
    private String name;
    private String typeName;

    public ColumnResultMetadata() {
        super("<column-result>");
    }

    public ColumnResultMetadata(MetadataAnnotation columnResult, MetadataAccessor accessor) {
        super(columnResult, accessor);
        this.name = columnResult.getAttributeString("name");
        this.type = this.getMetadataClass(columnResult.getAttributeString("type"));
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof ColumnResultMetadata) {
            ColumnResultMetadata columnResult = (ColumnResultMetadata)objectToCompare;
            if (!this.valuesMatch(this.getName(), columnResult.getName())) {
                return false;
            }
            return this.valuesMatch(this.getType(), columnResult.getType());
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public MetadataClass getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.setType(this.initXMLClassName(this.getTypeName()));
    }

    public ColumnResult process() {
        DatabaseField field2 = new DatabaseField();
        this.setFieldName(field2, this.getName());
        if (!this.getType().isVoid()) {
            field2.setTypeName(this.getJavaClassName(this.getType()));
        }
        return new ColumnResult(field2);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(MetadataClass type) {
        this.type = type;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }
}

