/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLComplexTypeMetadata;
import org.eclipse.persistence.internal.jpa.metadata.queries.PLSQLParameterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLrecord;

public class PLSQLRecordMetadata
extends PLSQLComplexTypeMetadata {
    private List<PLSQLParameterMetadata> fields = new ArrayList<PLSQLParameterMetadata>();

    public PLSQLRecordMetadata() {
        super("<plsql-record>");
    }

    public PLSQLRecordMetadata(MetadataAnnotation record2, MetadataAccessor accessor) {
        super(record2, accessor);
        Object[] objectArray = record2.getAttributeArray("fields");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object field2 = objectArray[n2];
            this.fields.add(new PLSQLParameterMetadata((MetadataAnnotation)field2, accessor));
            ++n2;
        }
    }

    @Override
    public boolean equals(Object objectToCompare) {
        PLSQLRecordMetadata parameter;
        if (objectToCompare instanceof PLSQLRecordMetadata && !this.valuesMatch(this.fields, (parameter = (PLSQLRecordMetadata)objectToCompare).getFields())) {
            return false;
        }
        return super.equals(objectToCompare);
    }

    public List<PLSQLParameterMetadata> getFields() {
        return this.fields;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject accessibleObject, XMLEntityMappings entityMappings) {
        super.initXMLObject(accessibleObject, entityMappings);
        this.initXMLObjects(this.fields, accessibleObject);
    }

    @Override
    public PLSQLrecord process() {
        PLSQLrecord record2 = new PLSQLrecord();
        super.process(record2);
        for (PLSQLParameterMetadata field2 : this.fields) {
            PLSQLargument argument = new PLSQLargument();
            argument.name = field2.getName();
            argument.databaseType = this.getDatabaseTypeEnum(field2.getDatabaseType());
            if (field2.getLength() != null) {
                argument.length = field2.getLength();
            }
            if (field2.getPrecision() != null) {
                argument.precision = field2.getPrecision();
            }
            if (field2.getScale() != null) {
                argument.scale = field2.getScale();
            }
            record2.addField(argument);
        }
        return record2;
    }

    public void setFields(List<PLSQLParameterMetadata> fields) {
        this.fields = fields;
    }

    @Override
    public boolean isPLSQLRecordMetadata() {
        return true;
    }
}

