/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.weaving;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.internal.descriptors.VirtualAttributeMethodInfo;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.weaving.AttributeDetails;

public class ClassDetails {
    protected MetadataClass describedClass;
    protected String className;
    protected String superClassName;
    protected ClassDetails superClassDetails;
    protected boolean shouldWeaveValueHolders = false;
    protected boolean shouldWeaveChangeTracking = false;
    protected boolean shouldWeaveFetchGroups = false;
    protected boolean shouldWeaveInternal = false;
    protected boolean shouldWeaveRest = false;
    protected Map<String, AttributeDetails> attributesMap;
    protected Map<String, AttributeDetails> getterMethodToAttributeDetails;
    protected Map<String, AttributeDetails> setterMethodToAttributeDetails;
    protected boolean isMappedSuperClass = false;
    protected boolean isEmbedable = false;
    protected boolean usesAttributeAccess = false;
    protected boolean implementsCloneMethod = false;
    protected boolean shouldWeaveConstructorOptimization = true;
    protected List<VirtualAttributeMethodInfo> virtualAccessMethods = new ArrayList<VirtualAttributeMethodInfo>();

    public MetadataClass getDescribedClass() {
        return this.describedClass;
    }

    public String getClassName() {
        return this.className;
    }

    public void setDescribedClass(MetadataClass describedClass) {
        this.describedClass = describedClass;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getSuperClassName() {
        return this.superClassName;
    }

    public void setSuperClassName(String superClassName) {
        this.superClassName = superClassName;
    }

    public ClassDetails getSuperClassDetails() {
        return this.superClassDetails;
    }

    public void setSuperClassDetails(ClassDetails superClassDetails) {
        this.superClassDetails = superClassDetails;
    }

    public boolean shouldWeaveValueHolders() {
        return this.shouldWeaveValueHolders;
    }

    public void setShouldWeaveValueHolders(boolean shouldWeaveValueHolders) {
        this.shouldWeaveValueHolders = shouldWeaveValueHolders;
    }

    public boolean shouldWeaveChangeTracking() {
        return this.shouldWeaveChangeTracking;
    }

    public void setShouldWeaveChangeTracking(boolean shouldWeaveChangeTracking) {
        this.shouldWeaveChangeTracking = shouldWeaveChangeTracking;
    }

    public void setShouldWeaveConstructorOptimization(boolean shouldWeaveConstructorOptimization) {
        this.shouldWeaveConstructorOptimization = shouldWeaveConstructorOptimization;
    }

    public boolean shouldWeaveFetchGroups() {
        return this.shouldWeaveFetchGroups;
    }

    public void setShouldWeaveFetchGroups(boolean shouldWeaveFetchGroups) {
        this.shouldWeaveFetchGroups = shouldWeaveFetchGroups;
    }

    public boolean shouldWeaveInternal() {
        return this.shouldWeaveInternal;
    }

    public void setShouldWeaveInternal(boolean shouldWeaveInternal) {
        this.shouldWeaveInternal = shouldWeaveInternal;
    }

    public boolean shouldWeaveREST() {
        return this.shouldWeaveRest;
    }

    public void setShouldWeaveREST(boolean shouldWeaveRest) {
        this.shouldWeaveRest = shouldWeaveRest;
    }

    public Map<String, AttributeDetails> getAttributesMap() {
        return this.attributesMap;
    }

    public Map<String, AttributeDetails> getGetterMethodToAttributeDetails() {
        return this.getterMethodToAttributeDetails;
    }

    public Map<String, AttributeDetails> getSetterMethodToAttributeDetails() {
        return this.setterMethodToAttributeDetails;
    }

    public void setAttributesMap(Map<String, AttributeDetails> attributesMap) {
        this.attributesMap = attributesMap;
    }

    public void setGetterMethodToAttributeDetails(Map<String, AttributeDetails> map2) {
        this.getterMethodToAttributeDetails = map2;
    }

    public boolean getImplementsCloneMethod() {
        return this.implementsCloneMethod;
    }

    public VirtualAttributeMethodInfo getInfoForVirtualGetMethod(String getMethodName) {
        for (VirtualAttributeMethodInfo info : this.virtualAccessMethods) {
            if (info.getGetMethodName() == null || !info.getGetMethodName().equals(getMethodName)) continue;
            return info;
        }
        return null;
    }

    public VirtualAttributeMethodInfo getInfoForVirtualSetMethod(String setMethodName) {
        for (VirtualAttributeMethodInfo info : this.virtualAccessMethods) {
            if (info.getGetMethodName() == null || !info.getGetMethodName().equals(setMethodName)) continue;
            return info;
        }
        return null;
    }

    public void setImplementsCloneMethod(boolean implementsCloneMethod) {
        this.implementsCloneMethod = implementsCloneMethod;
    }

    public String getNameOfSuperclassImplementingCloneMethod() {
        if (this.superClassDetails == null) {
            return null;
        }
        if (this.superClassDetails.getImplementsCloneMethod()) {
            return this.superClassDetails.getClassName();
        }
        return this.superClassDetails.getNameOfSuperclassImplementingCloneMethod();
    }

    public List<VirtualAttributeMethodInfo> getVirtualAccessMethods() {
        return this.virtualAccessMethods;
    }

    public void setVirtualAccessMethods(List<VirtualAttributeMethodInfo> virtualAccessMethods) {
        this.virtualAccessMethods = virtualAccessMethods;
    }

    public boolean isMappedSuperClass() {
        return this.isMappedSuperClass;
    }

    public void setIsMappedSuperClass(boolean isMappedSuperClass) {
        this.isMappedSuperClass = isMappedSuperClass;
    }

    public boolean isEmbedable() {
        return this.isEmbedable;
    }

    public void setIsEmbedable(boolean isEmbedable) {
        this.isEmbedable = isEmbedable;
    }

    public void setSetterMethodToAttributeDetails(Map map2) {
        this.setterMethodToAttributeDetails = map2;
    }

    public boolean usesAttributeAccess() {
        return this.usesAttributeAccess;
    }

    public void useAttributeAccess() {
        this.usesAttributeAccess = true;
    }

    public AttributeDetails getAttributeDetailsFromClassOrSuperClass(String attributeName) {
        AttributeDetails attribute = this.attributesMap.get(attributeName);
        if (attribute == null && this.superClassDetails != null) {
            return this.superClassDetails.getAttributeDetailsFromClassOrSuperClass(attributeName);
        }
        return attribute;
    }

    public boolean doesSuperclassWeaveChangeTracking() {
        if (this.getSuperClassDetails() == null) {
            return false;
        }
        if (this.getSuperClassDetails().shouldWeaveChangeTracking()) {
            return true;
        }
        return this.getSuperClassDetails().doesSuperclassWeaveChangeTracking();
    }

    public boolean canWeaveChangeTracking() {
        if (this.getSuperClassDetails() == null || !this.shouldWeaveChangeTracking()) {
            return this.shouldWeaveChangeTracking();
        }
        return this.getSuperClassDetails().canWeaveChangeTracking();
    }

    public boolean canWeaveConstructorOptimization() {
        if (!this.shouldWeaveConstructorOptimization || this.getSuperClassDetails() == null) {
            return this.shouldWeaveConstructorOptimization;
        }
        return this.getSuperClassDetails().canWeaveConstructorOptimization();
    }

    public boolean isInMetadataHierarchy(String className) {
        if (className.equals(Object.class.getName().replace('.', '/'))) {
            return true;
        }
        if (className.equals(this.className) || this.superClassName != null && className.equals(this.superClassName)) {
            return true;
        }
        if (this.superClassDetails != null) {
            return this.superClassDetails.isInMetadataHierarchy(className);
        }
        return false;
    }

    public boolean isInSuperclassHierarchy(String className) {
        if (className.equals(Object.class.getName().replace('.', '/'))) {
            return true;
        }
        if (this.superClassName != null && className.equals(this.superClassName)) {
            return true;
        }
        if (this.superClassDetails != null) {
            return this.superClassDetails.isInMetadataHierarchy(className);
        }
        return false;
    }
}

