/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.libraries.antlr.runtime;

import org.eclipse.persistence.internal.libraries.antlr.runtime.CharStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.CommonToken;
import org.eclipse.persistence.internal.libraries.antlr.runtime.IntStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.Token;
import org.eclipse.persistence.internal.libraries.antlr.runtime.TokenStream;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.CommonTree;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.Tree;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.TreeAdaptor;
import org.eclipse.persistence.internal.libraries.antlr.runtime.tree.TreeNodeStream;

public class RecognitionException
extends Exception {
    public transient IntStream input;
    public int index;
    public Token token;
    public Object node;
    public int c;
    public int line;
    public int charPositionInLine;
    public boolean approximateLineInfo;

    public RecognitionException() {
    }

    public RecognitionException(IntStream input2) {
        this.input = input2;
        this.index = input2.index();
        if (input2 instanceof TokenStream) {
            this.token = ((TokenStream)input2).LT(1);
            this.line = this.token.getLine();
            this.charPositionInLine = this.token.getCharPositionInLine();
        }
        if (input2 instanceof TreeNodeStream) {
            this.extractInformationFromTreeNodeStream(input2);
        } else if (input2 instanceof CharStream) {
            this.c = input2.LA(1);
            this.line = ((CharStream)input2).getLine();
            this.charPositionInLine = ((CharStream)input2).getCharPositionInLine();
        } else {
            this.c = input2.LA(1);
        }
    }

    protected void extractInformationFromTreeNodeStream(IntStream input2) {
        TreeNodeStream nodes = (TreeNodeStream)input2;
        this.node = nodes.LT(1);
        TreeAdaptor adaptor = nodes.getTreeAdaptor();
        Token payload = adaptor.getToken(this.node);
        if (payload != null) {
            this.token = payload;
            if (payload.getLine() <= 0) {
                int i = -1;
                Object priorNode = nodes.LT(i);
                while (priorNode != null) {
                    Token priorPayload = adaptor.getToken(priorNode);
                    if (priorPayload != null && priorPayload.getLine() > 0) {
                        this.line = priorPayload.getLine();
                        this.charPositionInLine = priorPayload.getCharPositionInLine();
                        this.approximateLineInfo = true;
                        break;
                    }
                    priorNode = nodes.LT(--i);
                }
            } else {
                this.line = payload.getLine();
                this.charPositionInLine = payload.getCharPositionInLine();
            }
        } else if (this.node instanceof Tree) {
            this.line = ((Tree)this.node).getLine();
            this.charPositionInLine = ((Tree)this.node).getCharPositionInLine();
            if (this.node instanceof CommonTree) {
                this.token = ((CommonTree)this.node).token;
            }
        } else {
            int type = adaptor.getType(this.node);
            String text = adaptor.getText(this.node);
            this.token = new CommonToken(type, text);
        }
    }

    public int getUnexpectedType() {
        if (this.input instanceof TokenStream) {
            return this.token.getType();
        }
        if (this.input instanceof TreeNodeStream) {
            TreeNodeStream nodes = (TreeNodeStream)this.input;
            TreeAdaptor adaptor = nodes.getTreeAdaptor();
            return adaptor.getType(this.node);
        }
        return this.c;
    }
}

