/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.Map;
import java.util.Properties;
import org.eclipse.persistence.internal.oxm.Context;
import org.eclipse.persistence.internal.oxm.MediaType;
import org.eclipse.persistence.internal.oxm.NamespacePrefixMapper;
import org.eclipse.persistence.oxm.CharacterEscapeHandler;
import org.eclipse.persistence.oxm.XMLMarshalListener;
import org.eclipse.persistence.oxm.attachment.XMLAttachmentMarshaller;
import org.eclipse.persistence.platform.xml.XMLTransformer;
import org.xml.sax.ErrorHandler;

public abstract class Marshaller<CONTEXT extends Context, MEDIA_TYPE extends MediaType, NAMESPACE_PREFIX_MAPPER extends NamespacePrefixMapper> {
    private static String DEFAULT_INDENT = "   ";
    private CharacterEscapeHandler charEscapeHandler;
    protected CONTEXT context;
    private String encoding;
    private boolean equalUsingIdenity;
    private ErrorHandler errorHandler;
    private boolean formattedOutput;
    private String indentString;
    protected NAMESPACE_PREFIX_MAPPER mapper;
    private XMLMarshalListener marshalListener;
    protected Properties marshalProperties;

    public Marshaller(CONTEXT context) {
        this.context = context;
        this.encoding = "UTF-8";
        this.equalUsingIdenity = true;
        this.formattedOutput = true;
        this.indentString = DEFAULT_INDENT;
    }

    protected Marshaller(Marshaller marshaller) {
        this.charEscapeHandler = marshaller.getCharacterEscapeHandler();
        this.context = marshaller.getContext();
        this.encoding = marshaller.getEncoding();
        this.equalUsingIdenity = marshaller.isEqualUsingIdenity();
        this.errorHandler = marshaller.getErrorHandler();
        this.formattedOutput = marshaller.isFormattedOutput();
        this.indentString = marshaller.getIndentString();
        this.mapper = marshaller.getNamespacePrefixMapper();
        this.marshalListener = marshaller.getMarshalListener();
        if (marshaller.marshalProperties != null) {
            this.marshalProperties = new Properties();
            for (Map.Entry<Object, Object> entry2 : this.marshalProperties.entrySet()) {
                this.marshalProperties.put(entry2.getKey(), entry2.getValue());
            }
        }
    }

    public abstract XMLAttachmentMarshaller getAttachmentMarshaller();

    public CharacterEscapeHandler getCharacterEscapeHandler() {
        return this.charEscapeHandler;
    }

    public CONTEXT getContext() {
        return this.context;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public String getIndentString() {
        return this.indentString;
    }

    public XMLMarshalListener getMarshalListener() {
        return this.marshalListener;
    }

    public abstract MEDIA_TYPE getMediaType();

    public NAMESPACE_PREFIX_MAPPER getNamespacePrefixMapper() {
        return this.mapper;
    }

    public Object getProperty(Object key) {
        if (this.marshalProperties == null) {
            return null;
        }
        return this.marshalProperties.get(key);
    }

    public abstract XMLTransformer getTransformer();

    public boolean isEqualUsingIdenity() {
        return this.equalUsingIdenity;
    }

    public boolean isFormattedOutput() {
        return this.formattedOutput;
    }

    public abstract boolean isIncludeRoot();

    public abstract boolean isReduceAnyArrays();

    public abstract boolean isWrapperAsCollectionName();

    public void setCharacterEscapeHandler(CharacterEscapeHandler c) {
        this.charEscapeHandler = c;
    }

    public void setEncoding(String newEncoding) {
        this.encoding = newEncoding;
    }

    public void setEqualUsingIdenity(boolean equalUsingIdenity) {
        this.equalUsingIdenity = equalUsingIdenity;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setFormattedOutput(boolean shouldFormat) {
        this.formattedOutput = shouldFormat;
    }

    public void setIndentString(String s2) {
        this.indentString = s2;
    }

    public void setMarshalListener(XMLMarshalListener listener) {
        this.marshalListener = listener;
    }

    public void setNamespacePrefixMapper(NAMESPACE_PREFIX_MAPPER mapper) {
        this.mapper = mapper;
    }
}

