/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm;

import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.DirectMapping;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.mappings.UnionField;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.internal.oxm.record.ObjectMarshalContext;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;

public class TypeNodeValue
extends NodeValue {
    private DirectMapping directMapping;

    @Override
    public boolean isOwningNode(XPathFragment xPathFragment) {
        return xPathFragment != null && xPathFragment.isAttribute();
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        return this.marshal(xPathFragment, marshalRecord, object, session, namespaceResolver, ObjectMarshalContext.getInstance());
    }

    @Override
    public boolean marshal(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        Object objectValue = this.directMapping.getAttributeValueFromObject(object);
        return this.marshalSingleValue(xPathFragment, marshalRecord, object, objectValue, session, namespaceResolver, marshalContext);
    }

    @Override
    public boolean marshalSingleValue(XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, Object objectValue, CoreAbstractSession session, NamespaceResolver namespaceResolver, MarshalContext marshalContext) {
        Object fieldValue = this.directMapping.getFieldValue(objectValue, session, marshalRecord);
        if (fieldValue == null || namespaceResolver == null) {
            return false;
        }
        Field xmlField = (Field)this.directMapping.getField();
        QName schemaType = this.getSchemaType(xmlField, fieldValue, session);
        if (schemaType == null) {
            return false;
        }
        if (xmlField.getSchemaType() == null ? schemaType.equals(Constants.STRING_QNAME) : xmlField.isSchemaType(schemaType)) {
            return false;
        }
        XPathFragment groupingFragment = marshalRecord.openStartGroupingElements(namespaceResolver);
        String typeQName = String.valueOf(namespaceResolver.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance")) + ':' + "type";
        String schemaTypePrefix = namespaceResolver.resolveNamespaceURI(schemaType.getNamespaceURI());
        if (schemaTypePrefix == null) {
            schemaTypePrefix = "http://www.w3.org/2001/XMLSchema".equals(schemaType.getNamespaceURI()) ? namespaceResolver.generatePrefix("xsd") : namespaceResolver.generatePrefix();
            marshalRecord.namespaceDeclaration(schemaTypePrefix, schemaType.getNamespaceURI());
        }
        marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "type", typeQName, String.valueOf(schemaTypePrefix) + ':' + schemaType.getLocalPart());
        marshalRecord.closeStartGroupingElements(groupingFragment);
        return true;
    }

    public DirectMapping getDirectMapping() {
        return this.directMapping;
    }

    public void setDirectMapping(DirectMapping directMapping) {
        this.directMapping = directMapping;
    }

    private QName getSchemaType(Field xmlField, Object value2, CoreAbstractSession session) {
        QName schemaType = null;
        if (xmlField.isTypedTextField()) {
            schemaType = xmlField.getXMLType(value2.getClass());
        } else {
            if (xmlField.isUnionField()) {
                return this.getSchemaTypeForUnion((UnionField)xmlField, value2, session);
            }
            if (xmlField.getSchemaType() != null) {
                schemaType = xmlField.getSchemaType();
            }
        }
        return schemaType;
    }

    private QName getSchemaTypeForUnion(UnionField xmlField, Object value2, CoreAbstractSession session) {
        List<QName> schemaTypes = xmlField.getSchemaTypes();
        QName schemaType = null;
        int i = 0;
        while (i < schemaTypes.size()) {
            block4: {
                QName nextQName = xmlField.getSchemaTypes().get(i);
                try {
                    if (nextQName != null) {
                        Class javaClass = xmlField.getJavaClass(nextQName);
                        value2 = ((XMLConversionManager)session.getDatasourcePlatform().getConversionManager()).convertObject(value2, javaClass, nextQName);
                        schemaType = nextQName;
                        break;
                    }
                }
                catch (ConversionException conversionException) {
                    if (i != schemaTypes.size() - 1) break block4;
                    schemaType = nextQName;
                }
            }
            ++i;
        }
        return schemaType;
    }

    @Override
    public void attribute(UnmarshalRecord unmarshalRecord, String namespaceURI, String localName, String value2) {
        if (value2 != null) {
            String namespace = null;
            int colonIndex = value2.indexOf(58);
            if (colonIndex > -1) {
                String prefix = value2.substring(0, colonIndex);
                namespace = unmarshalRecord.resolveNamespacePrefix(prefix);
                value2 = value2.substring(colonIndex + 1);
            }
            unmarshalRecord.setTypeQName(new QName(namespace, value2));
        }
    }
}

