/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.annotations.CacheKeyType;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.indirection.IndirectSet;
import org.eclipse.persistence.internal.core.queries.CoreContainerPolicy;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheId;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ArrayListContainerPolicy;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.IndirectListContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.ListContainerPolicy;
import org.eclipse.persistence.internal.queries.MapContainerPolicy;
import org.eclipse.persistence.internal.queries.OrderedListContainerPolicy;
import org.eclipse.persistence.internal.queries.SortedCollectionContainerPolicy;
import org.eclipse.persistence.internal.queries.VectorContainerPolicy;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.CollectionChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.DirectReadQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.queries.WriteObjectQuery;

public abstract class ContainerPolicy
implements CoreContainerPolicy<AbstractSession>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 6971791021041582975L;
    protected static Class defaultContainerClass = ClassConstants.Vector_class;
    protected transient ClassDescriptor elementDescriptor;
    protected transient Constructor constructor;

    public static Class getDefaultContainerClass() {
        return defaultContainerClass;
    }

    public static void setDefaultContainerClass(Class collectionClass) {
        defaultContainerClass = collectionClass;
    }

    public void addAdditionalFieldsToQuery(ReadQuery selectionQuery, Expression baseExpression) {
    }

    public void addFieldsForMapKey(AbstractRecord joinRow) {
    }

    @Override
    public boolean addInto(Object element, Object container, AbstractSession session) {
        return this.addInto((Object)null, element, container, session);
    }

    public boolean addInto(Object element, Object container, AbstractSession session, AbstractRecord dbRow, ObjectBuildingQuery query, CacheKey parentCacheKey, boolean isTargetProtected) {
        return this.addInto((Object)null, element, container, session);
    }

    public boolean addAll(List elements, Object container, AbstractSession session, List<AbstractRecord> dbRows, ObjectBuildingQuery query, CacheKey parentCacheKey, boolean isTargetProtected) {
        boolean changed = false;
        int i = 0;
        while (i < elements.size()) {
            changed |= this.addInto(elements.get(i), container, session, dbRows.get(i), query, parentCacheKey, isTargetProtected);
            ++i;
        }
        return changed;
    }

    public boolean addInto(Object element, Object container, AbstractSession session, AbstractRecord row, DataReadQuery query, CacheKey parentCacheKey, boolean isTargetProtected) {
        return this.addInto((Object)null, element, container, session);
    }

    public boolean addAll(List elements, Object container, AbstractSession session, List<AbstractRecord> rows, DataReadQuery query, CacheKey parentCacheKey, boolean isTargetProtected) {
        boolean changed = false;
        int i = 0;
        while (i < elements.size()) {
            changed |= this.addInto(elements.get(i), container, session, rows.get(i), query, parentCacheKey, isTargetProtected);
            ++i;
        }
        return changed;
    }

    @Override
    public boolean addInto(Object key, Object element, Object container, AbstractSession session) {
        throw QueryException.cannotAddToContainer(element, container, this);
    }

    public void addNestedJoinsQueriesForMapKey(JoinedAttributeManager joinManager, ObjectLevelReadQuery query, AbstractSession session) {
    }

    public void addNextValueFromIteratorInto(Object valuesIterator, Object parent, CacheKey parentCacheKey, Object toCollection, CollectionMapping mapping, Integer refreshCascade, AbstractSession cloningSession, boolean isExisting, boolean isFromSharedCache) {
        Object cloneValue = mapping.buildElementClone(this.next(valuesIterator, cloningSession), parent, parentCacheKey, refreshCascade, cloningSession, isExisting, isFromSharedCache);
        if (cloningSession.isUnitOfWork() && !isExisting && mapping.isCandidateForPrivateOwnedRemoval() && ((UnitOfWorkImpl)cloningSession).shouldDiscoverNewObjects() && cloneValue != null && ((UnitOfWorkImpl)cloningSession).isCloneNewObject(cloneValue)) {
            ((UnitOfWorkImpl)cloningSession).addPrivateOwnedObject(mapping, cloneValue);
        }
        this.addInto(cloneValue, toCollection, cloningSession);
    }

    public Object buildCloneForKey(Object key, Object parent, CacheKey parentCacheKey, Integer refreshCascade, AbstractSession cloningSession, boolean isExisting, boolean isCacheCheckComplete) {
        return key;
    }

    public Object buildCollectionEntry(Object objectAdded, ObjectChangeSet changeSet) {
        return objectAdded;
    }

    public Object buildContainerFromVector(Vector vector, AbstractSession session) {
        Object container = this.containerInstance(vector.size());
        int size2 = vector.size();
        int index = 0;
        while (index < size2) {
            this.addInto(vector.get(index), container, session);
            ++index;
        }
        return container;
    }

    public Object buildKey(AbstractRecord row, ObjectBuildingQuery query, CacheKey parentCacheKey, AbstractSession session, boolean isTargetProtected) {
        return null;
    }

    public Object[] buildReferencesPKList(Object container, AbstractSession session) {
        Object[] result2 = new Object[this.sizeFor(container)];
        Iterator iterator2 = (Iterator)this.iteratorFor(container);
        int index = 0;
        while (iterator2.hasNext()) {
            Object target = iterator2.next();
            if (target == null) continue;
            result2[index] = this.elementDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(target, session);
            ++index;
        }
        return result2;
    }

    public Object buildKeyFromJoinedRow(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery query, CacheKey parentCacheKey, AbstractSession session, boolean isTargetProtected) {
        return null;
    }

    public static ContainerPolicy buildDefaultPolicy() {
        return ContainerPolicy.buildPolicyFor(ContainerPolicy.getDefaultContainerClass());
    }

    public static ContainerPolicy buildPolicyFor(Class concreteContainerClass) {
        return ContainerPolicy.buildPolicyFor(concreteContainerClass, false);
    }

    public static ContainerPolicy buildPolicyFor(Class concreteContainerClass, boolean hasOrdering) {
        if (Helper.classImplementsInterface(concreteContainerClass, ClassConstants.List_Class)) {
            if (hasOrdering) {
                return new OrderedListContainerPolicy(concreteContainerClass);
            }
            if (concreteContainerClass == ClassConstants.Vector_class) {
                return new VectorContainerPolicy(concreteContainerClass);
            }
            if (concreteContainerClass == ClassConstants.IndirectList_Class) {
                return new IndirectListContainerPolicy(concreteContainerClass);
            }
            if (concreteContainerClass == ClassConstants.ArrayList_class) {
                return new ArrayListContainerPolicy(concreteContainerClass);
            }
            return new ListContainerPolicy(concreteContainerClass);
        }
        if (Helper.classImplementsInterface(concreteContainerClass, ClassConstants.SortedSet_Class)) {
            return new SortedCollectionContainerPolicy(concreteContainerClass);
        }
        if (Helper.classImplementsInterface(concreteContainerClass, ClassConstants.Collection_Class)) {
            return new CollectionContainerPolicy(concreteContainerClass);
        }
        if (Helper.classImplementsInterface(concreteContainerClass, ClassConstants.Map_Class)) {
            return new MapContainerPolicy(concreteContainerClass);
        }
        if (concreteContainerClass.equals(ClassConstants.CursoredStream_Class)) {
            return new CursoredStreamPolicy();
        }
        if (concreteContainerClass.equals(ClassConstants.ScrollableCursor_Class)) {
            return new ScrollableCursorPolicy();
        }
        throw ValidationException.illegalContainerClass(concreteContainerClass);
    }

    public ReadQuery buildSelectionQueryForDirectCollectionMapping() {
        DirectReadQuery query = new DirectReadQuery();
        query.setSQLStatement(new SQLSelectStatement());
        query.setContainerPolicy(this);
        return query;
    }

    @Override
    public void clear(Object container) {
        throw QueryException.methodNotValid(this, "clear(Object container)");
    }

    public abstract CollectionChangeEvent createChangeEvent(Object var1, String var2, Object var3, Object var4, int var5, Integer var6, boolean var7);

    public boolean equals(Object object) {
        return object != null && this.getClass().equals(object.getClass());
    }

    public void cascadeDiscoverAndPersistUnregisteredNewObjects(Object object, Map newObjects, Map unregisteredExistingObjects, Map visitedObjects, UnitOfWorkImpl uow, Set cascadeErrors) {
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWorkImpl uow, Map visitedObjects) {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public ContainerPolicy clone(ReadQuery query) {
        return (ContainerPolicy)this.clone();
    }

    public Object cloneFor(Object container) {
        throw QueryException.cannotCreateClone(this, container);
    }

    protected void createChangeSetForKeys(Map originalKeyValues, CollectionChangeRecord changeRecord, AbstractSession session, ClassDescriptor referenceDescriptor) {
    }

    protected void collectObjectForNewCollection(Map originalKeyValues, Map cloneKeyValues, Object newCollection, CollectionChangeRecord changeRecord, AbstractSession session, ClassDescriptor referenceDescriptor) {
        Object cloneIter = this.iteratorFor(newCollection);
        while (this.hasNext(cloneIter)) {
            Object wrappedFirstObject = this.nextEntry(cloneIter, session);
            Object firstObject = this.unwrapIteratorResult(wrappedFirstObject);
            if (firstObject == null) continue;
            Object key = firstObject;
            if (changeRecord.getMapping().isAggregateCollectionMapping()) {
                key = referenceDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(firstObject, session);
            }
            if (originalKeyValues.containsKey(key)) {
                if (this.compareKeys(firstObject, session)) {
                    originalKeyValues.remove(key);
                    continue;
                }
                Object backUpVersion = null;
                backUpVersion = ((UnitOfWorkImpl)session).isClassReadOnly(firstObject.getClass()) ? firstObject : ((UnitOfWorkImpl)session).getBackupClone(firstObject, referenceDescriptor);
                ObjectChangeSet changeSet = referenceDescriptor.getObjectBuilder().createObjectChangeSet(firstObject, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
                changeSet.setOldKey(this.keyFrom(backUpVersion, session));
                changeSet.setNewKey(this.keyFrom(firstObject, session));
                cloneKeyValues.put(key, firstObject);
                continue;
            }
            this.buildChangeSetForNewObjectInCollection(wrappedFirstObject, referenceDescriptor, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
            cloneKeyValues.put(key, firstObject);
        }
    }

    public void compareCollectionsForChange(Object oldCollection, Object newCollection, CollectionChangeRecord changeRecord, AbstractSession session, ClassDescriptor referenceDescriptor) {
        AbstractMap originalKeyValues = null;
        AbstractMap cloneKeyValues = null;
        if (changeRecord.getMapping().isAggregateCollectionMapping()) {
            originalKeyValues = new HashMap();
            cloneKeyValues = new HashMap();
        } else {
            originalKeyValues = new IdentityHashMap();
            cloneKeyValues = new IdentityHashMap();
        }
        if (oldCollection != null) {
            Object backUpIter = this.iteratorFor(oldCollection);
            while (this.hasNext(backUpIter)) {
                Object wrappedSecondObject = this.nextEntry(backUpIter, session);
                Object secondObject = this.unwrapIteratorResult(wrappedSecondObject);
                if (secondObject == null) continue;
                Object key = secondObject;
                if (changeRecord.getMapping().isAggregateCollectionMapping()) {
                    key = referenceDescriptor.getObjectBuilder().extractPrimaryKeyFromObject(secondObject, session);
                }
                originalKeyValues.put(key, wrappedSecondObject);
            }
        }
        if (newCollection != null) {
            this.collectObjectForNewCollection(originalKeyValues, cloneKeyValues, newCollection, changeRecord, session, referenceDescriptor);
        }
        this.createChangeSetForKeys(originalKeyValues, changeRecord, session, referenceDescriptor);
        changeRecord.clearChanges();
        changeRecord.addAdditionChange(cloneKeyValues, this, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
        changeRecord.addRemoveChange(originalKeyValues, this, (UnitOfWorkChangeSet)changeRecord.getOwner().getUOWChangeSet(), session);
        changeRecord.setIsDeferred(false);
        changeRecord.setLatestCollection(null);
    }

    public void buildChangeSetForNewObjectInCollection(Object object, ClassDescriptor referenceDescriptor, UnitOfWorkChangeSet uowChangeSet, AbstractSession session) {
    }

    public boolean compareKeys(Object sourceKey, AbstractSession session) {
        return true;
    }

    public Object concatenateContainers(Object firstContainer, Object secondContainer, AbstractSession session) {
        Object container = this.containerInstance(this.sizeFor(firstContainer) + this.sizeFor(secondContainer));
        Object firstIter = this.iteratorFor(firstContainer);
        while (this.hasNext(firstIter)) {
            this.addInto((Object)null, this.next(firstIter), container, session);
        }
        Object secondIter = this.iteratorFor(secondContainer);
        while (this.hasNext(secondIter)) {
            this.addInto((Object)null, this.next(secondIter), container, session);
        }
        return container;
    }

    @Override
    public Object containerInstance() {
        Class containerClass = this.getContainerClass();
        if (containerClass == ClassConstants.IndirectList_Class) {
            return new IndirectList();
        }
        if (containerClass == ClassConstants.IndirectSet_Class) {
            return new IndirectSet();
        }
        if (containerClass == ClassConstants.ArrayList_class) {
            return new ArrayList();
        }
        if (containerClass == ClassConstants.Vector_class) {
            return new Vector();
        }
        if (containerClass == ClassConstants.HashSet_class) {
            return new HashSet();
        }
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(containerClass));
                }
                catch (PrivilegedActionException exception) {
                    throw QueryException.couldNotInstantiateContainerClass(containerClass, exception.getException());
                }
            }
            return PrivilegedAccessHelper.newInstanceFromClass(containerClass);
        }
        catch (Exception ex) {
            throw QueryException.couldNotInstantiateContainerClass(containerClass, ex);
        }
    }

    @Override
    public Object containerInstance(int initialCapacity) {
        if (this.constructor == null) {
            return this.containerInstance();
        }
        Class containerClass = this.getContainerClass();
        try {
            if (containerClass == ClassConstants.IndirectList_Class) {
                return new IndirectList(initialCapacity);
            }
            if (containerClass == ClassConstants.IndirectSet_Class) {
                return new IndirectSet(initialCapacity);
            }
            if (containerClass == ClassConstants.ArrayList_class) {
                return new ArrayList(initialCapacity);
            }
            if (containerClass == ClassConstants.Vector_class) {
                return new Vector(initialCapacity);
            }
            if (containerClass == ClassConstants.HashSet_class) {
                return new HashSet(initialCapacity);
            }
            Object[] arguments = new Object[]{initialCapacity};
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    return AccessController.doPrivileged(new PrivilegedInvokeConstructor(this.constructor, arguments));
                }
                catch (PrivilegedActionException exception) {
                    throw QueryException.couldNotInstantiateContainerClass(containerClass, exception.getException());
                }
            }
            return PrivilegedAccessHelper.invokeConstructor(this.constructor, arguments);
        }
        catch (Exception ex) {
            throw QueryException.couldNotInstantiateContainerClass(containerClass, ex);
        }
    }

    protected boolean contains(Object element, Object container) {
        throw QueryException.methodNotValid(this, "contains(Object element, Object container)");
    }

    @Override
    public boolean contains(Object element, Object container, AbstractSession session) {
        if (this.hasElementDescriptor() && this.getElementDescriptor().hasWrapperPolicy()) {
            Object iterator2 = this.iteratorFor(container);
            while (this.hasNext(iterator2)) {
                Object next2 = this.next(iterator2);
                if (!this.getElementDescriptor().getObjectBuilder().unwrapObject(next2, session).equals(element)) continue;
                return true;
            }
            return false;
        }
        return this.contains(element, container);
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
    }

    public Object createWrappedObjectFromExistingWrappedObject(Object wrappedObject, Object parent, ClassDescriptor referenceDescriptor, MergeManager mergeManager, AbstractSession targetSession) {
        return referenceDescriptor.getObjectBuilder().wrapObject(mergeManager.getTargetVersionOfSourceObject(this.unwrapIteratorResult(wrappedObject), referenceDescriptor, targetSession), mergeManager.getSession());
    }

    public void deleteWrappedObject(Object objectDeleted, AbstractSession session) {
        session.deleteObject(objectDeleted);
    }

    public Object execute() {
        throw QueryException.methodNotValid(this, "execute()");
    }

    public List<DatabaseTable> getAdditionalTablesForJoinQuery() {
        return null;
    }

    public List<DatabaseField> getAdditionalFieldsForJoin(CollectionMapping baseMapping) {
        return null;
    }

    public Iterator getChangeValuesFrom(Map map2) {
        return map2.values().iterator();
    }

    public Object getCloneDataFromChangeSet(ObjectChangeSet changeSet) {
        return changeSet.getUnitOfWorkClone();
    }

    protected Constructor getConstructor() {
        return this.constructor;
    }

    public Class getContainerClass() {
        throw QueryException.methodNotValid(this, "getContainerClass()");
    }

    public String getContainerClassName() {
        throw QueryException.methodNotValid(this, "getContainerClassName()");
    }

    public ClassDescriptor getDescriptorForMapKey() {
        return null;
    }

    public ClassDescriptor getElementDescriptor() {
        return this.elementDescriptor;
    }

    public List<DatabaseField> getIdentityFieldsForMapKey() {
        return null;
    }

    public Map getKeyMappingDataForWriteQuery(Object object, AbstractSession session) {
        return null;
    }

    public Expression getKeySelectionCriteria() {
        return null;
    }

    public Object getKeyType() {
        return null;
    }

    public boolean hasElementDescriptor() {
        return this.elementDescriptor != null;
    }

    @Override
    public abstract boolean hasNext(Object var1);

    public boolean hasOrder() {
        return false;
    }

    public void initialize(AbstractSession session, DatabaseTable keyTable) {
    }

    public void initializeConstructor() {
        try {
            Constructor constructor = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(this.getContainerClass(), new Class[]{ClassConstants.PINT}, false));
                }
                catch (PrivilegedActionException privilegedActionException) {
                    return;
                }
            } else {
                constructor = PrivilegedAccessHelper.getConstructorFor(this.getContainerClass(), new Class[]{ClassConstants.PINT}, false);
            }
            this.setConstructor(constructor);
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean isCollectionPolicy() {
        return false;
    }

    public boolean isCursoredStreamPolicy() {
        return false;
    }

    public boolean isScrollableCursorPolicy() {
        return false;
    }

    public boolean isCursorPolicy() {
        return false;
    }

    public boolean isDirectMapPolicy() {
        return false;
    }

    @Override
    public boolean isEmpty(Object container) {
        return this.sizeFor(container) == 0;
    }

    @Override
    public boolean isListPolicy() {
        return false;
    }

    public boolean isOrderedListPolicy() {
        return false;
    }

    public boolean isMapPolicy() {
        return false;
    }

    public boolean isMappedKeyMapPolicy() {
        return false;
    }

    public boolean isMapKeyObject() {
        return false;
    }

    public boolean isValidContainer(Object container) {
        throw QueryException.methodNotValid(this, "isValidContainer(Object container)");
    }

    public boolean isValidContainerType(Class containerType) {
        throw QueryException.methodNotValid(this, "isValidContainerType(Class containerType)");
    }

    public void iterateOnMapKey(DescriptorIterator iterator2, Object element) {
    }

    @Override
    public abstract Object iteratorFor(Object var1);

    public Object keyFrom(Object element, AbstractSession session) {
        return null;
    }

    public Object keyFromEntry(Object entry2) {
        return null;
    }

    public Object keyFromIterator(Object iterator2) {
        return null;
    }

    public Object mergeCascadeParts(ObjectChangeSet objectChanges, MergeManager mergeManager, AbstractSession targetSession) {
        Object object = null;
        if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
            object = objectChanges.getTargetVersionOfSourceObject(mergeManager, targetSession);
            if (object == null && (objectChanges.isNew() || objectChanges.isAggregate()) && objectChanges.containsChangesFromSynchronization()) {
                if (!mergeManager.isAlreadyMerged(objectChanges, targetSession)) {
                    Class objectClass = objectChanges.getClassType(mergeManager.getSession());
                    object = mergeManager.getSession().getDescriptor(objectClass).getObjectBuilder().buildNewInstance();
                    mergeManager.recordMerge(objectChanges, object, targetSession);
                } else {
                    object = mergeManager.getMergedObject(objectChanges, targetSession);
                }
            } else {
                object = objectChanges.getTargetVersionOfSourceObject(mergeManager, targetSession, true);
            }
            if (objectChanges.containsChangesFromSynchronization()) {
                mergeManager.mergeChanges(object, objectChanges, targetSession);
            }
        } else {
            mergeManager.mergeChanges(objectChanges.getUnitOfWorkClone(), objectChanges, targetSession);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChanges(CollectionChangeRecord changeRecord, Object valueOfTarget, boolean shouldMergeCascadeParts, MergeManager mergeManager, AbstractSession targetSession, boolean isSynchronizeOnMerge) {
        if (isSynchronizeOnMerge && !changeRecord.getOwner().isNew()) {
            Object synchronizedValueOfTarget = valueOfTarget;
            if (valueOfTarget instanceof IndirectCollection) {
                synchronizedValueOfTarget = ((IndirectCollection)valueOfTarget).getDelegateObject();
            }
            Object object = synchronizedValueOfTarget;
            synchronized (object) {
                this.mergeChanges(changeRecord, valueOfTarget, shouldMergeCascadeParts, mergeManager, targetSession);
            }
        } else {
            this.mergeChanges(changeRecord, valueOfTarget, shouldMergeCascadeParts, mergeManager, targetSession);
        }
    }

    protected void mergeChanges(CollectionChangeRecord changeRecord, Object valueOfTarget, boolean shouldMergeCascadeParts, MergeManager mergeManager, AbstractSession targetSession) {
        for (ObjectChangeSet objectChanges : changeRecord.getRemoveObjectList().keySet()) {
            this.removeFrom(objectChanges.getOldKey(), objectChanges.getTargetVersionOfSourceObject(mergeManager, targetSession), valueOfTarget, targetSession);
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) continue;
            mergeManager.registerRemovedNewObjectIfRequired(objectChanges.getUnitOfWorkClone());
        }
        for (ObjectChangeSet objectChanges : changeRecord.getAddObjectList().keySet()) {
            Object object = null;
            if (shouldMergeCascadeParts) {
                object = this.mergeCascadeParts(objectChanges, mergeManager, targetSession);
            }
            if (object == null) {
                object = objectChanges.getTargetVersionOfSourceObject(mergeManager, targetSession, false);
            }
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                if (this.contains(object, valueOfTarget, mergeManager.getSession())) continue;
                this.addInto(objectChanges.getNewKey(), object, valueOfTarget, mergeManager.getSession());
                continue;
            }
            this.addInto(objectChanges.getNewKey(), object, valueOfTarget, mergeManager.getSession());
        }
    }

    protected abstract Object next(Object var1);

    @Override
    public Object next(Object iterator2, AbstractSession session) {
        Object next2 = this.next(iterator2);
        if (this.hasElementDescriptor()) {
            next2 = this.getElementDescriptor().getObjectBuilder().unwrapObject(next2, session);
        }
        return next2;
    }

    @Override
    public Object nextEntry(Object iterator2) {
        return this.next(iterator2);
    }

    @Override
    public Object nextEntry(Object iterator2, AbstractSession session) {
        return this.next(iterator2, session);
    }

    public boolean overridesRead() {
        return false;
    }

    public void postInitialize(AbstractSession session) {
    }

    public void postCalculateChanges(ObjectChangeSet ocs, ClassDescriptor referenceDescriptor, DatabaseMapping mapping, UnitOfWorkImpl uow) {
        if (mapping.isForeignReferenceMapping()) {
            Object clone2 = ocs.getUnitOfWorkClone();
            uow.addDeletedPrivateOwnedObjects(mapping, clone2);
        }
    }

    public void postCalculateChanges(Object key, Object value2, ClassDescriptor referenceDescriptor, DatabaseMapping mapping, UnitOfWorkImpl uow) {
        if (!mapping.isDirectCollectionMapping() && !mapping.isAggregateCollectionMapping()) {
            uow.addDeletedPrivateOwnedObjects(mapping, value2);
        }
    }

    public void recordPrivateOwnedRemovals(Object object, ClassDescriptor referenceDescriptor, UnitOfWorkImpl uow) {
        if (referenceDescriptor != null) {
            referenceDescriptor.getObjectBuilder().recordPrivateOwnedRemovals(this.unwrapIteratorResult(object), uow, false);
        }
    }

    public void prepare(DatabaseQuery query, AbstractSession session) throws QueryException {
        if (query.isReadAllQuery() && !query.isReportQuery() && query.shouldUseWrapperPolicy()) {
            this.setElementDescriptor(query.getDescriptor());
        } else if (query.isDataReadQuery()) {
            ((DataReadQuery)query).setContainerPolicy(this);
        }
    }

    public void prepareForExecution() throws QueryException {
    }

    public void processAdditionalWritableMapKeyFields(AbstractSession session) {
    }

    public void propogatePostDelete(DeleteObjectQuery query, Object object) {
    }

    public void propogatePostInsert(WriteObjectQuery query, Object object) {
    }

    public void propogatePostUpdate(WriteObjectQuery query, Object object) {
    }

    public void propogatePreDelete(DeleteObjectQuery query, Object object) {
    }

    public void propogatePreInsert(WriteObjectQuery query, Object object) {
    }

    public void propogatePreUpdate(WriteObjectQuery query, Object object) {
    }

    public boolean propagatesEventsToCollection() {
        return false;
    }

    public void recordAddToCollectionInChangeRecord(ObjectChangeSet changeSetToAdd, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getRemoveObjectList().containsKey(changeSetToAdd)) {
            collectionChangeRecord.getRemoveObjectList().remove(changeSetToAdd);
        } else {
            collectionChangeRecord.getAddObjectList().put(changeSetToAdd, changeSetToAdd);
        }
    }

    public void recordRemoveFromCollectionInChangeRecord(ObjectChangeSet changeSetToRemove, CollectionChangeRecord collectionChangeRecord) {
        if (collectionChangeRecord.getAddObjectList().containsKey(changeSetToRemove)) {
            collectionChangeRecord.getAddObjectList().remove(changeSetToRemove);
        } else {
            collectionChangeRecord.getRemoveObjectList().put(changeSetToRemove, changeSetToRemove);
        }
    }

    public void recordUpdateToCollectionInChangeRecord(CollectionChangeEvent event, ObjectChangeSet changeSet, CollectionChangeRecord collectionChangeRecord) {
        if (event.getChangeType() == CollectionChangeEvent.ADD) {
            this.recordAddToCollectionInChangeRecord(changeSet, collectionChangeRecord);
        } else if (event.getChangeType() == CollectionChangeEvent.REMOVE) {
            this.recordRemoveFromCollectionInChangeRecord(changeSet, collectionChangeRecord);
        } else {
            throw ValidationException.wrongCollectionChangeEventType(event.getChangeType());
        }
    }

    public Object remoteExecute() {
        return null;
    }

    @Override
    protected boolean removeFrom(Object key, Object element, Object container) {
        throw QueryException.cannotRemoveFromContainer(element, container, this);
    }

    public boolean removeFrom(Object key, Object element, Object container, AbstractSession session) {
        Object objectToRemove = element;
        if (this.hasElementDescriptor() && this.getElementDescriptor().hasWrapperPolicy()) {
            Object iterator2 = this.iteratorFor(container);
            while (this.hasNext(iterator2)) {
                Object next2 = this.next(iterator2);
                if (!this.getElementDescriptor().getObjectBuilder().unwrapObject(next2, session).equals(element)) continue;
                objectToRemove = next2;
                break;
            }
        }
        return this.removeFrom(key, objectToRemove, container);
    }

    @Override
    public boolean removeFrom(Object element, Object container, AbstractSession session) {
        return this.removeFrom(null, element, container, session);
    }

    public boolean requiresDataModificationEvents() {
        return false;
    }

    protected void setConstructor(Constructor constructor) {
        this.constructor = constructor;
    }

    @Override
    public void setContainerClass(Class containerClass) {
        throw QueryException.methodNotValid(this, "getContainerClass()");
    }

    public void setContainerClassName(String containerClassName) {
        throw QueryException.methodNotValid(this, "getContainerClassName()");
    }

    public void setElementDescriptor(ClassDescriptor elementDescriptor) {
        this.elementDescriptor = elementDescriptor;
    }

    public void setKeyName(String instanceVariableName, String elementClassName) {
        throw ValidationException.containerPolicyDoesNotUseKeys(this, instanceVariableName);
    }

    public void setKeyName(String instanceVariableName, Class elementClass) {
        throw ValidationException.containerPolicyDoesNotUseKeys(this, instanceVariableName);
    }

    public boolean shouldAddAll() {
        return false;
    }

    public boolean shouldIncludeKeyInDeleteEvent() {
        return false;
    }

    public boolean shouldUpdateForeignKeysPostInsert() {
        return false;
    }

    @Override
    public int sizeFor(Object container) {
        throw QueryException.methodNotValid(this, "sizeFor(Object container)");
    }

    public String toString() {
        return String.valueOf(Helper.getShortClassName(this.getClass())) + "(" + this.toStringInfo() + ")";
    }

    protected Object toStringInfo() {
        return "";
    }

    public int updateJoinedMappingIndexesForMapKey(Map<DatabaseMapping, Object> indexList, int index) {
        return 0;
    }

    public void updateChangeRecordForSelfMerge(ChangeRecord changeRecord, Object source, Object target, ForeignReferenceMapping mapping, UnitOfWorkChangeSet parentUOWChangeSet, UnitOfWorkImpl unitOfWork) {
        ObjectChangeSet sourceSet;
        Map<ObjectChangeSet, ObjectChangeSet> list = ((CollectionChangeRecord)changeRecord).getAddObjectList();
        if (list.containsKey(sourceSet = parentUOWChangeSet.getCloneToObjectChangeSet().get(source))) {
            ObjectChangeSet targetSet = ((UnitOfWorkChangeSet)unitOfWork.getUnitOfWorkChangeSet()).findOrCreateLocalObjectChangeSet(target, mapping.getReferenceDescriptor(), unitOfWork.isCloneNewObject(target));
            targetSet.setNewKey(sourceSet.getNewKey());
            targetSet.setOldKey(sourceSet.getOldKey());
            parentUOWChangeSet.addObjectChangeSetForIdentity(targetSet, target);
            list.remove(sourceSet);
            list.put(targetSet, targetSet);
            return;
        }
    }

    public Object unwrapElement(Object object) {
        return object;
    }

    public Object unwrapIteratorResult(Object object) {
        return object;
    }

    public Object valueFromPKList(Object[] pks, AbstractRecord foreignKeys, ForeignReferenceMapping mapping, AbstractSession session) {
        Object result2 = this.containerInstance(pks.length);
        Map<Object, Object> fromCache = session.getIdentityMapAccessorInstance().getAllFromIdentityMapWithEntityPK(pks, this.elementDescriptor);
        for (Object entity : fromCache.values()) {
            this.addInto(entity, result2, session);
        }
        List foreignKeyValues = new ArrayList<Object>(pks.length - fromCache.size());
        int index = 0;
        while (index < pks.length) {
            Object pk = pks[index];
            if (!fromCache.containsKey(pk)) {
                if (this.elementDescriptor.getCachePolicy().getCacheKeyType() == CacheKeyType.CACHE_ID) {
                    foreignKeyValues.add(Arrays.asList(((CacheId)pk).getPrimaryKey()));
                } else {
                    foreignKeyValues.add(pk);
                }
            }
            ++index;
        }
        if (!foreignKeyValues.isEmpty()) {
            if (foreignKeyValues.size() == pks.length) {
                return session.executeQuery((DatabaseQuery)mapping.getSelectionQuery(), foreignKeys);
            }
            ReadAllQuery query = new ReadAllQuery();
            query.setReferenceClass(this.elementDescriptor.getJavaClass());
            query.setIsExecutionClone(true);
            query.addArgument("query-batch-parameter");
            query.setSession(session);
            query.setSelectionCriteria(this.elementDescriptor.buildBatchCriteriaByPK(query.getExpressionBuilder(), query));
            int pkCount = foreignKeyValues.size();
            ArrayList temp = new ArrayList();
            ArrayList<Object> arguments = new ArrayList<Object>();
            arguments.add(foreignKeyValues);
            if (pkCount > 1000) {
                int index2 = 0;
                while (index2 + 1000 < pkCount) {
                    ArrayList pkList = new ArrayList();
                    pkList.addAll(foreignKeyValues.subList(index2, index2 + 1000));
                    arguments.set(0, pkList);
                    query.setArgumentValues(arguments);
                    temp.addAll((Collection)session.executeQuery(query));
                    index2 += 1000;
                }
                foreignKeyValues = foreignKeyValues.subList(index2, pkCount);
            }
            arguments.set(0, foreignKeyValues);
            query.setArgumentValues(arguments);
            temp.addAll((Collection)session.executeQuery(query));
            if (temp.size() < pkCount) {
                return session.executeQuery((DatabaseQuery)mapping.getSelectionQuery(), foreignKeys);
            }
            for (Object element : temp) {
                this.addInto(element, result2, session);
            }
        }
        return result2;
    }

    @Override
    public Vector vectorFor(Object container, AbstractSession session) {
        Vector<Object> result2 = new Vector<Object>(this.sizeFor(container));
        Object iter2 = this.iteratorFor(container);
        while (this.hasNext(iter2)) {
            result2.addElement(this.next(iter2, session));
        }
        return result2;
    }

    public static void copyMapDataToRow(Map mappingData, AbstractRecord databaseRow) {
        if (mappingData != null) {
            for (Map.Entry entry2 : mappingData.entrySet()) {
                Object entryKey = entry2.getKey();
                Object entryValue = entry2.getValue();
                databaseRow.put(entryKey, entryValue);
            }
        }
    }
}

