/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb;

import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.ValidationException;
import javax.xml.bind.Validator;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import org.eclipse.persistence.jaxb.JAXBErrorHandler;
import org.eclipse.persistence.oxm.XMLValidator;

public class JAXBValidator
implements Validator {
    private ValidationEventHandler validationEventHandler = new DefaultValidationEventHandler();
    private XMLValidator xmlValidator;

    public JAXBValidator(XMLValidator newValidator) {
        this.xmlValidator = newValidator;
    }

    @Override
    public boolean validateRoot(Object rootObject) throws JAXBException {
        if (rootObject == null) {
            throw new IllegalArgumentException();
        }
        try {
            return this.xmlValidator.validateRoot(rootObject);
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
    }

    @Override
    public boolean validate(Object object) throws JAXBException {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        try {
            return this.xmlValidator.validate(object);
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
    }

    @Override
    public void setEventHandler(ValidationEventHandler newValidationEventHandler) throws JAXBException {
        this.validationEventHandler = newValidationEventHandler == null ? new DefaultValidationEventHandler() : newValidationEventHandler;
        this.xmlValidator.setErrorHandler(new JAXBErrorHandler(this.validationEventHandler));
    }

    @Override
    public ValidationEventHandler getEventHandler() throws JAXBException {
        return this.validationEventHandler;
    }

    @Override
    public void setProperty(String key, Object value2) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        throw new PropertyException(key, value2);
    }

    @Override
    public Object getProperty(String key) throws PropertyException {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        throw new PropertyException("Unsupported Property");
    }
}

