/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.jaxb.compiler.CompilerHelper;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaHasAnnotations;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.reflection.JavaClassImpl;
import org.eclipse.persistence.jaxb.xmlmodel.XmlAbstractNullPolicy;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementRef;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElementWrapper;
import org.eclipse.persistence.jaxb.xmlmodel.XmlElements;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJavaTypeAdapter;
import org.eclipse.persistence.jaxb.xmlmodel.XmlJoinNodes;
import org.eclipse.persistence.jaxb.xmlmodel.XmlMarshalNullRepresentation;
import org.eclipse.persistence.jaxb.xmlmodel.XmlTransformation;
import org.eclipse.persistence.oxm.XMLField;

public class Property
implements Cloneable {
    private String propertyName;
    private QName schemaName;
    private boolean isMethodProperty;
    private QName schemaType;
    private boolean isSwaAttachmentRef;
    private boolean isMtomAttachment;
    private boolean isInlineBinaryData;
    private String mimeType;
    private JavaClass type;
    private JavaClass adapterClass;
    private JavaHasAnnotations element;
    private JavaClass genericType;
    private boolean isAttribute = false;
    private boolean isAnyAttribute = false;
    private boolean isAnyElement = false;
    private Helper helper;
    private Map<Object, Object> userProperties;
    private String originalGetMethodName;
    private String originalSetMethodName;
    private String getMethodName;
    private String setMethodName;
    private boolean isRequired = false;
    private boolean isNillable = false;
    private boolean isXmlList = false;
    private boolean isTransient;
    private String defaultValue;
    private boolean isMixedContent = false;
    private boolean xmlElementType = false;
    private JavaClass originalType;
    private String fixedValue;
    private Boolean isReadOnly;
    private Boolean isWriteOnly;
    private Boolean isCdata;
    private boolean isVirtual = false;
    private XmlTransformation xmlTransformation;
    private XmlAbstractNullPolicy nullPolicy;
    private XmlJavaTypeAdapter xmlJavaTypeAdapter;
    private XmlElementWrapper xmlElementWrapper;
    private boolean isXmlValue = false;
    private boolean isXmlId = false;
    private boolean isXmlIdRef = false;
    private boolean isXmlTransformation = false;
    private boolean isXmlLocation = false;
    private String inverseReferencePropertyName;
    private String inverseReferencePropertyGetMethodName;
    private String inverseReferencePropertySetMethodName;
    private JavaClass inverseReferencePropertyContainerClass;
    private boolean isInverseReference;
    private boolean isWriteableInverseReference;
    private boolean lax;
    private String domHandlerClassName;
    private String variableAttributeName;
    private String variableClassName;
    private boolean variableNodeAttribute;
    private JavaClass keyType;
    private JavaClass valueType;
    public static final String DEFAULT_KEY_NAME = "key";
    public static final String DEFAULT_VALUE_NAME = "value";
    private boolean isMap = false;
    private String xmlPath;
    private Collection<Property> choiceProperties;
    private XmlElements xmlElements;
    private boolean isChoice = false;
    private ArrayList<ElementDeclaration> referencedElements;
    private List<XmlElementRef> xmlElementRefs;
    private boolean isReference = false;
    private XmlJoinNodes xmlJoinNodes;
    private List<XmlJoinNodes> xmlJoinNodesList;
    private boolean isSuperClassProperty;
    private boolean isTransientType;
    private static final String MARSHAL_METHOD_NAME = "marshal";
    private boolean isTyped;

    public Property() {
    }

    public Property(Helper helper) {
        this.helper = helper;
    }

    public void setHelper(Helper helper) {
        this.helper = helper;
    }

    public void setAdapterClass(JavaClass adapterCls) {
        this.adapterClass = adapterCls;
        Type genericSuperClass = adapterCls.getGenericSuperclass();
        while (genericSuperClass != null && genericSuperClass instanceof Class) {
            genericSuperClass = ((Class)genericSuperClass).getGenericSuperclass();
        }
        if (genericSuperClass != null) {
            ParameterizedType parameterizedSuperClass = (ParameterizedType)genericSuperClass;
            Type[] typeArguments = parameterizedSuperClass.getActualTypeArguments();
            Type valueType = typeArguments[0];
            Type boundType = typeArguments.length > 1 ? typeArguments[1] : typeArguments[0];
            this.setTypeFromAdapterClass(this.getJavaClassFromType(valueType), this.getJavaClassFromType(boundType));
            return;
        }
        JavaClass newType = this.helper.getJavaClass(Object.class);
        ArrayList<JavaMethod> marshalMethods = new ArrayList<JavaMethod>();
        for (JavaMethod method : this.adapterClass.getMethods()) {
            if (!method.getName().equals(MARSHAL_METHOD_NAME)) continue;
            JavaClass returnType = method.getReturnType();
            if (!returnType.getQualifiedName().equals(newType.getQualifiedName()) && !returnType.isInterface()) {
                newType = method.getReturnType();
                this.setTypeFromAdapterClass(newType, method.getParameterTypes()[0]);
                return;
            }
            marshalMethods.add(method);
        }
        if (marshalMethods.size() == 0) {
            this.setTypeFromAdapterClass(newType, null);
            return;
        }
        for (JavaMethod method : marshalMethods) {
            JavaClass paramType = method.getParameterTypes()[0];
            if (paramType.getQualifiedName().equals(newType.getQualifiedName())) continue;
            this.setTypeFromAdapterClass(newType, paramType);
            return;
        }
        this.setTypeFromAdapterClass(newType, ((JavaMethod)marshalMethods.get(0)).getParameterTypes()[0]);
    }

    private JavaClass getJavaClassFromType(Type t) {
        if (t instanceof Class) {
            return this.helper.getJavaClass((Class)t);
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType paramValueType = (ParameterizedType)t;
            Type rawType = paramValueType.getRawType();
            if (rawType instanceof Class) {
                return this.helper.getJavaClass((Class)rawType);
            }
        } else {
            GenericArrayType genericArrayValueType;
            Type rawType;
            if (t instanceof TypeVariable) {
                TypeVariable valueTypeVariable = (TypeVariable)t;
                return this.helper.getJavaClass((Class)valueTypeVariable.getBounds()[0]);
            }
            if (t instanceof GenericArrayType && (rawType = (genericArrayValueType = (GenericArrayType)t).getGenericComponentType()) instanceof Class) {
                return this.helper.getJavaClass(Array.newInstance((Class)rawType, 1).getClass());
            }
        }
        return null;
    }

    private void setTypeFromAdapterClass(JavaClass newType, JavaClass parameterType) {
        boolean isArray = this.getType().isArray() && !this.getType().getRawName().equals("byte[]");
        boolean isParamTypeArray = false;
        if (parameterType != null) {
            boolean bl = isParamTypeArray = parameterType.isArray() && !parameterType.getRawName().equals("byte[]");
        }
        if ((this.helper.isCollectionType(this.getType()) || isArray) && !this.helper.isCollectionType(parameterType) && !isParamTypeArray) {
            this.setGenericType(newType);
        } else {
            this.setOriginalType(this.getType());
            this.setType(newType);
        }
    }

    public JavaHasAnnotations getElement() {
        return this.element;
    }

    public void setElement(JavaHasAnnotations element) {
        this.element = element;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public QName getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(QName schemaName) {
        this.schemaName = schemaName;
    }

    public boolean isMethodProperty() {
        return this.isMethodProperty;
    }

    public void setMethodProperty(boolean isMethod) {
        this.isMethodProperty = isMethod;
    }

    public void setType(JavaClass cls) {
        if (cls == null) {
            return;
        }
        if (this.type != null && this.type == cls) {
            return;
        }
        String clsName = cls.getRawName();
        if (this.helper.isCollectionType(cls)) {
            this.genericType = this.getGenericType(cls, 0, this.helper);
            this.type = cls;
        } else if (cls.isArray() && !clsName.equals("byte[]")) {
            this.type = cls;
            this.genericType = cls.getComponentType();
        } else {
            this.type = cls;
            this.genericType = null;
        }
        boolean isNewTypeMap = this.helper.getJavaClass(Map.class).isAssignableFrom(this.type);
        this.setIsMap(isNewTypeMap);
        if (this.isMap()) {
            if (this.type.getPackageName().startsWith("java.")) {
                Object[] types = this.type.getActualTypeArguments().toArray();
                if (types.length >= 2) {
                    this.keyType = (JavaClass)types[0];
                    this.valueType = (JavaClass)types[1];
                } else {
                    this.keyType = this.helper.getJavaClass(Object.class);
                    this.valueType = this.helper.getJavaClass(Object.class);
                }
            } else {
                this.keyType = this.getGenericType(this.type, 0, this.helper);
                this.valueType = this.getGenericType(this.type, 1, this.helper);
            }
        }
    }

    private JavaClass getGenericType(JavaClass cls, int argument, Helper helper) {
        Type genericTypeType;
        Collection typeArgs = cls.getActualTypeArguments();
        Object[] typeArgsArray = typeArgs.toArray();
        JavaClass genericType = null;
        if (cls.getPackageName().startsWith("java.")) {
            if (typeArgs.size() > argument) {
                Iterator iterator2 = typeArgs.iterator();
                int x = 0;
                while (x < argument) {
                    iterator2.next();
                    ++x;
                }
                return (JavaClass)iterator2.next();
            }
            return helper.getJavaClass(Object.class);
        }
        HashMap<String, JavaClass> variableToType = null;
        if (cls instanceof JavaClassImpl) {
            variableToType = new HashMap<String, JavaClass>();
            TypeVariable<Class<T>>[] tvs = ((JavaClassImpl)cls).getJavaClass().getTypeParameters();
            if (tvs.length == typeArgsArray.length) {
                int x = 0;
                while (x < tvs.length) {
                    variableToType.put(tvs[x].getName(), (JavaClass)typeArgsArray[x]);
                    ++x;
                }
            }
        }
        if ((genericTypeType = this.getGenericType(cls.getGenericSuperclass(), argument, variableToType)) == null) {
            Type[] typeArray = cls.getGenericInterfaces();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type genericInterface = typeArray[n2];
                genericTypeType = this.getGenericType(genericInterface, argument, variableToType);
                if (genericTypeType != null) break;
                ++n2;
            }
        }
        if (genericTypeType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)genericTypeType;
            JavaClass existing = (JavaClass)variableToType.get(typeVariable.getName());
            if (existing != null) {
                return existing;
            }
            Type[] typeVariableBounds = typeVariable.getBounds();
            if (typeVariableBounds.length > 0) {
                genericTypeType = typeVariableBounds[0];
            }
        }
        if (genericTypeType instanceof Class) {
            genericType = helper.getJavaClass((Class)genericTypeType);
        }
        if (genericType == null || genericTypeType == Object.class) {
            if (typeArgs.size() > argument) {
                Iterator iterator3 = typeArgs.iterator();
                int x = 0;
                while (x < argument) {
                    iterator3.next();
                    ++x;
                }
                genericType = (JavaClass)iterator3.next();
            } else {
                genericType = helper.getJavaClass(Object.class);
            }
        }
        return genericType;
    }

    private Type getGenericType(Type type, int argument, Map<String, JavaClass> variableToType) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class) {
                Class rawTypeClass = (Class)rawType;
                Type[] typeArgs = parameterizedType.getActualTypeArguments();
                TypeVariable<Class<T>>[] tvs = rawTypeClass.getTypeParameters();
                if (tvs.length == typeArgs.length) {
                    int x = 0;
                    while (x < tvs.length) {
                        String name = tvs[x].getName();
                        Type theType = typeArgs[x];
                        if (!variableToType.containsKey(name) && theType instanceof Class) {
                            variableToType.put(name, this.helper.getJavaClass((Class)theType));
                        }
                        ++x;
                    }
                }
                if (rawTypeClass.getPackage().getName().startsWith("java.")) {
                    Type actualType = parameterizedType.getActualTypeArguments()[argument];
                    return actualType;
                }
                Type genericType = this.getGenericType(rawType, argument, variableToType);
                if (genericType != null) {
                    return genericType;
                }
                return parameterizedType.getActualTypeArguments()[argument];
            }
            return this.getGenericType(parameterizedType.getRawType(), argument, variableToType);
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            Type[] typeArray = clazz.getGenericInterfaces();
            int n = typeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type genericInterface = typeArray[n2];
                Type genericType = this.getGenericType(genericInterface, argument, variableToType);
                if (genericType != null) {
                    return genericType;
                }
                ++n2;
            }
            return this.getGenericType(clazz.getGenericSuperclass(), argument, variableToType);
        }
        return null;
    }

    public JavaClass getType() {
        return this.type;
    }

    public JavaClass getGenericType() {
        return this.genericType;
    }

    public void setGenericType(JavaClass genericType) {
        this.genericType = genericType;
    }

    public QName getSchemaType() {
        return this.schemaType;
    }

    public void setSchemaType(QName type) {
        this.schemaType = type;
    }

    public boolean isSwaAttachmentRef() {
        return this.isSwaAttachmentRef;
    }

    public void setIsSwaAttachmentRef(boolean b) {
        this.isSwaAttachmentRef = b;
    }

    public boolean isMtomAttachment() {
        return this.isMtomAttachment;
    }

    public void setIsMtomAttachment(boolean b) {
        this.isMtomAttachment = b;
    }

    public boolean isInlineBinaryData() {
        return this.isInlineBinaryData;
    }

    public void setisInlineBinaryData(boolean b) {
        this.isInlineBinaryData = b;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public boolean isTransientType() {
        return this.isTransientType;
    }

    public void setTransientType(boolean isTransientType) {
        this.isTransientType = isTransientType;
    }

    public void setIsRequired(boolean b) {
        this.isRequired = b;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mType2) {
        this.mimeType = mType2;
    }

    public boolean isAttribute() {
        return this.isAttribute || this.isAnyAttribute;
    }

    public boolean isAnyAttribute() {
        return this.isAnyAttribute;
    }

    public void setIsAttribute(boolean attribute) {
        this.isAttribute = attribute;
    }

    public void setIsAnyAttribute(boolean anyAtribute) {
        this.isAnyAttribute = anyAtribute;
    }

    public String getGetMethodName() {
        return this.getMethodName;
    }

    public void setGetMethodName(String methodName) {
        this.getMethodName = methodName;
    }

    public String getSetMethodName() {
        return this.setMethodName;
    }

    public void setSetMethodName(String methodName) {
        this.setMethodName = methodName;
    }

    public String getOriginalGetMethodName() {
        return this.originalGetMethodName;
    }

    public void setOriginalGetMethodName(String methodName) {
        this.originalGetMethodName = methodName;
    }

    public String getOriginalSetMethodName() {
        return this.originalSetMethodName;
    }

    public void setOriginalSetMethodName(String methodName) {
        this.originalSetMethodName = methodName;
    }

    public boolean isChoice() {
        return this.isChoice;
    }

    public void setChoice(boolean choice) {
        this.isChoice = choice;
    }

    public boolean isAny() {
        return this.isAnyElement;
    }

    public void setIsAny(boolean isAnyElement) {
        this.isAnyElement = isAnyElement;
    }

    public boolean isReference() {
        return this.isReference;
    }

    public void setIsReference(boolean isReference) {
        this.isReference = isReference;
    }

    public boolean isNillable() {
        return this.isNillable;
    }

    public void setNillable(boolean isNillable) {
        this.isNillable = isNillable;
    }

    public boolean isTransient() {
        return this.isTransient;
    }

    public void setTransient(boolean isTransient) {
        this.isTransient = isTransient;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isSetDefaultValue() {
        return this.defaultValue != null;
    }

    public boolean isMixedContent() {
        return this.isMixedContent;
    }

    public void setMixedContent(boolean b) {
        this.isMixedContent = b;
    }

    public void setHasXmlElementType(boolean hasXmlElementType) {
        this.xmlElementType = hasXmlElementType;
    }

    public boolean isXmlElementType() {
        return this.xmlElementType;
    }

    public JavaClass getActualType() {
        if (this.genericType != null) {
            return this.genericType;
        }
        return this.type;
    }

    public JavaClass getOriginalType() {
        return this.originalType;
    }

    public void setOriginalType(JavaClass type) {
        this.originalType = type;
    }

    public boolean isSetXmlJavaTypeAdapter() {
        return this.getXmlJavaTypeAdapter() != null;
    }

    public XmlJavaTypeAdapter getXmlJavaTypeAdapter() {
        return this.xmlJavaTypeAdapter;
    }

    public void setXmlJavaTypeAdapter(XmlJavaTypeAdapter xmlJavaTypeAdapter) {
        this.xmlJavaTypeAdapter = xmlJavaTypeAdapter;
        if (xmlJavaTypeAdapter == null) {
            this.adapterClass = null;
            this.setType(this.originalType);
        } else {
            this.setAdapterClass(this.helper.getJavaClass(xmlJavaTypeAdapter.getValue()));
        }
    }

    public boolean isSetXmlElementWrapper() {
        return this.getXmlElementWrapper() != null;
    }

    public XmlElementWrapper getXmlElementWrapper() {
        return this.xmlElementWrapper;
    }

    public void setXmlElementWrapper(XmlElementWrapper xmlElementWrapper) {
        this.xmlElementWrapper = xmlElementWrapper;
    }

    public void setIsXmlValue(boolean isXmlValue) {
        this.isXmlValue = isXmlValue;
    }

    public boolean isXmlValue() {
        return this.isXmlValue;
    }

    public void setIsXmlList(boolean isXmlList) {
        this.isXmlList = isXmlList;
        if (isXmlList) {
            this.setNillable(false);
        }
    }

    public boolean isXmlList() {
        return this.isXmlList;
    }

    public String getInverseReferencePropertyName() {
        return this.inverseReferencePropertyName;
    }

    public void setInverseReferencePropertyName(String name) {
        this.inverseReferencePropertyName = name;
    }

    public String getInverseReferencePropertyGetMethodName() {
        return this.inverseReferencePropertyGetMethodName;
    }

    public String getInverseReferencePropertySetMethodName() {
        return this.inverseReferencePropertySetMethodName;
    }

    public void setInverseReferencePropertyGetMethodName(String methodName) {
        this.inverseReferencePropertyGetMethodName = methodName;
    }

    public void setInverseReferencePropertySetMethodName(String methodName) {
        this.inverseReferencePropertySetMethodName = methodName;
    }

    public JavaClass getInverseReferencePropertyContainerClass() {
        return this.inverseReferencePropertyContainerClass;
    }

    public void setInverseReferencePropertyContainerClass(JavaClass cls) {
        this.inverseReferencePropertyContainerClass = cls;
    }

    public boolean isXmlId() {
        return this.isXmlId;
    }

    public void setIsXmlId(boolean isXmlId) {
        this.isXmlId = isXmlId;
    }

    public boolean isXmlIdRef() {
        return this.isXmlIdRef;
    }

    public void setIsXmlIdRef(boolean isXmlIdRef) {
        this.isXmlIdRef = isXmlIdRef;
    }

    public boolean isLax() {
        return this.lax;
    }

    public void setLax(boolean b) {
        this.lax = b;
    }

    public String getDomHandlerClassName() {
        return this.domHandlerClassName;
    }

    public void setDomHandlerClassName(String domHandlerClassName) {
        this.domHandlerClassName = domHandlerClassName;
    }

    public JavaClass getKeyType() {
        return this.keyType;
    }

    public void setKeyType(JavaClass keyType) {
        this.keyType = keyType;
    }

    public JavaClass getValueType() {
        return this.valueType;
    }

    public void setValueType(JavaClass valueType) {
        this.valueType = valueType;
    }

    public boolean isMap() {
        return this.isMap;
    }

    private void setIsMap(boolean isMap) {
        this.isMap = isMap;
    }

    public boolean isInverseReference() {
        return this.isInverseReference;
    }

    public void setInverseReference(boolean isInverseReference, boolean isWriteable) {
        this.isInverseReference = isInverseReference;
        this.isWriteableInverseReference = isWriteable;
    }

    public boolean isWriteableInverseReference() {
        return this.isWriteableInverseReference;
    }

    public XmlElements getXmlElements() {
        return this.xmlElements;
    }

    public void setXmlElements(XmlElements xmlElements) {
        this.xmlElements = xmlElements;
    }

    public Collection<Property> getChoiceProperties() {
        return this.choiceProperties;
    }

    public void setChoiceProperties(Collection<Property> properties) {
        this.choiceProperties = properties;
    }

    public List<XmlElementRef> getXmlElementRefs() {
        return this.xmlElementRefs;
    }

    public void setXmlElementRefs(List<XmlElementRef> xmlElementRefs) {
        this.xmlElementRefs = xmlElementRefs;
    }

    public void addReferencedElement(ElementDeclaration element) {
        if (this.referencedElements == null) {
            this.referencedElements = new ArrayList();
        }
        if (!this.referencedElements.contains(element)) {
            this.referencedElements.add(element);
        }
    }

    public List<ElementDeclaration> getReferencedElements() {
        return this.referencedElements;
    }

    public String getFixedValue() {
        return this.fixedValue;
    }

    public void setFixedValue(String fixedValue) {
        this.fixedValue = fixedValue;
    }

    public boolean isPositional() {
        if (this.getXmlPath() == null) {
            return false;
        }
        XMLField field2 = new XMLField(this.getXmlPath());
        XPathFragment frag = field2.getXPathFragment();
        while (frag.getNextFragment() != null && !frag.getNextFragment().isAttribute() && !frag.getNextFragment().nameIsText()) {
            frag = frag.getNextFragment();
        }
        return frag.containsIndex() || frag.getPredicate() != null;
    }

    public void setReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        if (this.isReadOnly == null) {
            return false;
        }
        return this.isReadOnly;
    }

    public boolean isSetReadOnly() {
        return this.isReadOnly != null;
    }

    public void setWriteOnly(boolean isWriteOnly) {
        this.isWriteOnly = isWriteOnly;
    }

    public boolean isWriteOnly() {
        if (this.isWriteOnly == null) {
            return false;
        }
        return this.isWriteOnly;
    }

    public boolean isSetWriteOnly() {
        return this.isWriteOnly != null;
    }

    public void setCdata(boolean isCdata) {
        this.isCdata = isCdata;
    }

    public boolean isCdata() {
        if (this.isCdata == null) {
            return false;
        }
        return this.isCdata;
    }

    public boolean isSetCdata() {
        return this.isCdata != null;
    }

    public String getXmlPath() {
        return this.xmlPath;
    }

    public void setXmlPath(String xmlPath) {
        this.xmlPath = xmlPath;
    }

    public boolean isSetXmlPath() {
        return this.xmlPath != null;
    }

    public XmlAbstractNullPolicy getNullPolicy() {
        return this.nullPolicy;
    }

    public void setNullPolicy(XmlAbstractNullPolicy nullPolicy) {
        this.nullPolicy = nullPolicy;
    }

    public boolean isSetNullPolicy() {
        return this.nullPolicy != null;
    }

    public boolean shouldSetNillable() {
        if (this.isNillable()) {
            return true;
        }
        if (this.isSetNullPolicy()) {
            return this.getNullPolicy().isXsiNilRepresentsNull() || this.getNullPolicy().getNullRepresentationForXml() == XmlMarshalNullRepresentation.XSI_NIL;
        }
        return false;
    }

    public Map<Object, Object> getUserProperties() {
        return this.userProperties;
    }

    public void setUserProperties(Map<Object, Object> userProperties) {
        this.userProperties = userProperties;
    }

    public boolean isSetUserProperties() {
        return this.userProperties != null;
    }

    public XmlTransformation getXmlTransformation() {
        return this.xmlTransformation;
    }

    public void setXmlTransformation(XmlTransformation xmlTransformation) {
        this.xmlTransformation = xmlTransformation;
    }

    public boolean isSetXmlTransformation() {
        return this.xmlTransformation != null;
    }

    public boolean isXmlTransformation() {
        return this.isXmlTransformation;
    }

    public void setIsXmlTransformation(boolean isXmlTransformation) {
        this.isXmlTransformation = isXmlTransformation;
    }

    public void setXmlJoinNodes(XmlJoinNodes xmlJoinNodes) {
        this.xmlJoinNodes = xmlJoinNodes;
        if (xmlJoinNodes != null && !CompilerHelper.hasNonAttributeJoinNodes(this)) {
            this.isAttribute = true;
        }
    }

    public XmlJoinNodes getXmlJoinNodes() {
        return this.xmlJoinNodes;
    }

    public boolean isSetXmlJoinNodes() {
        return this.xmlJoinNodes != null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public List<XmlJoinNodes> getXmlJoinNodesList() {
        return this.xmlJoinNodesList;
    }

    public void setXmlJoinNodesList(List<XmlJoinNodes> xmlJoinNodesList) {
        this.xmlJoinNodesList = xmlJoinNodesList;
        if (xmlJoinNodesList != null && !xmlJoinNodesList.isEmpty() && !CompilerHelper.hasNonAttributeJoinNodes(this)) {
            this.isAttribute = true;
        }
    }

    public boolean isSetXmlJoinNodesList() {
        return this.xmlJoinNodesList != null;
    }

    public boolean isVirtual() {
        return this.isVirtual;
    }

    public void setExtension(boolean value2) {
        this.isVirtual = value2;
    }

    public boolean isXmlLocation() {
        return this.isXmlLocation;
    }

    public void setXmlLocation(boolean isXmlLocation) {
        this.isXmlLocation = isXmlLocation;
    }

    void postInitialize() {
        this.element = null;
    }

    public boolean isSuperClassProperty() {
        return this.isSuperClassProperty;
    }

    public void setIsSuperClassProperty(boolean b) {
        this.isSuperClassProperty = b;
    }

    public String getVariableAttributeName() {
        return this.variableAttributeName;
    }

    public void setVariableAttributeName(String variableAttributeName) {
        this.variableAttributeName = variableAttributeName;
    }

    public String getVariableClassName() {
        return this.variableClassName;
    }

    public void setVariableClassName(String variableClassName) {
        this.variableClassName = variableClassName;
    }

    public boolean isVariableNodeAttribute() {
        return this.variableNodeAttribute;
    }

    public void setVariableNodeAttribute(boolean variableNodeAttribute) {
        this.variableNodeAttribute = variableNodeAttribute;
    }

    public boolean isTyped() {
        return this.isTyped;
    }

    public void setTyped(boolean isTyped) {
        this.isTyped = isTyped;
    }
}

