/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.rs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.activation.DataSource;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.internal.core.helper.CoreClassConstants;
import org.eclipse.persistence.internal.queries.CollectionContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.eclipse.persistence.oxm.JSONWithPadding;

@Produces(value={"application/json", "*/*", "application/x-javascript"})
@Consumes(value={"application/json", "*/*"})
public class MOXyJsonProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final String APPLICATION_XJAVASCRIPT = "application/x-javascript";
    private static final String CHARSET = "charset";
    private static final QName EMPTY_STRING_QNAME = new QName("");
    private static final String JSON = "json";
    private static final String PLUS_JSON = "+json";
    @Context
    protected Providers providers;
    private String attributePrefix = null;
    private Map<Class<?>, javax.xml.bind.JAXBContext> contextCache = new HashMap();
    private boolean formattedOutput = false;
    private boolean includeRoot = false;
    private boolean marshalEmptyCollections = true;
    private Map<String, String> namespacePrefixMapper;
    private char namespaceSeperator = (char)46;
    private String valueWrapper;
    private boolean wrapperAsArrayName = false;

    public String getAttributePrefix() {
        return this.attributePrefix;
    }

    protected Class<?> getDomainClass(Type genericType) {
        if (genericType == null) {
            return Object.class;
        }
        if (genericType instanceof Class && genericType != JAXBElement.class) {
            Class clazz = (Class)genericType;
            if (clazz.isArray()) {
                return this.getDomainClass(clazz.getComponentType());
            }
            return clazz;
        }
        if (genericType instanceof ParameterizedType) {
            Type type = ((ParameterizedType)genericType).getActualTypeArguments()[0];
            if (type instanceof ParameterizedType) {
                Type rawType = ((ParameterizedType)type).getRawType();
                if (rawType == JAXBElement.class) {
                    return this.getDomainClass(type);
                }
            } else if (type instanceof WildcardType) {
                Type upperType;
                Type[] upperTypes = ((WildcardType)type).getUpperBounds();
                if (upperTypes.length > 0 && (upperType = upperTypes[0]) instanceof Class) {
                    return (Class)upperType;
                }
            } else if (JAXBElement.class == type) {
                return Object.class;
            }
            return (Class)type;
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            return this.getDomainClass(genericArrayType.getGenericComponentType());
        }
        return Object.class;
    }

    protected javax.xml.bind.JAXBContext getJAXBContext(Class<?> domainClass, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, ?> httpHeaders) throws JAXBException {
        javax.xml.bind.JAXBContext jaxbContext = this.contextCache.get(domainClass);
        if (jaxbContext != null) {
            return jaxbContext;
        }
        ContextResolver<javax.xml.bind.JAXBContext> resolver = null;
        if (this.providers != null) {
            resolver = this.providers.getContextResolver(javax.xml.bind.JAXBContext.class, mediaType);
        }
        if (resolver == null || (jaxbContext = (javax.xml.bind.JAXBContext)resolver.getContext(domainClass)) == null) {
            jaxbContext = JAXBContextFactory.createContext(new Class[]{domainClass}, null);
            this.contextCache.put(domainClass, jaxbContext);
            return jaxbContext;
        }
        if (jaxbContext instanceof JAXBContext) {
            return jaxbContext;
        }
        jaxbContext = JAXBContextFactory.createContext(new Class[]{domainClass}, null);
        this.contextCache.put(domainClass, jaxbContext);
        return jaxbContext;
    }

    private javax.xml.bind.JAXBContext getJAXBContext(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (genericType == null) {
            genericType = type;
        }
        try {
            Class<?> domainClass = this.getDomainClass(genericType);
            return this.getJAXBContext(domainClass, annotations, mediaType, null);
        }
        catch (JAXBException jAXBException) {
            return null;
        }
    }

    public Map<String, String> getNamespacePrefixMapper() {
        return this.namespacePrefixMapper;
    }

    public char getNamespaceSeparator() {
        return this.namespaceSeperator;
    }

    @Override
    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public String getValueWrapper() {
        return this.valueWrapper;
    }

    public boolean isFormattedOutput() {
        return this.formattedOutput;
    }

    public boolean isIncludeRoot() {
        return this.includeRoot;
    }

    public boolean isMarshalEmptyCollections() {
        return this.marshalEmptyCollections;
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (!this.supportsMediaType(mediaType)) {
            return false;
        }
        if (CoreClassConstants.APBYTE == type || CoreClassConstants.STRING == type) {
            return false;
        }
        if (Map.class.isAssignableFrom(type)) {
            return false;
        }
        if (File.class.isAssignableFrom(type)) {
            return false;
        }
        if (DataSource.class.isAssignableFrom(type)) {
            return false;
        }
        if (InputStream.class.isAssignableFrom(type)) {
            return false;
        }
        if (Reader.class.isAssignableFrom(type)) {
            return false;
        }
        if (Object.class == type) {
            return false;
        }
        if (type.isPrimitive()) {
            return false;
        }
        if (type.isArray() && (type.getComponentType().isArray() || type.getComponentType().isPrimitive() || type.getComponentType().getPackage().getName().startsWith("java."))) {
            return false;
        }
        if (JAXBElement.class.isAssignableFrom(type)) {
            Class<?> domainClass = this.getDomainClass(genericType);
            return this.isReadable(domainClass, null, annotations, mediaType) || String.class == domainClass;
        }
        if (Collection.class.isAssignableFrom(type)) {
            Class<?> domainClass = this.getDomainClass(genericType);
            return this.isReadable(domainClass, null, annotations, mediaType) || String.class == domainClass;
        }
        return this.getJAXBContext(type, genericType, annotations, mediaType) != null;
    }

    public boolean isWrapperAsArrayName() {
        return this.wrapperAsArrayName;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (type == JSONWithPadding.class && APPLICATION_XJAVASCRIPT.equals(mediaType.toString())) {
            return true;
        }
        if (!this.supportsMediaType(mediaType)) {
            return false;
        }
        if (CoreClassConstants.APBYTE == type || CoreClassConstants.STRING == type || type.isPrimitive()) {
            return false;
        }
        if (Map.class.isAssignableFrom(type)) {
            return false;
        }
        if (File.class.isAssignableFrom(type)) {
            return false;
        }
        if (DataSource.class.isAssignableFrom(type)) {
            return false;
        }
        if (StreamingOutput.class.isAssignableFrom(type)) {
            return false;
        }
        if (Object.class == type) {
            return false;
        }
        if (type.isPrimitive()) {
            return false;
        }
        if (type.isArray() && (type.getComponentType().isArray() || type.getComponentType().isPrimitive() || type.getComponentType().getPackage().getName().startsWith("java."))) {
            return false;
        }
        if (JAXBElement.class.isAssignableFrom(type)) {
            Class<?> domainClass = this.getDomainClass(genericType);
            return this.isWriteable(domainClass, null, annotations, mediaType) || domainClass == String.class;
        }
        if (Collection.class.isAssignableFrom(type)) {
            Class<?> domainClass = this.getDomainClass(genericType);
            String packageName = domainClass.getPackage().getName();
            if (packageName != null && packageName.startsWith("java.")) {
                return false;
            }
            return this.isWriteable(domainClass, null, annotations, mediaType) || domainClass == String.class;
        }
        return this.getJAXBContext(type, genericType, annotations, mediaType) != null;
    }

    protected void preReadFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, Unmarshaller unmarshaller) throws JAXBException {
    }

    protected void preWriteTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, Marshaller marshaller) throws JAXBException {
    }

    @Override
    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            StreamSource jsonSource;
            if (genericType == null) {
                genericType = type;
            }
            Class<?> domainClass = this.getDomainClass(genericType);
            javax.xml.bind.JAXBContext jaxbContext = this.getJAXBContext(domainClass, annotations, mediaType, httpHeaders);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            unmarshaller.setProperty("eclipselink.media-type", "application/json");
            unmarshaller.setProperty("eclipselink.json.attribute-prefix", this.attributePrefix);
            unmarshaller.setProperty("eclipselink.json.include-root", this.includeRoot);
            unmarshaller.setProperty("eclipselink.namespace-prefix-mapper", this.namespacePrefixMapper);
            unmarshaller.setProperty("eclipselink.json.namespace-separator", Character.valueOf(this.namespaceSeperator));
            if (this.valueWrapper != null) {
                unmarshaller.setProperty("eclipselink.json.value-wrapper", this.valueWrapper);
            }
            unmarshaller.setProperty("eclipselink.json.wrapper-as-array-name", this.wrapperAsArrayName);
            this.preReadFrom(type, genericType, annotations, mediaType, httpHeaders, unmarshaller);
            Map<String, String> mediaTypeParameters = null;
            if (mediaType != null) {
                mediaTypeParameters = mediaType.getParameters();
            }
            if (mediaTypeParameters != null && mediaTypeParameters.containsKey(CHARSET)) {
                String charSet = mediaTypeParameters.get(CHARSET);
                InputStreamReader entityReader = new InputStreamReader(entityStream, charSet);
                jsonSource = new StreamSource(entityReader);
            } else {
                jsonSource = new StreamSource(entityStream);
            }
            JAXBElement<?> jaxbElement = unmarshaller.unmarshal(jsonSource, domainClass);
            if (type.isAssignableFrom(JAXBElement.class)) {
                return jaxbElement;
            }
            Object value2 = jaxbElement.getValue();
            if (value2 instanceof ArrayList) {
                if (type.isArray()) {
                    ArrayList arrayList = (ArrayList)value2;
                    int arrayListSize = arrayList.size();
                    boolean wrapItemInJAXBElement = this.wrapItemInJAXBElement(genericType);
                    Object array = wrapItemInJAXBElement ? Array.newInstance(JAXBElement.class, arrayListSize) : Array.newInstance(domainClass, arrayListSize);
                    int x = 0;
                    while (x < arrayListSize) {
                        Object element = this.handleJAXBElement(arrayList.get(x), domainClass, wrapItemInJAXBElement);
                        Array.set(array, x, element);
                        ++x;
                    }
                    return array;
                }
                CollectionContainerPolicy containerPolicy = type.isAssignableFrom(List.class) || type.isAssignableFrom(ArrayList.class) || type.isAssignableFrom(Collection.class) ? new CollectionContainerPolicy(ArrayList.class) : (type.isAssignableFrom(Set.class) ? new CollectionContainerPolicy(HashSet.class) : (type.isAssignableFrom(Deque.class) || type.isAssignableFrom(Queue.class) ? new CollectionContainerPolicy(LinkedList.class) : (type.isAssignableFrom(NavigableSet.class) || type.isAssignableFrom(SortedSet.class) ? new CollectionContainerPolicy(TreeSet.class) : new CollectionContainerPolicy(type))));
                Object container = containerPolicy.containerInstance();
                boolean wrapItemInJAXBElement = this.wrapItemInJAXBElement(genericType);
                for (Object element : (Collection)value2) {
                    element = this.handleJAXBElement(element, domainClass, wrapItemInJAXBElement);
                    containerPolicy.addInto(element, container, (AbstractSession)null);
                }
                return container;
            }
            return value2;
        }
        catch (UnmarshalException unmarshalException) {
            Response.ResponseBuilder builder = Response.status(Response.Status.BAD_REQUEST);
            throw new WebApplicationException((Throwable)unmarshalException, builder.build());
        }
        catch (JAXBException jaxbException) {
            throw new WebApplicationException(jaxbException);
        }
    }

    private boolean wrapItemInJAXBElement(Type genericType) {
        if (genericType == JAXBElement.class) {
            return true;
        }
        if (genericType instanceof GenericArrayType) {
            return this.wrapItemInJAXBElement(((GenericArrayType)genericType).getGenericComponentType());
        }
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type actualType = parameterizedType.getActualTypeArguments()[0];
            return this.wrapItemInJAXBElement(parameterizedType.getOwnerType()) || this.wrapItemInJAXBElement(parameterizedType.getRawType()) || this.wrapItemInJAXBElement(actualType);
        }
        return false;
    }

    private Object handleJAXBElement(Object element, Class domainClass, boolean wrapItemInJAXBElement) {
        if (wrapItemInJAXBElement) {
            if (element instanceof JAXBElement) {
                return element;
            }
            return new JAXBElement<Object>(EMPTY_STRING_QNAME, domainClass, element);
        }
        return JAXBIntrospector.getValue(element);
    }

    public void setAttributePrefix(String attributePrefix) {
        this.attributePrefix = attributePrefix;
    }

    public void setFormattedOutput(boolean formattedOutput) {
        this.formattedOutput = formattedOutput;
    }

    public void setIncludeRoot(boolean includeRoot) {
        this.includeRoot = includeRoot;
    }

    public void setMarshalEmptyCollections(boolean marshalEmptyCollections) {
        this.marshalEmptyCollections = marshalEmptyCollections;
    }

    public void setNamespacePrefixMapper(Map<String, String> namespacePrefixMapper) {
        this.namespacePrefixMapper = namespacePrefixMapper;
    }

    public void setNamespaceSeparator(char namespaceSeparator) {
        this.namespaceSeperator = namespaceSeparator;
    }

    public void setWrapperAsArrayName(boolean wrapperAsArrayName) {
        this.wrapperAsArrayName = wrapperAsArrayName;
    }

    public void setValueWrapper(String valueWrapper) {
        this.valueWrapper = valueWrapper;
    }

    protected boolean supportsMediaType(MediaType mediaType) {
        if (mediaType == null) {
            return true;
        }
        String subtype = mediaType.getSubtype();
        return subtype.equals(JSON) || subtype.endsWith(PLUS_JSON);
    }

    @Override
    public void writeTo(Object object, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            if (genericType == null) {
                genericType = type;
            }
            Class<?> domainClass = this.getDomainClass(genericType);
            javax.xml.bind.JAXBContext jaxbContext = this.getJAXBContext(domainClass, annotations, mediaType, httpHeaders);
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", this.formattedOutput);
            marshaller.setProperty("eclipselink.media-type", "application/json");
            marshaller.setProperty("eclipselink.json.attribute-prefix", this.attributePrefix);
            marshaller.setProperty("eclipselink.json.include-root", this.includeRoot);
            marshaller.setProperty("eclipselink.json.marshal-empty-collections", this.marshalEmptyCollections);
            marshaller.setProperty("eclipselink.json.namespace-separator", Character.valueOf(this.namespaceSeperator));
            if (this.valueWrapper != null) {
                marshaller.setProperty("eclipselink.json.value-wrapper", this.valueWrapper);
            }
            marshaller.setProperty("eclipselink.json.wrapper-as-array-name", this.wrapperAsArrayName);
            marshaller.setProperty("eclipselink.namespace-prefix-mapper", this.namespacePrefixMapper);
            Map<String, String> mediaTypeParameters = null;
            if (mediaType != null) {
                mediaTypeParameters = mediaType.getParameters();
            }
            if (mediaTypeParameters != null && mediaTypeParameters.containsKey(CHARSET)) {
                String charSet = mediaTypeParameters.get(CHARSET);
                marshaller.setProperty("jaxb.encoding", charSet);
            }
            this.preWriteTo(object, type, genericType, annotations, mediaType, httpHeaders, marshaller);
            if (domainClass.getPackage().getName().startsWith("java.") && !List.class.isAssignableFrom(type) && !type.isArray()) {
                object = new JAXBElement<Object>(new QName((String)marshaller.getProperty("eclipselink.json.value-wrapper")), domainClass, object);
            }
            marshaller.marshal((Object)object, entityStream);
        }
        catch (JAXBException jaxbException) {
            throw new WebApplicationException(jaxbException);
        }
    }
}

