/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;
import org.eclipse.persistence.jpa.jpql.parser.RangeVariableDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DeleteClause
extends AbstractExpression {
    private String deleteIdentifier;
    private String fromIdentifier;
    private boolean hasSpaceAfterDelete;
    private boolean hasSpaceAfterFrom;
    private AbstractExpression rangeVariableDeclaration;

    public DeleteClause(AbstractExpression parent) {
        super(parent, "DELETE");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getRangeVariableDeclaration().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getRangeVariableDeclaration());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression("DELETE"));
        if (this.hasSpaceAfterDelete) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.fromIdentifier != null) {
            children.add(this.buildStringExpression("FROM"));
        }
        if (this.hasSpaceAfterFrom) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.rangeVariableDeclaration != null) {
            children.add(this.rangeVariableDeclaration);
        }
    }

    public CollectionExpression buildCollectionExpression() {
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>(1);
        children.add((AbstractExpression)this.getRangeVariableDeclaration());
        ArrayList<Boolean> commas = new ArrayList<Boolean>(1);
        commas.add(Boolean.FALSE);
        ArrayList<Boolean> spaces2 = new ArrayList<Boolean>(1);
        spaces2.add(Boolean.FALSE);
        return new CollectionExpression(this, children, commas, spaces2, true);
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.rangeVariableDeclaration != null && this.rangeVariableDeclaration.isAncestor(expression)) {
            return this.getQueryBNF("default_clause_range_variable_declaration");
        }
        return super.findQueryBNF(expression);
    }

    public String getActualDeleteIdentifier() {
        return this.deleteIdentifier != null ? this.deleteIdentifier : "";
    }

    public String getActualFromIdentifier() {
        return this.fromIdentifier != null ? this.fromIdentifier : "";
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("delete_clause");
    }

    public Expression getRangeVariableDeclaration() {
        if (this.rangeVariableDeclaration == null) {
            this.rangeVariableDeclaration = this.buildNullExpression();
        }
        return this.rangeVariableDeclaration;
    }

    public boolean hasFrom() {
        return this.fromIdentifier != null;
    }

    public boolean hasRangeVariableDeclaration() {
        return this.rangeVariableDeclaration != null && !this.rangeVariableDeclaration.isNull();
    }

    public boolean hasSpaceAfterDelete() {
        return this.hasSpaceAfterDelete;
    }

    public boolean hasSpaceAfterFrom() {
        return this.hasSpaceAfterFrom;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.deleteIdentifier = wordParser.moveForward("DELETE");
        boolean bl = this.hasSpaceAfterDelete = wordParser.skipLeadingWhitespace() > 0;
        if (!tolerant || wordParser.startsWithIdentifier("FROM")) {
            this.fromIdentifier = wordParser.moveForward("FROM");
            boolean bl2 = this.hasSpaceAfterFrom = wordParser.skipLeadingWhitespace() > 0;
        }
        if (tolerant) {
            this.rangeVariableDeclaration = this.parse(wordParser, "default_clause_range_variable_declaration", tolerant);
        } else {
            this.rangeVariableDeclaration = new RangeVariableDeclaration(this);
            this.rangeVariableDeclaration.parse(wordParser, tolerant);
        }
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.deleteIdentifier : "DELETE");
        if (this.hasSpaceAfterDelete) {
            writer.append(' ');
        }
        if (this.fromIdentifier != null) {
            writer.append(actual ? this.fromIdentifier : "FROM");
        }
        if (this.hasSpaceAfterFrom) {
            writer.append(' ');
        }
        if (this.rangeVariableDeclaration != null) {
            this.rangeVariableDeclaration.toParsedText(writer, actual);
        }
    }
}

