/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.List;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSingleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.FunctionExpressionFactory;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FunctionExpression
extends AbstractSingleEncapsulatedExpression {
    private String functionName;
    private boolean hasComma;
    private boolean hasSpaceAfterComma;
    private FunctionExpressionFactory.ParameterCount parameterCount;
    private String parameterQueryBNFId;

    public FunctionExpression(AbstractExpression parent, String identifier) {
        super(parent, identifier);
    }

    public FunctionExpression(AbstractExpression parent, String identifier, FunctionExpressionFactory.ParameterCount parameterCount, String parameterQueryBNFId) {
        this(parent, identifier);
        this.parameterCount = parameterCount;
        this.parameterQueryBNFId = parameterQueryBNFId;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    protected void addOrderedEncapsulatedExpressionTo(List<Expression> children) {
        children.add(this.buildStringExpression(this.functionName));
        if (this.hasComma) {
            children.add(this.buildStringExpression(','));
        }
        if (this.hasSpaceAfterComma) {
            children.add(this.buildStringExpression(' '));
        }
        super.addOrderedEncapsulatedExpressionTo(children);
    }

    @Override
    public String getEncapsulatedExpressionQueryBNFId() {
        return this.parameterQueryBNFId;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public FunctionExpressionFactory.ParameterCount getParameterCount() {
        return this.parameterCount;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("function_expression");
    }

    public String getUnquotedFunctionName() {
        return ExpressionTools.unquote(this.functionName);
    }

    public boolean hasComma() {
        return this.hasComma;
    }

    @Override
    public boolean hasEncapsulatedExpression() {
        return this.hasFunctionName() || this.hasComma || super.hasEncapsulatedExpression();
    }

    public boolean hasFunctionName() {
        return ExpressionTools.stringIsNotEmpty(this.functionName);
    }

    public boolean hasSpaceAfterComma() {
        return this.hasSpaceAfterComma;
    }

    @Override
    protected void parseEncapsulatedExpression(WordParser wordParser, int whitespaceCount, boolean tolerant) {
        int count2 = 0;
        if (wordParser.startsWith('\'')) {
            this.functionName = wordParser.word();
            wordParser.moveForward(this.functionName);
            count2 = wordParser.skipLeadingWhitespace();
        } else {
            this.functionName = "";
        }
        this.hasComma = wordParser.startsWith(',');
        if (this.hasComma) {
            wordParser.moveForward(1);
            count2 = wordParser.skipLeadingWhitespace();
            boolean bl = this.hasSpaceAfterComma = count2 > 0;
        }
        if (!wordParser.isTail() && wordParser.character() != ')') {
            super.parseEncapsulatedExpression(wordParser, whitespaceCount, tolerant);
        }
        if (count2 > 0 && !this.hasExpression() && !wordParser.isTail() && wordParser.character() != ')') {
            this.hasSpaceAfterComma = false;
            wordParser.moveBackward(count2);
        }
    }

    @Override
    protected void toParsedTextEncapsulatedExpression(StringBuilder writer, boolean actual) {
        writer.append(this.functionName);
        if (this.hasComma) {
            writer.append(',');
        }
        if (this.hasSpaceAfterComma) {
            writer.append(' ');
        }
        super.toParsedTextEncapsulatedExpression(writer, actual);
    }
}

