/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.AbstractSingleEncapsulatedExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TrimExpression
extends AbstractSingleEncapsulatedExpression {
    private String fromIdentifier;
    private boolean hasFrom;
    private boolean hasSpaceAfterFrom;
    private boolean hasSpaceAfterSpecification;
    private boolean hasSpaceAfterTrimCharacter;
    private Specification specification;
    private String specificationIdentifier;
    private AbstractExpression trimCharacter;

    public TrimExpression(AbstractExpression parent) {
        super(parent, "TRIM");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getTrimCharacter().accept(visitor);
        super.acceptChildren(visitor);
    }

    @Override
    protected void addOrderedEncapsulatedExpressionTo(List<Expression> children) {
        if (this.hasSpecification()) {
            children.add(this.buildStringExpression(this.specification.name()));
        }
        if (this.hasSpaceAfterSpecification) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasTrimCharacter()) {
            children.add(this.trimCharacter);
        }
        if (this.hasSpaceAfterTrimCharacter) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.hasFrom) {
            children.add(this.buildStringExpression("FROM"));
        }
        if (this.hasSpaceAfterFrom) {
            children.add(this.buildStringExpression(' '));
        }
        super.addOrderedEncapsulatedExpressionTo(children);
    }

    @Override
    public String getEncapsulatedExpressionQueryBNFId() {
        return "string_primary";
    }

    public String getActualFromIdentifier() {
        return this.fromIdentifier != null ? this.fromIdentifier : "";
    }

    public String getActualSpecificationIdentifier() {
        return this.specificationIdentifier != null ? this.specificationIdentifier : "";
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("functions_returning_strings");
    }

    public Specification getSpecification() {
        return this.specification;
    }

    public Expression getTrimCharacter() {
        if (this.trimCharacter == null) {
            this.trimCharacter = this.buildNullExpression();
        }
        return this.trimCharacter;
    }

    @Override
    public boolean hasEncapsulatedExpression() {
        return this.hasSpecification() || this.hasTrimCharacter() || this.hasFrom || this.hasExpression();
    }

    public boolean hasFrom() {
        return this.hasFrom;
    }

    public boolean hasSpaceAfterFrom() {
        return this.hasSpaceAfterFrom;
    }

    public boolean hasSpaceAfterSpecification() {
        return this.hasSpaceAfterSpecification;
    }

    public boolean hasSpaceAfterTrimCharacter() {
        return this.hasSpaceAfterTrimCharacter;
    }

    public boolean hasSpecification() {
        return this.specification != Specification.DEFAULT;
    }

    public boolean hasTrimCharacter() {
        return this.trimCharacter != null && !this.trimCharacter.isNull();
    }

    @Override
    protected void parseEncapsulatedExpression(WordParser wordParser, int whitespaceCount, boolean tolerant) {
        this.specification = this.parseTrimSpecification(wordParser);
        if (this.specification != Specification.DEFAULT) {
            this.specificationIdentifier = wordParser.moveForward(this.specification.name().length());
            boolean bl = this.hasSpaceAfterSpecification = wordParser.skipLeadingWhitespace() > 0;
        }
        if (!wordParser.startsWithIdentifier("FROM")) {
            this.trimCharacter = this.parse(wordParser, this.getEncapsulatedExpressionQueryBNFId(), tolerant);
        }
        if (this.hasTrimCharacter()) {
            this.hasSpaceAfterTrimCharacter = wordParser.skipLeadingWhitespace() > 0;
        }
        this.hasFrom = wordParser.startsWithIdentifier("FROM");
        if (this.hasFrom) {
            this.fromIdentifier = wordParser.moveForward("FROM");
            this.hasSpaceAfterFrom = wordParser.skipLeadingWhitespace() > 0;
        }
        super.parseEncapsulatedExpression(wordParser, whitespaceCount, tolerant);
        if (!this.hasFrom && !this.hasExpression() && this.hasTrimCharacter()) {
            this.setExpression(this.trimCharacter);
            this.trimCharacter = null;
            if (this.hasSpaceAfterTrimCharacter) {
                this.hasSpaceAfterTrimCharacter = false;
                wordParser.moveBackward(1);
            }
        }
    }

    private Specification parseTrimSpecification(WordParser wordParser) {
        if (wordParser.startsWithIdentifier("BOTH")) {
            return Specification.BOTH;
        }
        if (wordParser.startsWithIdentifier("LEADING")) {
            return Specification.LEADING;
        }
        if (wordParser.startsWithIdentifier("TRAILING")) {
            return Specification.TRAILING;
        }
        return Specification.DEFAULT;
    }

    @Override
    protected void toParsedTextEncapsulatedExpression(StringBuilder writer, boolean actual) {
        if (this.hasSpecification()) {
            writer.append((Object)this.specification);
        }
        if (this.hasSpaceAfterSpecification) {
            writer.append(' ');
        }
        if (this.hasTrimCharacter()) {
            this.trimCharacter.toParsedText(writer, actual);
        }
        if (this.hasSpaceAfterTrimCharacter) {
            writer.append(' ');
        }
        if (this.hasFrom) {
            writer.append(actual ? this.fromIdentifier : "FROM");
        }
        if (this.hasSpaceAfterFrom) {
            writer.append(' ');
        }
        super.toParsedTextEncapsulatedExpression(writer, actual);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Specification {
        BOTH("BOTH"),
        DEFAULT(""),
        LEADING("LEADING"),
        TRAILING("TRAILING");

        private String value;

        private Specification(String value2) {
            this.value = value2;
        }

        public String getValue() {
            return this.value;
        }
    }
}

