/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.logging;

import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.XMLFormatter;
import org.eclipse.persistence.logging.EclipseLinkLogRecord;

public class XMLLogFormatter
extends XMLFormatter {
    private void a2(StringBuffer sb, int x) {
        if (x < 10) {
            sb.append('0');
        }
        sb.append(x);
    }

    private void appendISO8601(StringBuffer sb, long millis) {
        Date date = new Date(millis);
        sb.append(date.getYear() + 1900);
        sb.append('-');
        this.a2(sb, date.getMonth() + 1);
        sb.append('-');
        this.a2(sb, date.getDate());
        sb.append('T');
        this.a2(sb, date.getHours());
        sb.append(':');
        this.a2(sb, date.getMinutes());
        sb.append(':');
        this.a2(sb, date.getSeconds());
    }

    private void escape(StringBuffer sb, String text) {
        if (text == null) {
            text = "<null>";
        }
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (ch == '<') {
                sb.append("&lt;");
            } else if (ch == '>') {
                sb.append("&gt;");
            } else if (ch == '&') {
                sb.append("&amp;");
            } else {
                sb.append(ch);
            }
            ++i;
        }
    }

    @Override
    public String format(LogRecord record0) {
        StringBuffer sb;
        EclipseLinkLogRecord record2;
        block18: {
            if (!(record0 instanceof EclipseLinkLogRecord)) {
                return super.format(record0);
            }
            record2 = (EclipseLinkLogRecord)record0;
            sb = new StringBuffer(500);
            sb.append("<record>\n");
            if (record2.shouldPrintDate()) {
                sb.append("  <date>");
                this.appendISO8601(sb, record2.getMillis());
                sb.append("</date>\n");
                sb.append("  <millis>");
                sb.append(record2.getMillis());
                sb.append("</millis>\n");
            }
            sb.append("  <sequence>");
            sb.append(record2.getSequenceNumber());
            sb.append("</sequence>\n");
            String name = record2.getLoggerName();
            if (name != null) {
                sb.append("  <logger>");
                this.escape(sb, name);
                sb.append("</logger>\n");
            }
            sb.append("  <level>");
            this.escape(sb, record2.getLevel().toString());
            sb.append("</level>\n");
            if (record2.getSourceClassName() != null) {
                sb.append("  <class>");
                this.escape(sb, record2.getSourceClassName());
                sb.append("</class>\n");
            }
            if (record2.getSourceMethodName() != null) {
                sb.append("  <method>");
                this.escape(sb, record2.getSourceMethodName());
                sb.append("</method>\n");
            }
            if (record2.getSessionString() != null) {
                sb.append("  <session>");
                sb.append(record2.getSessionString());
                sb.append("</session>\n");
            }
            if (record2.getConnection() != null) {
                sb.append("  <connection>");
                sb.append(String.valueOf(System.identityHashCode(record2.getConnection())));
                sb.append("</connection>\n");
            }
            if (record2.shouldPrintThread()) {
                sb.append("  <thread>");
                sb.append(record2.getThreadID());
                sb.append("</thread>\n");
            }
            if (record2.getMessage() != null) {
                String message = this.formatMessage(record2);
                sb.append("  <message>");
                this.escape(sb, message);
                sb.append("</message>");
                sb.append("\n");
            }
            ResourceBundle bundle = record2.getResourceBundle();
            try {
                if (bundle == null || bundle.getString(record2.getMessage()) == null) break block18;
                sb.append("  <key>");
                this.escape(sb, record2.getMessage());
                sb.append("</key>\n");
                sb.append("  <catalog>");
                this.escape(sb, record2.getResourceBundleName());
                sb.append("</catalog>\n");
                Object[] parameters = record2.getParameters();
                int i = 0;
                while (i < parameters.length) {
                    sb.append("  <param>");
                    try {
                        this.escape(sb, parameters[i].toString());
                    }
                    catch (Exception exception) {
                        sb.append("???");
                    }
                    sb.append("</param>\n");
                    ++i;
                }
            }
            catch (Exception exception) {}
        }
        if (record2.getThrown() != null) {
            Throwable th = record2.getThrown();
            sb.append("  <exception>\n");
            sb.append("    <message>");
            this.escape(sb, th.toString());
            sb.append("</message>\n");
            if (record2.getLevel().intValue() == Level.SEVERE.intValue() || record2.getLevel().intValue() <= Level.WARNING.intValue() && record2.shouldLogExceptionStackTrace()) {
                StackTraceElement[] trace = th.getStackTrace();
                int i = 0;
                while (i < trace.length) {
                    StackTraceElement frame = trace[i];
                    sb.append("    <frame>\n");
                    sb.append("      <class>");
                    this.escape(sb, frame.getClassName());
                    sb.append("</class>\n");
                    sb.append("      <method>");
                    this.escape(sb, frame.getMethodName());
                    sb.append("</method>\n");
                    if (frame.getLineNumber() >= 0) {
                        sb.append("      <line>");
                        sb.append(frame.getLineNumber());
                        sb.append("</line>\n");
                    }
                    sb.append("    </frame>\n");
                    ++i;
                }
            }
            sb.append("  </exception>\n");
        }
        sb.append("</record>\n");
        return sb.toString();
    }
}

