/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.structures;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.eis.EISCollectionChangeRecord;
import org.eclipse.persistence.eis.EISOrderedCollectionChangeRecord;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.structures.ArrayCollectionMapping;

public class ArrayCollectionMappingHelper {
    private ArrayCollectionMapping mapping;
    private static Object XXX = new Object();

    public ArrayCollectionMappingHelper(ArrayCollectionMapping mapping) {
        this.mapping = mapping;
    }

    private boolean mapKeyHasChanged(Object element, AbstractSession session) {
        return this.getMapping().mapKeyHasChanged(element, session);
    }

    private Object getRealCollectionAttributeValueFromObject(Object object, AbstractSession session) {
        return this.getMapping().getRealCollectionAttributeValueFromObject(object, session);
    }

    private Object buildAddedElementFromChangeSet(Object changeSet, MergeManager mergeManager, AbstractSession targetSession) {
        return this.getMapping().buildAddedElementFromChangeSet(changeSet, mergeManager, targetSession);
    }

    private Object buildChangeSet(Object element, ObjectChangeSet owner, AbstractSession session) {
        return this.getMapping().buildChangeSet(element, owner, session);
    }

    private Object buildElementFromElement(Object element, MergeManager mergeManager, AbstractSession targetSession) {
        return this.getMapping().buildElementFromElement(element, mergeManager, targetSession);
    }

    private Object buildRemovedElementFromChangeSet(Object changeSet, MergeManager mergeManager, AbstractSession targetSession) {
        return this.getMapping().buildRemovedElementFromChangeSet(changeSet, mergeManager, targetSession);
    }

    protected boolean compareElements(Object element1, Object element2, AbstractSession session) {
        if (element1 == null && element2 == null) {
            return true;
        }
        if (element1 == null || element2 == null) {
            return false;
        }
        if (element2 == XXX) {
            return false;
        }
        return this.getMapping().compareElements(element1, element2, session);
    }

    protected boolean compareElementsForChange(Object element1, Object element2, AbstractSession session) {
        if (element1 == null && element2 == null) {
            return true;
        }
        if (element1 == null || element2 == null) {
            return false;
        }
        if (element2 == XXX) {
            return false;
        }
        return this.getMapping().compareElementsForChange(element1, element2, session);
    }

    public ArrayCollectionMapping getMapping() {
        return this.mapping;
    }

    public ChangeRecord compareForChange(Object clone2, Object backup, ObjectChangeSet owner, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        Object cloneCollection = this.getRealCollectionAttributeValueFromObject(clone2, session);
        Object backupCollection = null;
        backupCollection = owner.isNew() ? cp.containerInstance(1) : this.getRealCollectionAttributeValueFromObject(backup, session);
        if (cp.hasOrder()) {
            return this.compareAttributeValuesForChangeWithOrder(cloneCollection, backupCollection, owner, session);
        }
        return this.compareAttributeValuesForChangeWithoutOrder(cloneCollection, backupCollection, owner, session);
    }

    private ChangeRecord compareAttributeValuesForChangeWithOrder(Object cloneCollection, Object backupCollection, ObjectChangeSet owner, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        Vector cloneVector = cp.vectorFor(cloneCollection, session);
        Vector backupVector = cp.vectorFor(backupCollection, session);
        EISOrderedCollectionChangeRecord changeRecord = new EISOrderedCollectionChangeRecord(owner, this.getAttributeName(), this.getDatabaseMapping());
        int i = 0;
        while (i < cloneVector.size()) {
            Object cloneElement = cloneVector.elementAt(i);
            boolean found = false;
            int j = 0;
            while (j < backupVector.size()) {
                if (this.compareElementsForChange(cloneElement, backupVector.elementAt(j), session)) {
                    found = true;
                    backupVector.setElementAt(XXX, j);
                    changeRecord.addMovedChangeSet(this.buildChangeSet(cloneElement, owner, session), j, i);
                    break;
                }
                ++j;
            }
            if (!found) {
                changeRecord.addAddedChangeSet(this.buildChangeSet(cloneElement, owner, session), i);
            }
            ++i;
        }
        i = 0;
        while (i < backupVector.size()) {
            Object backupElement = backupVector.elementAt(i);
            if (backupElement != XXX) {
                changeRecord.addRemovedChangeSet(this.buildChangeSet(backupElement, owner, session), i);
            }
            ++i;
        }
        if (changeRecord.hasChanges()) {
            return changeRecord;
        }
        return null;
    }

    private ChangeRecord compareAttributeValuesForChangeWithoutOrder(Object cloneCollection, Object backupCollection, ObjectChangeSet owner, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        Vector backupVector = cp.vectorFor(backupCollection, session);
        EISCollectionChangeRecord changeRecord = new EISCollectionChangeRecord(owner, this.getAttributeName(), this.getDatabaseMapping());
        Object cloneIter = cp.iteratorFor(cloneCollection);
        while (cp.hasNext(cloneIter)) {
            Object cloneElement = cp.next(cloneIter, session);
            boolean found = false;
            int i = 0;
            while (i < backupVector.size()) {
                if (this.compareElementsForChange(cloneElement, backupVector.elementAt(i), session)) {
                    found = true;
                    backupVector.setElementAt(XXX, i);
                    if (!this.mapKeyHasChanged(cloneElement, session)) break;
                    changeRecord.addChangedMapKeyChangeSet(this.buildChangeSet(cloneElement, owner, session));
                    break;
                }
                ++i;
            }
            if (found) continue;
            changeRecord.addAddedChangeSet(this.buildChangeSet(cloneElement, owner, session));
        }
        int i = 0;
        while (i < backupVector.size()) {
            Object backupElement = backupVector.elementAt(i);
            if (backupElement != XXX) {
                changeRecord.addRemovedChangeSet(this.buildChangeSet(backupElement, owner, session));
            }
            ++i;
        }
        if (changeRecord.hasChanges()) {
            return changeRecord;
        }
        return null;
    }

    public boolean compareObjects(Object object1, Object object2, AbstractSession session) {
        return this.compareAttributeValues(this.getRealCollectionAttributeValueFromObject(object1, session), this.getRealCollectionAttributeValueFromObject(object2, session), session);
    }

    private boolean compareAttributeValues(Object collection1, Object collection2, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        if (cp.sizeFor(collection1) != cp.sizeFor(collection2)) {
            return false;
        }
        if (cp.sizeFor(collection1) == 0) {
            return true;
        }
        if (cp.hasOrder()) {
            return this.compareAttributeValuesWithOrder(collection1, collection2, session);
        }
        return this.compareAttributeValuesWithoutOrder(collection1, collection2, session);
    }

    private boolean compareAttributeValuesWithOrder(Object collection1, Object collection2, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter1 = cp.iteratorFor(collection1);
        Object iter2 = cp.iteratorFor(collection2);
        while (cp.hasNext(iter1)) {
            if (this.compareElements(cp.next(iter1, session), cp.next(iter2, session), session)) continue;
            return false;
        }
        return true;
    }

    private boolean compareAttributeValuesWithoutOrder(Object collection1, Object collection2, AbstractSession session) {
        ContainerPolicy cp = this.getContainerPolicy();
        Vector vector2 = cp.vectorFor(collection2, session);
        Object iter1 = cp.iteratorFor(collection1);
        while (cp.hasNext(iter1)) {
            Object element1 = cp.next(iter1, session);
            boolean found = false;
            int i = 0;
            while (i < vector2.size()) {
                if (this.compareElements(element1, vector2.elementAt(i), session)) {
                    found = true;
                    vector2.setElementAt(XXX, i);
                    break;
                }
                ++i;
            }
            if (found) continue;
            return false;
        }
        Enumeration stream = vector2.elements();
        while (stream.hasMoreElements()) {
            if (stream.nextElement() == XXX) continue;
            return false;
        }
        return true;
    }

    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        if (this.getContainerPolicy().hasOrder()) {
            this.mergeChangesIntoObjectWithOrder(target, changeRecord, source, mergeManager, targetSession);
        } else {
            this.mergeChangesIntoObjectWithoutOrder(target, changeRecord, source, mergeManager, targetSession);
        }
    }

    private void mergeChangesIntoObjectWithOrder(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        ContainerPolicy cp = this.getContainerPolicy();
        AbstractSession session = mergeManager.getSession();
        Vector changes = ((EISOrderedCollectionChangeRecord)changeRecord).getNewCollection();
        Object targetCollection = cp.containerInstance(changes.size());
        Enumeration stream = changes.elements();
        while (stream.hasMoreElements()) {
            Object targetElement = this.buildAddedElementFromChangeSet(stream.nextElement(), mergeManager, targetSession);
            cp.addInto(targetElement, targetCollection, session);
        }
        this.setRealAttributeValueInObject(target, targetCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeChangesIntoObjectWithoutOrder(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        EISCollectionChangeRecord sdkChangeRecord = (EISCollectionChangeRecord)changeRecord;
        ContainerPolicy cp = this.getContainerPolicy();
        AbstractSession session = mergeManager.getSession();
        Object targetCollection = null;
        targetCollection = sdkChangeRecord.getOwner().isNew() ? cp.containerInstance(sdkChangeRecord.getAdds().size()) : this.getRealCollectionAttributeValueFromObject(target, session);
        Vector removes = sdkChangeRecord.getRemoves();
        Vector adds = sdkChangeRecord.getAdds();
        Vector changedMapKeys = sdkChangeRecord.getChangedMapKeys();
        Object object = targetCollection;
        synchronized (object) {
            Enumeration stream = removes.elements();
            while (stream.hasMoreElements()) {
                Object removeElement = this.buildRemovedElementFromChangeSet(stream.nextElement(), mergeManager, targetSession);
                Object targetElement = null;
                Object iter2 = cp.iteratorFor(targetCollection);
                while (cp.hasNext(iter2)) {
                    targetElement = cp.next(iter2, session);
                    if (this.compareElements(targetElement, removeElement, session)) break;
                }
                if (targetElement == null) continue;
                cp.removeFrom(targetElement, targetCollection, session);
            }
            stream = adds.elements();
            while (stream.hasMoreElements()) {
                Object addElement = this.buildAddedElementFromChangeSet(stream.nextElement(), mergeManager, targetSession);
                cp.addInto(addElement, targetCollection, session);
            }
            stream = changedMapKeys.elements();
            while (stream.hasMoreElements()) {
                Object changedMapKeyElement = this.buildAddedElementFromChangeSet(stream.nextElement(), mergeManager, targetSession);
                Object originalElement = ((UnitOfWorkImpl)session).getOriginalVersionOfObject(changedMapKeyElement);
                cp.removeFrom(originalElement, targetCollection, session);
                cp.addInto(changedMapKeyElement, targetCollection, session);
            }
        }
        this.setRealAttributeValueInObject(target, targetCollection);
    }

    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager, AbstractSession targetSession) {
        ContainerPolicy cp = this.getContainerPolicy();
        AbstractSession session = mergeManager.getSession();
        Object sourceCollection = this.getRealCollectionAttributeValueFromObject(source, session);
        Object targetCollection = cp.containerInstance(cp.sizeFor(sourceCollection));
        Object iter2 = cp.iteratorFor(sourceCollection);
        while (cp.hasNext(iter2)) {
            Object targetElement = this.buildElementFromElement(cp.next(iter2, session), mergeManager, targetSession);
            cp.addInto(targetElement, targetCollection, session);
        }
        this.setRealAttributeValueInObject(target, targetCollection);
    }

    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        if (this.getContainerPolicy().hasOrder()) {
            this.simpleAddToCollectionChangeRecordWithOrder(referenceKey, changeSetToAdd, changeSet, session);
        } else {
            this.simpleAddToCollectionChangeRecordWithoutOrder(referenceKey, changeSetToAdd, changeSet, session);
        }
    }

    private void simpleAddToCollectionChangeRecordWithOrder(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        EISOrderedCollectionChangeRecord changeRecord = (EISOrderedCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            changeRecord = new EISOrderedCollectionChangeRecord(changeSet, this.getAttributeName(), this.getDatabaseMapping());
            changeSet.addChange(changeRecord);
        }
        changeRecord.simpleAddChangeSet(changeSetToAdd);
    }

    private void simpleAddToCollectionChangeRecordWithoutOrder(Object referenceKey, Object changeSetToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        EISCollectionChangeRecord changeRecord = (EISCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            changeRecord = new EISCollectionChangeRecord(changeSet, this.getAttributeName(), this.getDatabaseMapping());
            changeSet.addChange(changeRecord);
        }
        changeRecord.simpleAddChangeSet(changeSetToAdd);
    }

    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object changeSetToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        if (this.getContainerPolicy().hasOrder()) {
            this.simpleRemoveFromCollectionChangeRecordWithOrder(referenceKey, changeSetToRemove, changeSet, session);
        } else {
            this.simpleRemoveFromCollectionChangeRecordWithoutOrder(referenceKey, changeSetToRemove, changeSet, session);
        }
    }

    private void simpleRemoveFromCollectionChangeRecordWithOrder(Object referenceKey, Object changeSetToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        EISOrderedCollectionChangeRecord changeRecord = (EISOrderedCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            changeRecord = new EISOrderedCollectionChangeRecord(changeSet, this.getAttributeName(), this.getDatabaseMapping());
            changeSet.addChange(changeRecord);
        }
        changeRecord.simpleRemoveChangeSet(changeSetToRemove);
    }

    private void simpleRemoveFromCollectionChangeRecordWithoutOrder(Object referenceKey, Object changeSetToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        EISCollectionChangeRecord changeRecord = (EISCollectionChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            changeRecord = new EISCollectionChangeRecord(changeSet, this.getAttributeName(), this.getDatabaseMapping());
            changeSet.addChange(changeRecord);
        }
        changeRecord.simpleRemoveChangeSet(changeSetToRemove);
    }

    private void setRealAttributeValueInObject(Object object, Object attributeValue) {
        this.getMapping().setRealAttributeValueInObject(object, attributeValue);
    }

    private String getAttributeName() {
        return this.getMapping().getAttributeName();
    }

    private ContainerPolicy getContainerPolicy() {
        return this.getMapping().getContainerPolicy();
    }

    public DatabaseMapping getDatabaseMapping() {
        return (DatabaseMapping)((Object)this.getMapping());
    }
}

