/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.structures;

import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDataTypeDescriptor;
import org.eclipse.persistence.mappings.structures.ObjectRelationalDatabaseField;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.WriteObjectQuery;

public class NestedTableMapping
extends CollectionMapping {
    protected DatabaseMapping nestedMapping;
    protected DatabaseField field;
    protected String structureName;

    @Override
    public Expression buildExpression(Object queryObject, QueryByExamplePolicy policy, Expression expressionBuilder, Map processedObjects, AbstractSession session) {
        if (policy.shouldValidateExample()) {
            throw QueryException.unsupportedMappingQueryByExample(queryObject.getClass().getName(), this);
        }
        return null;
    }

    @Override
    public Object clone() {
        NestedTableMapping clone2 = (NestedTableMapping)super.clone();
        return clone2;
    }

    protected Vector collectFields() {
        Vector<DatabaseField> fields = new Vector<DatabaseField>(1);
        fields.addElement(this.getField());
        return fields;
    }

    @Override
    public DatabaseField getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.getField().getName();
    }

    @Override
    public Expression getJoinCriteria(ObjectExpression context, Expression base) {
        return context.ref().equal(base.value());
    }

    public String getStructureName() {
        return this.structureName;
    }

    @Override
    public boolean hasConstraintDependency() {
        return true;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (this.getField() == null) {
            throw DescriptorException.fieldNameNotSetInMapping(this);
        }
        ObjectRelationalDatabaseField field2 = (ObjectRelationalDatabaseField)this.getField();
        field2.setSqlType(2003);
        field2.setSqlTypeName(this.getStructureName());
        this.setField(this.getDescriptor().buildField(this.getField()));
    }

    protected void initializeSelectionCriteria(AbstractSession session) {
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression queryKey = builder.getManualQueryKey(this.getAttributeName(), this.getDescriptor());
        Expression exp1 = builder.ref().equal(queryKey.get(this.getAttributeName()).value());
        Expression exp2 = this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression().rebuildOn(queryKey);
        this.setSelectionCriteria(exp1.and(exp2));
    }

    @Override
    public boolean isNestedTableMapping() {
        return true;
    }

    @Override
    public void postInitialize(AbstractSession session) throws DescriptorException {
        this.initializeSelectionCriteria(session);
    }

    @Override
    public void preDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object objectsIterator = containerPolicy.iteratorFor(objects);
        while (containerPolicy.hasNext(objectsIterator)) {
            DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
            deleteQuery.setIsExecutionClone(true);
            deleteQuery.setObject(containerPolicy.next(objectsIterator, query.getSession()));
            deleteQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(deleteQuery);
        }
        if (!query.getSession().isUnitOfWork()) {
            this.verifyDeleteForUpdate(query);
        }
    }

    @Override
    public void preInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter2 = cp.iteratorFor(objects);
        while (cp.hasNext(iter2)) {
            Object object = cp.next(iter2, query.getSession());
            if (this.isPrivateOwned()) {
                InsertObjectQuery insertQuery = new InsertObjectQuery();
                insertQuery.setIsExecutionClone(true);
                insertQuery.setObject(object);
                insertQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(insertQuery);
                continue;
            }
            if (query.getSession().getCommitManager().isCommitInPreModify(object)) continue;
            ObjectChangeSet changeSet = null;
            UnitOfWorkChangeSet uowChangeSet = null;
            if (query.getSession().isUnitOfWork() && ((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet() != null) {
                uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet();
                changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(object);
            }
            WriteObjectQuery writeQuery = new WriteObjectQuery();
            writeQuery.setIsExecutionClone(true);
            writeQuery.setObject(object);
            writeQuery.setObjectChangeSet(changeSet);
            writeQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(writeQuery);
        }
    }

    @Override
    public void preUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(query.getObject())) {
            return;
        }
        if (query.getObjectChangeSet() != null) {
            this.writeChanges(query.getObjectChangeSet(), query);
        } else {
            this.compareObjectsAndWrite(query);
        }
    }

    protected void setField(DatabaseField theField) {
        this.field = theField;
    }

    public void setFieldName(String FieldName) {
        this.setField(new ObjectRelationalDatabaseField(FieldName));
    }

    public void setStructureName(String structureName) {
        this.structureName = structureName;
    }

    protected void verifyDeleteForUpdate(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object objects = this.readPrivateOwnedForObject(query);
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter2 = cp.iteratorFor(objects);
        while (cp.hasNext(iter2)) {
            query.getSession().deleteObject(cp.next(iter2, query.getSession()));
        }
    }

    @Override
    public void writeFromObjectIntoRow(Object object, AbstractRecord record2, AbstractSession session, DatabaseMapping.WriteType writeType) {
        Array array;
        if (this.isReadOnly()) {
            return;
        }
        Object values = this.getRealCollectionAttributeValueFromObject(object, session);
        ContainerPolicy cp = this.getContainerPolicy();
        Object[] fields = new Object[cp.sizeFor(values)];
        Object valuesIterator = cp.iteratorFor(values);
        int index = 0;
        while (index < cp.sizeFor(values)) {
            Object value2 = cp.next(valuesIterator, session);
            fields[index] = ((ObjectRelationalDataTypeDescriptor)this.getReferenceDescriptor()).getRef(value2, session);
            ++index;
        }
        try {
            try {
                ((DatabaseAccessor)session.getAccessor()).incrementCallCount(session);
                Connection connection = ((DatabaseAccessor)session.getAccessor()).getConnection();
                array = session.getPlatform().createArray(this.getStructureName(), fields, session, connection);
            }
            catch (SQLException exception) {
                throw DatabaseException.sqlException(exception, session.getAccessor(), session, false);
            }
        }
        finally {
            ((DatabaseAccessor)session.getAccessor()).decrementCallCount();
        }
        record2.put(this.getField(), (Object)array);
    }

    @Override
    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, AbstractRecord record2, AbstractSession session, DatabaseMapping.WriteType writeType) {
        Array array;
        if (this.isReadOnly()) {
            return;
        }
        Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
        Object values = this.getRealAttributeValueFromObject(object, session);
        ContainerPolicy containterPolicy = this.getContainerPolicy();
        if (values == null) {
            values = containterPolicy.containerInstance(1);
        }
        Object[] fields = new Object[containterPolicy.sizeFor(values)];
        Object valuesIterator = containterPolicy.iteratorFor(values);
        int index = 0;
        while (index < containterPolicy.sizeFor(values)) {
            Object value2 = containterPolicy.next(valuesIterator, session);
            fields[index] = ((ObjectRelationalDataTypeDescriptor)this.getReferenceDescriptor()).getRef(value2, session);
            ++index;
        }
        try {
            try {
                ((DatabaseAccessor)session.getAccessor()).incrementCallCount(session);
                Connection connection = ((DatabaseAccessor)session.getAccessor()).getConnection();
                array = session.getPlatform().createArray(this.getStructureName(), fields, session, connection);
            }
            catch (SQLException exception) {
                throw DatabaseException.sqlException(exception, session.getAccessor(), session, false);
            }
        }
        finally {
            ((DatabaseAccessor)session.getAccessor()).decrementCallCount();
        }
        record2.put(this.getField(), (Object)array);
    }

    @Override
    public void writeFromObjectIntoRowForShallowInsert(Object object, AbstractRecord record2, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        if (this.getField().isNullable()) {
            record2.put(this.getField(), (Object)null);
        } else {
            this.writeFromObjectIntoRow(object, record2, session, DatabaseMapping.WriteType.INSERT);
        }
    }

    @Override
    public void writeFromObjectIntoRowForUpdateAfterShallowInsert(Object object, AbstractRecord record2, AbstractSession session, DatabaseTable table) {
        if (!this.getField().getTable().equals(table) || !this.getField().isNullable()) {
            return;
        }
        this.writeFromObjectIntoRow(object, record2, session, DatabaseMapping.WriteType.UPDATE);
    }

    @Override
    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, AbstractRecord record2, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        record2.put(this.getField(), (Object)null);
    }

    @Override
    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeQuery, AbstractRecord record2) throws DescriptorException {
        if (!this.isAttributeValueInstantiatedOrChanged(writeQuery.getObject())) {
            return;
        }
        if (writeQuery.getSession().isUnitOfWork() && this.compareObjects(writeQuery.getObject(), writeQuery.getBackupClone(), writeQuery.getSession())) {
            return;
        }
        this.writeFromObjectIntoRow(writeQuery.getObject(), record2, writeQuery.getSession(), DatabaseMapping.WriteType.UPDATE);
    }

    @Override
    public void writeInsertFieldsIntoRow(AbstractRecord record2, AbstractSession session) {
        if (this.isReadOnly()) {
            return;
        }
        record2.put(this.getField(), (Object)null);
    }
}

