/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.XMLMarshaller;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.record.FormattedWriterRecord;
import org.eclipse.persistence.oxm.record.OutputStreamRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class FormattedOutputStreamRecord
extends OutputStreamRecord {
    protected static byte[] CR = FormattedWriterRecord.CR.getBytes(Constants.DEFAULT_CHARSET);
    private byte[] tab;
    private int numberOfTabs = 0;
    private boolean complexType = true;
    private boolean isLastEventText = false;

    private byte[] tab() {
        if (this.tab == null) {
            String sTab = ((XMLMarshaller)this.getMarshaller()).getIndentString();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.writeValue(sTab, true, false, baos);
            this.tab = baos.toByteArray();
        }
        return this.tab;
    }

    @Override
    public void endDocument() {
        this.outputStreamWrite(CR);
    }

    @Override
    public void startDocument(String encoding, String version) {
        super.startDocument(encoding, version);
        this.outputStreamWrite(CR);
    }

    @Override
    public void writeHeader() {
        this.outputStreamWrite(((XMLMarshaller)this.getMarshaller()).getXmlHeader().getBytes());
        this.outputStreamWrite(CR);
    }

    @Override
    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.addPositionalNodes(xPathFragment, namespaceResolver);
        if (this.isStartElementOpen) {
            this.outputStreamWrite((byte)62);
        }
        if (!this.isLastEventText) {
            if (this.numberOfTabs > 0) {
                this.outputStreamWrite(CR);
            }
            this.outputStreamWriteTab();
        }
        this.isStartElementOpen = true;
        this.outputStreamWrite((byte)60);
        byte[] prefixBytes = this.getPrefixBytes(xPathFragment);
        if (prefixBytes != null) {
            this.outputStreamWrite(prefixBytes);
            this.outputStreamWrite((byte)58);
        }
        this.outputStreamWrite(xPathFragment.getLocalNameBytes());
        if (xPathFragment.isGeneratedPrefix()) {
            this.namespaceDeclaration(xPathFragment.getPrefix(), xPathFragment.getNamespaceURI());
        }
        ++this.numberOfTabs;
        this.isLastEventText = false;
    }

    @Override
    public void element(XPathFragment frag) {
        this.isLastEventText = false;
        if (this.isStartElementOpen) {
            this.outputStreamWrite((byte)62);
            this.isStartElementOpen = false;
        }
        this.outputStreamWrite(CR);
        this.outputStreamWriteTab();
        super.element(frag);
    }

    @Override
    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        this.isLastEventText = false;
        --this.numberOfTabs;
        if (this.isStartElementOpen) {
            this.outputStreamWrite((byte)47);
            this.outputStreamWrite((byte)62);
            this.isStartElementOpen = false;
            return;
        }
        if (this.complexType) {
            this.outputStreamWrite(CR);
            this.outputStreamWriteTab();
        } else {
            this.complexType = true;
        }
        super.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public void characters(String value2) {
        super.characters(value2);
        this.isLastEventText = true;
        this.complexType = false;
    }

    @Override
    public void cdata(String value2) {
        if (this.isStartElementOpen) {
            this.outputStreamWrite((byte)62);
            this.isStartElementOpen = false;
        }
        super.cdata(value2);
        this.complexType = false;
    }

    @Override
    public void node(Node node, NamespaceResolver namespaceResolver, String newNamespace, String newName) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (namespaceResolver != null) {
                resolverPfx = namespaceResolver.resolveNamespaceURI(attr.getNamespaceURI());
            }
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", String.valueOf(resolverPfx) + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.namespaceDeclaration(attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue());
        } else {
            try {
                FormattedOutputStreamRecordContentHandler handler = new FormattedOutputStreamRecordContentHandler();
                XMLFragmentReader xfragReader = new XMLFragmentReader(namespaceResolver);
                xfragReader.setContentHandler(handler);
                xfragReader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
                xfragReader.parse(node, newNamespace, newName);
            }
            catch (SAXException sex) {
                throw XMLMarshalException.marshalException(sex);
            }
        }
    }

    private void outputStreamWriteTab() {
        int x = 0;
        while (x < this.numberOfTabs) {
            this.outputStreamWrite(this.tab());
            ++x;
        }
    }

    private class FormattedOutputStreamRecordContentHandler
    extends OutputStreamRecord.OutputStreamRecordContentHandler {
        private FormattedOutputStreamRecordContentHandler() {
            super(FormattedOutputStreamRecord.this);
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            try {
                if (FormattedOutputStreamRecord.this.isStartElementOpen) {
                    FormattedOutputStreamRecord.this.outputStreamWrite((byte)62);
                }
                if (!FormattedOutputStreamRecord.this.isLastEventText) {
                    FormattedOutputStreamRecord.this.outputStreamWrite(CR);
                    FormattedOutputStreamRecord.this.outputStreamWriteTab();
                }
                FormattedOutputStreamRecord.this.outputStreamWrite((byte)60);
                FormattedOutputStreamRecord.this.outputStreamWrite(qName.getBytes("UTF-8"));
                FormattedOutputStreamRecord formattedOutputStreamRecord = FormattedOutputStreamRecord.this;
                formattedOutputStreamRecord.numberOfTabs = formattedOutputStreamRecord.numberOfTabs + 1;
                FormattedOutputStreamRecord.this.isStartElementOpen = true;
                FormattedOutputStreamRecord.this.isLastEventText = false;
                this.handleAttributes(atts);
                this.writePrefixMappings();
            }
            catch (UnsupportedEncodingException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            FormattedOutputStreamRecord.this.isLastEventText = false;
            FormattedOutputStreamRecord formattedOutputStreamRecord = FormattedOutputStreamRecord.this;
            formattedOutputStreamRecord.numberOfTabs = formattedOutputStreamRecord.numberOfTabs - 1;
            if (FormattedOutputStreamRecord.this.isStartElementOpen) {
                FormattedOutputStreamRecord.this.outputStreamWrite((byte)47);
                FormattedOutputStreamRecord.this.outputStreamWrite((byte)62);
                FormattedOutputStreamRecord.this.isStartElementOpen = false;
                FormattedOutputStreamRecord.this.complexType = true;
                return;
            }
            if (FormattedOutputStreamRecord.this.complexType) {
                FormattedOutputStreamRecord.this.outputStreamWrite(CR);
                FormattedOutputStreamRecord.this.outputStreamWriteTab();
            } else {
                FormattedOutputStreamRecord.this.complexType = true;
            }
            super.endElement(namespaceURI, localName, qName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (FormattedOutputStreamRecord.this.isProcessingCData) {
                FormattedOutputStreamRecord.this.cdata(new String(ch, start, length));
                return;
            }
            if (new String(ch).trim().length() == 0) {
                return;
            }
            super.characters(ch, start, length);
            FormattedOutputStreamRecord.this.isLastEventText = true;
            FormattedOutputStreamRecord.this.complexType = false;
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            if (FormattedOutputStreamRecord.this.isStartElementOpen) {
                FormattedOutputStreamRecord.this.outputStreamWrite((byte)62);
                FormattedOutputStreamRecord.this.outputStreamWrite(CR);
                FormattedOutputStreamRecord.this.isStartElementOpen = false;
            }
            this.writeComment(ch, start, length);
            FormattedOutputStreamRecord.this.complexType = false;
        }
    }
}

