/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.ObjectBuilder;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.XMLBinaryDataHelper;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLMarshaller;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.mappings.Descriptor;
import org.eclipse.persistence.internal.oxm.record.ExtendedContentHandler;
import org.eclipse.persistence.internal.oxm.record.XMLFragmentReader;
import org.eclipse.persistence.oxm.CharacterEscapeHandler;
import org.eclipse.persistence.oxm.record.FormattedOutputStreamRecord;
import org.eclipse.persistence.oxm.record.FormattedWriterRecord;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class JSONWriterRecord
extends MarshalRecord<XMLMarshaller> {
    protected boolean isProcessingCData = false;
    protected static final String NULL = "null";
    protected String attributePrefix;
    protected boolean charactersAllowed = false;
    protected CharsetEncoder encoder;
    protected CharacterEscapeHandler characterEscapeHandler;
    protected String callbackName;
    protected Output writer;
    protected Level level;

    public JSONWriterRecord() {
    }

    public JSONWriterRecord(OutputStream outputStream) {
        this();
        this.writer = new OutputStreamOutput(outputStream);
    }

    public JSONWriterRecord(OutputStream outputStream, String callbackName) {
        this(outputStream);
        this.setCallbackName(callbackName);
    }

    public JSONWriterRecord(Writer writer) {
        this();
        this.setWriter(writer);
    }

    public JSONWriterRecord(Writer writer, String callbackName) {
        this(writer);
        this.setCallbackName(callbackName);
    }

    public void setCallbackName(String callbackName) {
        this.callbackName = callbackName;
    }

    @Override
    public void setMarshaller(XMLMarshaller marshaller) {
        super.setMarshaller(marshaller);
        this.attributePrefix = marshaller.getAttributePrefix();
        this.encoder = Charset.forName(marshaller.getEncoding()).newEncoder();
        if (marshaller.getValueWrapper() != null) {
            this.textWrapperFragment = new XPathFragment();
            this.textWrapperFragment.setLocalName(marshaller.getValueWrapper());
        }
        this.characterEscapeHandler = marshaller.getCharacterEscapeHandler();
        this.writer.setMarshaller(marshaller);
    }

    @Override
    public boolean emptyCollection(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, boolean openGrouping) {
        if (((XMLMarshaller)this.marshaller).isMarshalEmptyCollections()) {
            super.emptyCollection(xPathFragment, namespaceResolver, true);
            if (xPathFragment != null) {
                this.startCollection();
                if (!xPathFragment.isSelfFragment()) {
                    this.openStartElement(xPathFragment, namespaceResolver);
                    if (this.level != null) {
                        this.level.setNeedToCloseComplex(false);
                        this.level.setNeedToOpenComplex(false);
                    }
                    this.endElement(xPathFragment, namespaceResolver);
                }
                this.endEmptyCollection();
            }
            return true;
        }
        return super.emptyCollection(xPathFragment, namespaceResolver, openGrouping);
    }

    @Override
    public void forceValueWrapper() {
        this.charactersAllowed = false;
    }

    public Writer getWriter() {
        return this.writer.getWriter();
    }

    public void setWriter(Writer writer) {
        this.writer = new WriterOutput(writer);
    }

    @Override
    public void namespaceDeclaration(String prefix, String namespaceURI) {
    }

    @Override
    public void defaultNamespaceDeclaration(String defaultNamespace) {
    }

    @Override
    public void startDocument(String encoding, String version) {
        try {
            if (this.level != null) {
                if (this.level.isFirst()) {
                    this.level.setFirst(false);
                } else {
                    this.writeListSeparator();
                }
            } else if (this.callbackName != null) {
                this.startCallback();
            }
            this.level = new Level(true, false, this.level);
            this.writer.write('{');
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    protected void writeListSeparator() throws IOException {
        this.writer.write(',');
    }

    protected void writeSeparator() throws IOException {
        this.writer.write(':');
    }

    protected void startCallback() throws IOException {
        if (this.callbackName != null) {
            this.writer.write(this.callbackName);
            this.writer.write('(');
        }
    }

    @Override
    public void endDocument() {
        try {
            this.closeComplex();
            if (this.level != null && this.level.getPreviousLevel() == null) {
                this.endCallback();
            }
            this.level = this.level.getPreviousLevel();
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        try {
            if (this.level.isFirst()) {
                this.level.setFirst(false);
            } else {
                this.writer.write(',');
            }
            if (xPathFragment.nameIsText() && this.level.isCollection() && this.level.isEmptyCollection()) {
                this.writer.write('[');
                this.level.setEmptyCollection(false);
                this.level.setNeedToOpenComplex(false);
                this.charactersAllowed = true;
                this.level = new Level(true, true, this.level);
                return;
            }
            if (this.level.needToOpenComplex) {
                this.writer.write('{');
                this.level.needToOpenComplex = false;
                this.level.needToCloseComplex = true;
            }
            if (!this.level.isCollection() || this.level.isEmptyCollection()) {
                this.writeKey(xPathFragment);
                if (this.level.isCollection() && this.level.isEmptyCollection()) {
                    this.writer.write('[');
                    this.level.setEmptyCollection(false);
                }
            }
            this.charactersAllowed = true;
            this.level = new Level(true, true, this.level);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void element(XPathFragment frag) {
    }

    @Override
    public void attribute(String namespaceURI, String localName, String qName, String value2) {
        XPathFragment xPathFragment = new XPathFragment();
        xPathFragment.setNamespaceURI(namespaceURI);
        xPathFragment.setAttribute(true);
        xPathFragment.setLocalName(localName);
        this.openStartElement(xPathFragment, this.namespaceResolver);
        this.characters(null, value2, null, false, true);
        this.endElement(xPathFragment, this.namespaceResolver);
    }

    @Override
    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value2) {
        this.attribute(xPathFragment, namespaceResolver, (Object)value2, (QName)null);
    }

    @Override
    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    @Override
    public void endPrefixMappings(NamespaceResolver namespaceResolver) {
    }

    @Override
    public void closeStartElement() {
    }

    @Override
    public void endElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        try {
            if (this.level != null) {
                if (this.level.needToOpenComplex) {
                    this.writer.write('{');
                    this.closeComplex();
                } else if (this.level.needToCloseComplex) {
                    this.closeComplex();
                }
                this.charactersAllowed = false;
                this.level = this.level.getPreviousLevel();
            }
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    protected void closeComplex() throws IOException {
        this.writer.write('}');
    }

    @Override
    public void startCollection() {
        if (this.level == null) {
            try {
                this.startCallback();
                this.writer.write('[');
                this.level = new Level(true, false, this.level);
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        } else {
            this.level.setCollection(true);
            this.level.setEmptyCollection(true);
        }
    }

    protected void endEmptyCollection() {
        this.endCollection();
    }

    protected void endCallback() throws IOException {
        if (this.callbackName != null) {
            this.writer.write(')');
            this.writer.write(';');
        }
    }

    @Override
    public void endCollection() {
        try {
            if (this.level != null && this.level.getPreviousLevel() == null) {
                this.writer.write(']');
                this.endCallback();
            } else if (this.level != null && this.level.isCollection() && !this.level.isEmptyCollection()) {
                this.writer.write(']');
            }
            this.level.setCollection(false);
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    public void characters(String value2) {
        this.characters(value2, true, false);
    }

    public void characters(String value2, boolean isString, boolean isAttribute) {
        boolean textWrapperOpened = false;
        if (!this.charactersAllowed && this.textWrapperFragment != null) {
            this.openStartElement(this.textWrapperFragment, this.namespaceResolver);
            textWrapperOpened = true;
        }
        this.level.setNeedToOpenComplex(false);
        try {
            if (isString) {
                this.writer.write('\"');
                this.writeValue(value2, isAttribute);
                this.writer.write('\"');
            } else {
                this.writer.write(value2);
            }
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
        if (textWrapperOpened && this.textWrapperFragment != null) {
            this.endElement(this.textWrapperFragment, this.namespaceResolver);
        }
    }

    @Override
    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, Object value2, QName schemaType) {
        if (xPathFragment.getNamespaceURI() != null && xPathFragment.getNamespaceURI() == "http://www.w3.org/2000/xmlns/") {
            return;
        }
        xPathFragment.setAttribute(true);
        this.openStartElement(xPathFragment, namespaceResolver);
        this.characters(schemaType, value2, null, false, true);
        this.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public void characters(QName schemaType, Object value2, String mimeType, boolean isCDATA) {
        this.characters(schemaType, value2, mimeType, isCDATA, false);
    }

    public void characters(QName schemaType, Object value2, String mimeType, boolean isCDATA, boolean isAttribute) {
        if (mimeType != null) {
            value2 = value2 instanceof List ? XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesListForBinaryValues((List)value2, this.marshaller, mimeType) : (Object)XMLBinaryDataHelper.getXMLBinaryDataHelper().getBytesForBinaryValue(value2, this.marshaller, mimeType).getData();
        }
        if (schemaType != null && Constants.QNAME_QNAME.equals(schemaType)) {
            String convertedValue = this.getStringForQName((QName)value2);
            this.characters(convertedValue);
        } else if (value2.getClass() == String.class) {
            if (schemaType != null && this.isNumericOrBooleanType(schemaType)) {
                String convertedValue = (String)((XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value2, ClassConstants.STRING, schemaType);
                this.characters(convertedValue, false, isAttribute);
            } else if (isCDATA) {
                this.cdata((String)value2);
            } else {
                this.characters((String)value2);
            }
        } else {
            String convertedValue = (String)((XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager()).convertObject(value2, ClassConstants.STRING, schemaType);
            XMLConversionManager cfr_ignored_0 = (XMLConversionManager)this.session.getDatasourcePlatform().getConversionManager();
            Class theClass = (Class)XMLConversionManager.getDefaultXMLTypes().get(schemaType);
            if (schemaType == null || theClass == null) {
                if (value2.getClass() == ClassConstants.BOOLEAN || ClassConstants.NUMBER.isAssignableFrom(value2.getClass())) {
                    this.characters(convertedValue, false, isAttribute);
                } else {
                    this.characters(convertedValue);
                }
            } else if (schemaType != null && !this.isNumericOrBooleanType(schemaType)) {
                this.characters(convertedValue);
            } else if (isCDATA) {
                this.cdata(convertedValue);
            } else {
                this.characters(convertedValue, false, isAttribute);
            }
        }
        this.charactersAllowed = false;
    }

    private boolean isNumericOrBooleanType(QName schemaType) {
        if (schemaType == null) {
            return false;
        }
        return schemaType.equals(Constants.BOOLEAN_QNAME) || schemaType.equals(Constants.INTEGER_QNAME) || schemaType.equals(Constants.INT_QNAME) || schemaType.equals(Constants.BYTE_QNAME) || schemaType.equals(Constants.DECIMAL_QNAME) || schemaType.equals(Constants.FLOAT_QNAME) || schemaType.equals(Constants.DOUBLE_QNAME) || schemaType.equals(Constants.SHORT_QNAME) || schemaType.equals(Constants.LONG_QNAME) || schemaType.equals(Constants.NEGATIVE_INTEGER_QNAME) || schemaType.equals(Constants.NON_NEGATIVE_INTEGER_QNAME) || schemaType.equals(Constants.NON_POSITIVE_INTEGER_QNAME) || schemaType.equals(Constants.POSITIVE_INTEGER_QNAME) || schemaType.equals(Constants.UNSIGNED_BYTE_QNAME) || schemaType.equals(Constants.UNSIGNED_INT_QNAME) || schemaType.equals(Constants.UNSIGNED_LONG_QNAME) || schemaType.equals(Constants.UNSIGNED_SHORT_QNAME);
    }

    @Override
    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
    }

    @Override
    public void nilComplex(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
        this.openStartElement(xPathFragment, namespaceResolver);
        this.characters(NULL, false, false);
        this.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public void nilSimple(NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.characters(NULL, false, false);
        this.closeStartGroupingElements(groupingFragment);
    }

    @Override
    public void emptySimple(NamespaceResolver namespaceResolver) {
        this.nilSimple(namespaceResolver);
    }

    @Override
    public void emptyAttribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.openStartElement(xPathFragment, namespaceResolver);
        this.characters(NULL, false, false);
        this.endElement(xPathFragment, namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
    }

    @Override
    public void emptyComplex(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        XPathFragment groupingFragment = this.openStartGroupingElements(namespaceResolver);
        this.closeStartGroupingElements(groupingFragment);
        this.openStartElement(xPathFragment, namespaceResolver);
        this.endElement(xPathFragment, namespaceResolver);
    }

    @Override
    public void marshalWithoutRootElement(ObjectBuilder treeObjectBuilder, Object object, Descriptor descriptor, Root root, boolean isXMLRoot) {
        if (treeObjectBuilder != null) {
            this.addXsiTypeAndClassIndicatorIfRequired(descriptor, null, descriptor.getDefaultRootElementField(), root, object, isXMLRoot, true);
            treeObjectBuilder.marshalAttributes(this, object, this.session);
        }
    }

    @Override
    public void cdata(String value2) {
        this.characters(value2);
    }

    @Override
    public char getNamespaceSeparator() {
        return ((XMLMarshaller)this.marshaller).getNamespaceSeparator();
    }

    @Override
    public XPathFragment getTextWrapperFragment() {
        return this.textWrapperFragment;
    }

    protected void writeKey(XPathFragment xPathFragment) throws IOException {
        super.openStartElement(xPathFragment, this.namespaceResolver);
        this.writer.write('\"');
        if (xPathFragment.isAttribute() && this.attributePrefix != null) {
            this.writer.writeAttributePrefix();
        }
        if (this.isNamespaceAware() && xPathFragment.getNamespaceURI() != null) {
            String prefix = null;
            if (this.getNamespaceResolver() != null) {
                prefix = ((NamespaceResolver)this.getNamespaceResolver()).resolveNamespaceURI(xPathFragment.getNamespaceURI());
            } else if (this.namespaceResolver != null) {
                prefix = this.namespaceResolver.resolveNamespaceURI(xPathFragment.getNamespaceURI());
            }
            if (prefix != null && !prefix.equals("")) {
                this.writer.write(prefix);
                this.writer.writeNamespaceSeparator();
            }
        }
        this.writer.writeLocalName(xPathFragment);
        this.writer.write('\"');
        this.writeSeparator();
    }

    protected void writeValue(String value2, boolean isAttribute) {
        try {
            if (this.characterEscapeHandler != null) {
                this.writer.writeResultFromCharEscapeHandler(value2, isAttribute);
                return;
            }
            char[] chars = value2.toCharArray();
            int x = 0;
            int charsSize = chars.length;
            while (x < charsSize) {
                char character = chars[x];
                switch (character) {
                    case '\"': {
                        this.writer.write("\\\"");
                        break;
                    }
                    case '\b': {
                        this.writer.write("\\b");
                        break;
                    }
                    case '\f': {
                        this.writer.write("\\f");
                        break;
                    }
                    case '\n': {
                        this.writer.write("\\n");
                        break;
                    }
                    case '\r': {
                        this.writer.write("\\r");
                        break;
                    }
                    case '\t': {
                        this.writer.write("\\t");
                        break;
                    }
                    case '\\': {
                        this.writer.write("\\\\");
                        break;
                    }
                    default: {
                        if (Character.isISOControl(character) || !this.encoder.canEncode(character)) {
                            this.writer.write("\\u");
                            String hex = Integer.toHexString(character).toUpperCase();
                            int i = hex.length();
                            while (i < 4) {
                                this.writer.write("0");
                                ++i;
                            }
                            this.writer.write(hex);
                            break;
                        }
                        this.writer.write(character);
                    }
                }
                ++x;
            }
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    @Override
    protected String getStringForQName(QName qName) {
        if (qName == null) {
            return null;
        }
        XMLConversionManager xmlConversionManager = (XMLConversionManager)((CoreAbstractSession)this.getSession()).getDatasourcePlatform().getConversionManager();
        return (String)xmlConversionManager.convertObject(qName, String.class);
    }

    @Override
    public void node(Node node, NamespaceResolver namespaceResolver, String uri, String name) {
        if (node.getNodeType() == 2) {
            Attr attr = (Attr)node;
            String resolverPfx = null;
            if (this.getNamespaceResolver() != null) {
                resolverPfx = ((NamespaceResolver)this.getNamespaceResolver()).resolveNamespaceURI(attr.getNamespaceURI());
            }
            attr.getNamespaceURI();
            if (resolverPfx != null) {
                this.attribute(attr.getNamespaceURI(), "", String.valueOf(resolverPfx) + ':' + attr.getLocalName(), attr.getNodeValue());
            } else {
                this.attribute(attr.getNamespaceURI(), "", attr.getName(), attr.getNodeValue());
                if (attr.getNamespaceURI() != null) {
                    this.attribute("http://www.w3.org/2000/xmlns/", "", "xmlns:" + attr.getPrefix(), attr.getNamespaceURI());
                    ((NamespaceResolver)this.getNamespaceResolver()).put(attr.getPrefix(), attr.getNamespaceURI());
                }
            }
        } else if (node.getNodeType() == 3) {
            this.characters(node.getNodeValue(), false, false);
        } else {
            try {
                JSONWriterRecordContentHandler wrcHandler = new JSONWriterRecordContentHandler();
                XMLFragmentReader xfragReader = new XMLFragmentReader(namespaceResolver);
                xfragReader.setContentHandler(wrcHandler);
                xfragReader.setProperty("http://xml.org/sax/properties/lexical-handler", wrcHandler);
                xfragReader.parse(node, uri, name);
            }
            catch (SAXException sex) {
                throw XMLMarshalException.marshalException(sex);
            }
        }
    }

    @Override
    public boolean isWrapperAsCollectionName() {
        return ((XMLMarshaller)this.marshaller).isWrapperAsCollectionName();
    }

    @Override
    public void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    protected class JSONWriterRecordContentHandler
    implements ExtendedContentHandler,
    LexicalHandler {
        JSONWriterRecordContentHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            XPathFragment xPathFragment = new XPathFragment(localName);
            xPathFragment.setNamespaceURI(namespaceURI);
            JSONWriterRecord.this.openStartElement(xPathFragment, JSONWriterRecord.this.namespaceResolver);
            this.handleAttributes(atts);
        }

        @Override
        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            XPathFragment xPathFragment = new XPathFragment(localName);
            xPathFragment.setNamespaceURI(namespaceURI);
            JSONWriterRecord.this.endElement(xPathFragment, JSONWriterRecord.this.namespaceResolver);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String characters = new String(ch, start, length);
            this.characters(characters);
        }

        @Override
        public void characters(CharSequence characters) throws SAXException {
            JSONWriterRecord.this.characters(characters.toString());
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
            JSONWriterRecord.this.isProcessingCData = true;
        }

        @Override
        public void endCDATA() throws SAXException {
            JSONWriterRecord.this.isProcessingCData = false;
        }

        protected void handleAttributes(Attributes atts) {
            int i = 0;
            int attsLength = atts.getLength();
            while (i < attsLength) {
                String qName = atts.getQName(i);
                if (qName == null || !qName.startsWith("xmlns:") && !qName.equals("xmlns")) {
                    JSONWriterRecord.this.attribute(atts.getURI(i), atts.getLocalName(i), qName, atts.getValue(i));
                }
                ++i;
            }
        }

        protected void writeComment(char[] chars, int start, int length) {
        }

        protected void writeCharacters(char[] chars, int start, int length) {
            try {
                this.characters(chars, start, length);
            }
            catch (SAXException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void setNil(boolean isNil) {
        }
    }

    protected static class Level {
        private boolean first;
        private boolean collection;
        private boolean emptyCollection;
        private boolean needToOpenComplex;
        private boolean needToCloseComplex;
        private Level previousLevel;

        public Level(boolean value2, boolean needToOpen) {
            this.first = value2;
            this.needToOpenComplex = needToOpen;
        }

        public Level(boolean value2, boolean needToOpen, Level previousLevel) {
            this(value2, needToOpen);
            this.previousLevel = previousLevel;
        }

        public boolean isNeedToOpenComplex() {
            return this.needToOpenComplex;
        }

        public void setNeedToOpenComplex(boolean needToOpenComplex) {
            this.needToOpenComplex = needToOpenComplex;
        }

        public boolean isNeedToCloseComplex() {
            return this.needToCloseComplex;
        }

        public void setNeedToCloseComplex(boolean needToCloseComplex) {
            this.needToCloseComplex = needToCloseComplex;
        }

        public boolean isEmptyCollection() {
            return this.emptyCollection;
        }

        public void setEmptyCollection(boolean emptyCollection) {
            this.emptyCollection = emptyCollection;
        }

        public boolean isFirst() {
            return this.first;
        }

        public void setFirst(boolean value2) {
            this.first = value2;
        }

        public boolean isCollection() {
            return this.collection;
        }

        public void setCollection(boolean collection) {
            this.collection = collection;
        }

        public Level getPreviousLevel() {
            return this.previousLevel;
        }
    }

    protected static interface Output {
        public void flush() throws IOException;

        public XMLMarshaller getMarshaller();

        public OutputStream getOutputStream();

        public Writer getWriter();

        public void setMarshaller(XMLMarshaller var1);

        public void write(char var1) throws IOException;

        public void write(String var1) throws IOException;

        public void writeAttributePrefix() throws IOException;

        public void writeCR() throws IOException;

        public void writeLocalName(XPathFragment var1) throws IOException;

        public void writeNamespaceSeparator() throws IOException;

        public void writeResultFromCharEscapeHandler(String var1, boolean var2);
    }

    protected static class OutputStreamOutput
    implements Output {
        private static final int BUFFER_SIZE = 512;
        private byte[] attributePrefix;
        private byte[] buffer = new byte[512];
        private int bufferIndex = 0;
        private CharacterEscapeHandler characterEscapeHandler;
        private XMLMarshaller marshaller;
        private char namespaceSeparator;
        private OutputStream outputStream;

        protected OutputStreamOutput(OutputStream writer) {
            this.outputStream = writer;
        }

        @Override
        public void flush() throws IOException {
            this.outputStream.write(this.buffer, 0, this.bufferIndex);
            this.bufferIndex = 0;
            this.outputStream.flush();
        }

        @Override
        public XMLMarshaller getMarshaller() {
            return this.marshaller;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.outputStream;
        }

        @Override
        public Writer getWriter() {
            return null;
        }

        @Override
        public void setMarshaller(XMLMarshaller marshaller) {
            this.marshaller = marshaller;
            String attributePrefix = marshaller.getAttributePrefix();
            if (attributePrefix != null) {
                this.attributePrefix = attributePrefix.getBytes(Constants.DEFAULT_CHARSET);
            }
            this.characterEscapeHandler = marshaller.getCharacterEscapeHandler();
            this.namespaceSeparator = marshaller.getNamespaceSeparator();
        }

        private void write(byte[] bytes) {
            int bytesLength = bytes.length;
            if (this.bufferIndex + bytesLength >= 512) {
                try {
                    this.outputStream.write(this.buffer, 0, this.bufferIndex);
                    this.bufferIndex = 0;
                    if (bytesLength > 512) {
                        this.outputStream.write(bytes);
                        return;
                    }
                }
                catch (IOException e) {
                    throw XMLMarshalException.marshalException(e);
                }
            }
            System.arraycopy(bytes, 0, this.buffer, this.bufferIndex, bytes.length);
            this.bufferIndex += bytesLength;
        }

        @Override
        public void write(char character) throws IOException {
            if (character > '\u007f') {
                if (character > '\u07ff') {
                    if (character >= '\ud800' && character <= '\udfff') {
                        int uc = (character & 0x3FF) << 10;
                        this.write((byte)(0xF0 | uc >> 18));
                        this.write((byte)(0x80 | uc >> 12 & 0x3F));
                        this.write((byte)(0x80 | uc >> 6 & 0x3F));
                        this.write((byte)(128 + (uc & 0x3F)));
                        return;
                    }
                    this.write((byte)(224 + (character >> 12)));
                    this.write((byte)(128 + (character >> 6 & 0x3F)));
                } else {
                    this.write((byte)(192 + (character >> 6)));
                }
                this.write((byte)(128 + (character & 0x3F)));
            } else {
                this.write((byte)character);
            }
        }

        private void write(byte b) {
            if (this.bufferIndex == 512) {
                try {
                    this.outputStream.write(this.buffer, 0, 512);
                    this.bufferIndex = 0;
                }
                catch (IOException e) {
                    throw XMLMarshalException.marshalException(e);
                }
            }
            this.buffer[this.bufferIndex++] = b;
        }

        @Override
        public void write(String text) throws IOException {
            this.write(text.getBytes(Constants.DEFAULT_CHARSET));
        }

        @Override
        public void writeAttributePrefix() throws IOException {
            this.write(this.attributePrefix);
        }

        @Override
        public void writeCR() throws IOException {
            this.write(FormattedOutputStreamRecord.CR);
        }

        @Override
        public void writeLocalName(XPathFragment xPathFragment) throws IOException {
            this.write(xPathFragment.getLocalNameBytes());
        }

        @Override
        public void writeNamespaceSeparator() throws IOException {
            this.write(this.namespaceSeparator);
        }

        @Override
        public void writeResultFromCharEscapeHandler(String value2, boolean isAttribute) {
            try {
                CharArrayWriter out = new CharArrayWriter();
                this.characterEscapeHandler.escape(value2.toCharArray(), 0, value2.length(), isAttribute, out);
                byte[] bytes = out.toString().getBytes();
                this.write(bytes);
                out.close();
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }
    }

    private static class WriterOutput
    implements Output {
        private String attributePrefix;
        private CharacterEscapeHandler characterEscapeHandler;
        private XMLMarshaller marshaller;
        private char namespaceSeparator;
        private Writer writer;

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        protected WriterOutput(Writer writer) {
            this.writer = writer;
        }

        @Override
        public XMLMarshaller getMarshaller() {
            return this.marshaller;
        }

        @Override
        public OutputStream getOutputStream() {
            return null;
        }

        @Override
        public Writer getWriter() {
            return this.writer;
        }

        @Override
        public void setMarshaller(XMLMarshaller marshaller) {
            this.marshaller = marshaller;
            this.attributePrefix = marshaller.getAttributePrefix();
            this.characterEscapeHandler = marshaller.getCharacterEscapeHandler();
            this.namespaceSeparator = marshaller.getNamespaceSeparator();
        }

        @Override
        public void writeAttributePrefix() throws IOException {
            this.writer.write(this.attributePrefix);
        }

        @Override
        public void write(char character) throws IOException {
            this.writer.write(character);
        }

        @Override
        public void write(String text) throws IOException {
            this.writer.write(text);
        }

        @Override
        public void writeCR() throws IOException {
            this.writer.write(FormattedWriterRecord.CR);
        }

        @Override
        public void writeLocalName(XPathFragment xPathFragment) throws IOException {
            this.writer.write(xPathFragment.getLocalName());
        }

        @Override
        public void writeNamespaceSeparator() throws IOException {
            this.writer.write(this.namespaceSeparator);
        }

        @Override
        public void writeResultFromCharEscapeHandler(String value2, boolean isAttribute) {
            try {
                this.characterEscapeHandler.escape(value2.toCharArray(), 0, value2.length(), isAttribute, this.writer);
            }
            catch (IOException e) {
                throw XMLMarshalException.marshalException(e);
            }
        }
    }
}

