/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle;

import java.sql.Array;
import java.sql.Connection;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Hashtable;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.REF;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.FieldTypeDefinition;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.databaseaccess.SimpleAppendCallCustomParameter;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.queries.Call;

public class Oracle8Platform
extends OraclePlatform {
    protected boolean usesLocatorForLOBWrite = true;
    protected int lobValueLimits = 0;

    @Override
    protected Hashtable buildFieldTypes() {
        Hashtable fieldTypeMapping = super.buildFieldTypes();
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("BLOB", false));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("CLOB", false));
        return fieldTypeMapping;
    }

    @Override
    public void copyInto(Platform platform) {
        super.copyInto(platform);
        if (!(platform instanceof Oracle8Platform)) {
            return;
        }
        Oracle8Platform oracle8Platform = (Oracle8Platform)platform;
        oracle8Platform.setShouldUseLocatorForLOBWrite(this.shouldUseLocatorForLOBWrite());
        oracle8Platform.setLobValueLimits(this.getLobValueLimits());
    }

    protected boolean lobValueExceedsLimit(Object value2) {
        if (value2 == null) {
            return false;
        }
        int limit = this.getLobValueLimits();
        if (value2 instanceof byte[]) {
            return ((byte[])value2).length >= limit;
        }
        if (value2 instanceof String) {
            return ((String)value2).length() >= limit;
        }
        return false;
    }

    @Override
    public Connection getConnection(AbstractSession session, Connection connection) {
        if (session.getServerPlatform() != null && session.getLogin().shouldUseExternalConnectionPooling()) {
            return session.getServerPlatform().unwrapConnection(connection);
        }
        return connection;
    }

    @Override
    public Object getCustomModifyValueForCall(Call call, Object value2, DatabaseField field2, boolean shouldBind) {
        Class type = field2.getType();
        if (ClassConstants.BLOB.equals(type) || ClassConstants.CLOB.equals(type)) {
            if (value2 == null) {
                return null;
            }
            value2 = this.convertToDatabaseType(value2);
            if (this.shouldUseLocatorForLOBWrite() && this.lobValueExceedsLimit(value2)) {
                ((DatabaseCall)call).addContext(field2, value2);
                value2 = ClassConstants.BLOB.equals(type) ? (shouldBind ? (Object)new byte[1] : new SimpleAppendCallCustomParameter("empty_blob()")) : (shouldBind ? new String(" ") : new SimpleAppendCallCustomParameter("empty_clob()"));
            }
            return value2;
        }
        return super.getCustomModifyValueForCall(call, value2, field2, shouldBind);
    }

    @Override
    public boolean shouldUseCustomModifyForCall(DatabaseField field2) {
        Class type;
        if (this.shouldUseLocatorForLOBWrite() && (ClassConstants.BLOB.equals(type = field2.getType()) || ClassConstants.CLOB.equals(type))) {
            return true;
        }
        return super.shouldUseCustomModifyForCall(field2);
    }

    @Override
    public void writeLOB(DatabaseField field2, Object value2, ResultSet resultSet, AbstractSession session) throws SQLException {
        if (this.isBlob(field2.getType())) {
            BLOB blob = (BLOB)resultSet.getObject(field2.getName());
            blob.putBytes(1L, (byte[])value2);
            session.log(1, "sql", "write_BLOB", blob.length(), field2.getName());
        } else if (this.isClob(field2.getType())) {
            CLOB clob = (CLOB)resultSet.getObject(field2.getName());
            clob.putString(1L, (String)value2);
            session.log(1, "sql", "write_CLOB", clob.length(), field2.getName());
        }
    }

    protected boolean isBlob(Class type) {
        return ClassConstants.BLOB.equals(type);
    }

    protected boolean isClob(Class type) {
        return ClassConstants.CLOB.equals(type);
    }

    @Override
    public boolean isNativeConnectionRequiredForLobLocator() {
        return true;
    }

    public void setShouldUseLocatorForLOBWrite(boolean usesLocatorForLOBWrite) {
        this.usesLocatorForLOBWrite = usesLocatorForLOBWrite;
    }

    public boolean shouldUseLocatorForLOBWrite() {
        return this.usesLocatorForLOBWrite;
    }

    public int getLobValueLimits() {
        return this.lobValueLimits;
    }

    public void setLobValueLimits(int lobValueLimits) {
        this.lobValueLimits = lobValueLimits;
    }

    @Override
    public Array createArray(String elementDataTypeName, Object[] elements, Connection connection) throws SQLException {
        return new ARRAY(new ArrayDescriptor(elementDataTypeName, connection), connection, (Object)elements);
    }

    @Override
    public Struct createStruct(String structTypeName, Object[] attributes, Connection connection) throws SQLException {
        return new STRUCT(new StructDescriptor(structTypeName, connection), connection, attributes);
    }

    @Override
    public Object getRefValue(Ref ref, Connection connection) throws SQLException {
        ((REF)ref).setPhysicalConnectionOf(connection);
        return ((REF)ref).getValue();
    }

    @Override
    public void freeTemporaryObject(Object value2) throws SQLException {
        if (value2 instanceof CLOB && ((CLOB)value2).isTemporary()) {
            ((CLOB)value2).freeTemporary();
        } else if (value2 instanceof BLOB && ((BLOB)value2).isTemporary()) {
            ((BLOB)value2).freeTemporary();
        }
    }
}

