/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.plsql;

import java.util.List;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.helper.ComplexDatabaseType;
import org.eclipse.persistence.internal.helper.DatabaseType;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.jdbc.JDBCTypes;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLStoredProcedureCall;
import org.eclipse.persistence.platform.database.oracle.plsql.PLSQLargument;

public class PLSQLStoredFunctionCall
extends PLSQLStoredProcedureCall {
    public PLSQLStoredFunctionCall() {
        this.arguments.add(new PLSQLargument("RESULT", this.originalIndex++, OUT, JDBCTypes.VARCHAR_TYPE));
    }

    public PLSQLStoredFunctionCall(DatabaseType databaseType) {
        DatabaseType dt = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument("RESULT", this.originalIndex++, OUT, dt));
    }

    public PLSQLStoredFunctionCall(DatabaseType databaseType, int length) {
        DatabaseType dt = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument("RESULT", this.originalIndex++, OUT, dt, length));
    }

    public PLSQLStoredFunctionCall(DatabaseType databaseType, int length, int scale) {
        DatabaseType dt = databaseType.isComplexDatabaseType() ? ((ComplexDatabaseType)databaseType).clone() : databaseType;
        this.arguments.add(new PLSQLargument("RESULT", this.originalIndex++, OUT, dt, length, scale));
    }

    @Override
    public String getCallHeader(DatabasePlatform platform) {
        return platform.getFunctionCallHeader();
    }

    @Override
    public int getFirstParameterIndexForCallString() {
        return 1;
    }

    @Override
    public boolean isStoredFunctionCall() {
        return true;
    }

    @Override
    public boolean isStoredPLSQLFunctionCall() {
        return true;
    }

    @Override
    public void prepareInternal(AbstractSession session) {
        if (!session.getPlatform().supportsStoredFunctions()) {
            throw ValidationException.platformDoesNotSupportStoredFunctions(Helper.getShortClassName(session.getPlatform()));
        }
        super.prepareInternal(session);
    }

    public void setResult(DatabaseType databaseType) {
        ((PLSQLargument)this.arguments.get((int)0)).databaseType = databaseType;
    }

    public void setResult(DatabaseType databaseType, int length) {
        ((PLSQLargument)this.arguments.get((int)0)).databaseType = databaseType;
        ((PLSQLargument)this.arguments.get((int)0)).length = length;
    }

    public void setResult(DatabaseType databaseType, int length, int scale) {
        ((PLSQLargument)this.arguments.get((int)0)).databaseType = databaseType;
        ((PLSQLargument)this.arguments.get((int)0)).length = length;
        ((PLSQLargument)this.arguments.get((int)0)).scale = scale;
    }

    @Override
    protected void buildProcedureInvocation(StringBuilder sb, List<PLSQLargument> arguments) {
        sb.append("  ");
        PLSQLargument argument = arguments.get(0);
        sb.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(argument));
        sb.append(" := ");
        sb.append(this.getProcedureName());
        sb.append("(");
        int size2 = arguments.size();
        int index = 1;
        while (index < size2) {
            argument = arguments.get(index);
            sb.append(argument.name);
            sb.append("=>");
            sb.append(DatabaseType.DatabaseTypeHelper.databaseTypeHelper.buildTarget(argument));
            if (index + 1 < size2) {
                sb.append(", ");
            }
            ++index;
        }
        sb.append(");");
        sb.append(Helper.NL);
    }
}

