/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.persistence.core.queries.CoreAttributeGroup;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.queries.AttributeItem;
import org.eclipse.persistence.queries.FetchGroup;
import org.eclipse.persistence.queries.LoadGroup;
import org.eclipse.persistence.sessions.CopyGroup;

public class AttributeGroup
extends CoreAttributeGroup<AttributeItem>
implements Serializable,
Cloneable {
    public AttributeGroup(String name) {
        this.name = name;
    }

    public AttributeGroup(String name, Class type, boolean isValidated) {
        this(name);
        this.type = type;
        this.isValidated = isValidated;
    }

    public AttributeGroup(String name, String type, boolean isValidated) {
        this(name);
        this.typeName = type;
        this.isValidated = isValidated;
    }

    public AttributeGroup() {
        this("");
    }

    public void addAttribute(String attributeNameOrPath, AttributeGroup group) {
        super.addAttribute(attributeNameOrPath, group);
    }

    @Override
    public AttributeGroup getGroup(String attributeNameOrPath) {
        return (AttributeGroup)super.getGroup(attributeNameOrPath);
    }

    public boolean isSupersetOf(AttributeGroup anotherGroup) {
        return super.isSupersetOf(anotherGroup);
    }

    @Override
    public AttributeItem getItem(String attributeNameOrPath) {
        return (AttributeItem)super.getItem(attributeNameOrPath);
    }

    protected AttributeItem newItem(AttributeGroup group, String attrName) {
        return new AttributeItem(group, attrName);
    }

    @Override
    public AttributeGroup findGroup(ClassDescriptor type) {
        return (AttributeGroup)super.findGroup(type);
    }

    public FetchGroup toFetchGroup() {
        if (this.isFetchGroup()) {
            return (FetchGroup)this;
        }
        return this.toFetchGroup(new HashMap<AttributeGroup, FetchGroup>());
    }

    public FetchGroup toFetchGroup(Map<AttributeGroup, FetchGroup> cloneMap) {
        FetchGroup clone2 = cloneMap.get(this);
        if (clone2 != null) {
            return clone2;
        }
        clone2 = new FetchGroup(this.name);
        clone2.type = this.type;
        clone2.typeName = this.typeName;
        clone2.isValidated = this.isValidated;
        cloneMap.put(this, clone2);
        if (this.superClassGroup != null) {
            clone2.superClassGroup = ((AttributeGroup)this.superClassGroup).toFetchGroup(cloneMap);
        }
        if (this.allsubclasses != null) {
            for (CoreAttributeGroup group : this.allsubclasses.values()) {
                clone2.getSubClassGroups().put(group.getType(), ((AttributeGroup)group).toFetchGroup(cloneMap));
            }
        }
        if (this.subClasses != null) {
            clone2.subClasses = new HashSet();
            for (CoreAttributeGroup group : this.subClasses) {
                clone2.subClasses.add(((AttributeGroup)group).toFetchGroup(cloneMap));
            }
        }
        clone2.items = null;
        if (this.hasItems()) {
            clone2.items = new HashMap();
            for (AttributeItem item : this.items.values()) {
                clone2.items.put(item.getAttributeName(), item.toFetchGroup(cloneMap, clone2));
            }
        }
        return clone2;
    }

    @Override
    public boolean isCopyGroup() {
        return false;
    }

    public CopyGroup toCopyGroup() {
        if (this.isCopyGroup()) {
            return (CopyGroup)this;
        }
        IdentityHashMap<AttributeGroup, CopyGroup> cloneMap = new IdentityHashMap<AttributeGroup, CopyGroup>();
        return this.toCopyGroup(cloneMap, new HashMap());
    }

    public CopyGroup toCopyGroup(Map<AttributeGroup, CopyGroup> cloneMap, Map copies) {
        CopyGroup clone2 = cloneMap.get(this);
        if (clone2 != null) {
            return clone2;
        }
        clone2 = new CopyGroup(this.name);
        clone2.cascadeTree();
        clone2.setCopies(copies);
        clone2.type = this.type;
        clone2.typeName = this.typeName;
        clone2.isValidated = this.isValidated;
        cloneMap.put(this, clone2);
        if (this.allsubclasses != null) {
            for (CoreAttributeGroup group : this.allsubclasses.values()) {
                clone2.getSubClassGroups().put(group.getType(), ((AttributeGroup)group).toCopyGroup(cloneMap, copies));
            }
        }
        if (this.superClassGroup != null) {
            clone2.superClassGroup = ((AttributeGroup)this.superClassGroup).toCopyGroup(cloneMap, copies);
        }
        if (this.subClasses != null) {
            clone2.subClasses = new HashSet();
            for (CoreAttributeGroup group : this.subClasses) {
                clone2.subClasses.add(((AttributeGroup)group).toCopyGroup(cloneMap, copies));
            }
        }
        clone2.items = null;
        if (this.hasItems()) {
            clone2.items = new HashMap();
            for (AttributeItem item : this.items.values()) {
                clone2.items.put(item.getAttributeName(), item.toCopyGroup(cloneMap, clone2, copies));
            }
        }
        return clone2;
    }

    @Override
    public boolean isLoadGroup() {
        return false;
    }

    public LoadGroup toLoadGroup() {
        if (this.isLoadGroup()) {
            return (LoadGroup)this;
        }
        return this.toLoadGroup(new HashMap<AttributeGroup, LoadGroup>(), false);
    }

    public LoadGroup toLoadGroup(Map<AttributeGroup, LoadGroup> cloneMap, boolean loadOnly) {
        LoadGroup clone2 = cloneMap.get(this);
        if (clone2 != null) {
            return clone2;
        }
        clone2 = new LoadGroup(this.name);
        clone2.type = this.type;
        clone2.typeName = this.typeName;
        clone2.isValidated = this.isValidated;
        cloneMap.put(this, clone2);
        if (this.allsubclasses != null) {
            for (CoreAttributeGroup group : this.allsubclasses.values()) {
                clone2.getSubClassGroups().put(group.getType(), ((AttributeGroup)group).toLoadGroup(cloneMap, loadOnly));
            }
        }
        if (this.superClassGroup != null) {
            clone2.superClassGroup = ((AttributeGroup)this.superClassGroup).toLoadGroup(cloneMap, loadOnly);
        }
        if (this.subClasses != null) {
            clone2.subClasses = new HashSet();
            for (CoreAttributeGroup group : this.subClasses) {
                clone2.subClasses.add(((AttributeGroup)group).toLoadGroup(cloneMap, loadOnly));
            }
        }
        clone2.items = null;
        if (this.hasItems()) {
            clone2.items = new HashMap();
            for (AttributeItem item : this.items.values()) {
                clone2.items.put(item.getAttributeName(), item.toLoadGroup(cloneMap, clone2, loadOnly));
            }
        }
        return clone2;
    }

    @Override
    public AttributeGroup clone() {
        return (AttributeGroup)super.clone();
    }

    @Override
    public boolean isConcurrent() {
        return false;
    }

    @Override
    protected AttributeItem newItem(CoreAttributeGroup group, String attrName) {
        return new AttributeItem((AttributeGroup)group, attrName);
    }

    @Override
    protected AttributeGroup newGroup(String name, CoreAttributeGroup parent) {
        return new AttributeGroup(name);
    }
}

