/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.util.Enumeration;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.Cursor;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;

public abstract class CursorPolicy
extends ContainerPolicy {
    protected int pageSize;
    protected ReadQuery query;

    public CursorPolicy() {
        this.setPageSize(10);
    }

    public CursorPolicy(ReadQuery query, int pageSize) {
        this.setQuery(query);
        this.setPageSize(pageSize);
    }

    @Override
    public ContainerPolicy clone(ReadQuery query) {
        CursorPolicy clone2 = (CursorPolicy)super.clone(query);
        clone2.setQuery(query);
        return clone2;
    }

    @Override
    public CollectionChangeEvent createChangeEvent(Object collectionOwner, String propertyName, Object collectionChanged, Object elementChanged, int changeType, Integer index, boolean isChangeApplied) {
        throw ValidationException.operationNotSupported("createChangeEvent");
    }

    @Override
    public abstract Object execute();

    public int getPageSize() {
        return this.pageSize;
    }

    public ReadQuery getQuery() {
        return this.query;
    }

    @Override
    public boolean hasNext(Object iterator2) {
        return ((Enumeration)iterator2).hasMoreElements();
    }

    @Override
    public boolean isCursorPolicy() {
        return true;
    }

    @Override
    public Object iteratorFor(Object container) {
        return container;
    }

    @Override
    protected Object next(Object iterator2) {
        return ((Enumeration)iterator2).nextElement();
    }

    @Override
    public boolean overridesRead() {
        return true;
    }

    @Override
    public void prepare(DatabaseQuery query, AbstractSession session) throws QueryException {
        super.prepare(query, session);
        this.setQuery((ReadQuery)query);
        ClassDescriptor descriptor = query.getDescriptor();
        if (descriptor != null) {
            if (descriptor.isDescriptorForInterface()) {
                throw QueryException.noCursorSupport(query);
            }
            if (query.isObjectLevelReadQuery() && descriptor.hasInheritance()) {
                ((ObjectLevelReadQuery)query).setShouldOuterJoinSubclasses(true);
            }
        }
        query.getQueryMechanism().prepareCursorSelectAllRows();
    }

    @Override
    public abstract Object remoteExecute();

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setQuery(ReadQuery query) {
        this.query = query;
    }

    @Override
    public int sizeFor(Object container) {
        return ((Cursor)container).size();
    }

    @Override
    protected Object toStringInfo() {
        return "page size = " + this.getPageSize();
    }
}

