/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.metadata;

import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.SDOTypeHelper;
import org.eclipse.persistence.sessions.Session;

public class TypeStringConverter
implements XMLConverter {
    private SDOTypeHelper typeHelper;

    public TypeStringConverter(SDOTypeHelper helper) {
        this.typeHelper = helper;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public void initialize(DatabaseMapping mapping, Session session) {
    }

    @Override
    public Object convertObjectValueToDataValue(Object object, Session session, XMLMarshaller marshaller) {
        return this.convertObjectValueToDataValue(object, session);
    }

    @Override
    public Object convertDataValueToObjectValue(Object value2, Session session, XMLUnmarshaller unmarshaller) {
        return this.convertDataValueToObjectValue(value2, session);
    }

    @Override
    public Object convertObjectValueToDataValue(Object object, Session session) {
        if (!(object instanceof SDOType)) {
            return null;
        }
        SDOType type = (SDOType)object;
        String typeString = String.valueOf(type.getURI()) + "#" + type.getName();
        return typeString;
    }

    @Override
    public Object convertDataValueToObjectValue(Object value2, Session session) {
        if (!(value2 instanceof String)) {
            return null;
        }
        String typeString = (String)value2;
        int poundIndex = typeString.indexOf("#");
        String URI2 = typeString.substring(0, poundIndex);
        String name = typeString.substring(poundIndex + 1);
        SDOType type = (SDOType)this.typeHelper.getType(URI2, name);
        return type;
    }
}

