/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.factories;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.sessions.factories.EclipseLinkObjectPersistenceRuntimeXMLProject;
import org.eclipse.persistence.internal.sessions.factories.MissingDescriptorListener;
import org.eclipse.persistence.internal.sessions.factories.ObjectPersistenceRuntimeXMLProject;
import org.eclipse.persistence.internal.sessions.factories.ObjectPersistenceRuntimeXMLProject_11_1_1;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLLogin;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.platform.DOMPlatform;
import org.eclipse.persistence.platform.xml.XMLParser;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.sessions.Project;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLProjectReader {
    protected static boolean shouldUseSchemaValidation = false;
    protected static Project project;
    public static final String SCHEMA_DIR = "org/eclipse/persistence/";
    public static final String OPM_SCHEMA = "object-persistence_1_0.xsd";
    public static final String ECLIPSELINK_SCHEMA = "eclipselink_persistence_map_2.3.xsd";
    public static final String ECLIPSELINK_1_0_SCHEMA = "eclipselink_persistence_map_1.0.xsd";
    public static final String TOPLINK_11_SCHEMA = "toplink-object-persistence_11_1_1.xsd";
    public static final String TOPLINK_10_SCHEMA = "toplink-object-persistence_10_1_3.xsd";

    public static boolean shouldUseSchemaValidation() {
        return shouldUseSchemaValidation;
    }

    public static void setShouldUseSchemaValidation(boolean value2) {
        shouldUseSchemaValidation = value2;
    }

    public static Project read(String fileOrResourceName) {
        return XMLProjectReader.read(fileOrResourceName, null);
    }

    public static Project read(Reader reader, ClassLoader classLoader) {
        Document document;
        try {
            StringWriter writer = new StringWriter(4096);
            char[] c = new char[4096];
            int r = 0;
            while ((r = reader.read(c)) != -1) {
                writer.write(c, 0, r);
            }
            String schema = null;
            if (XMLProjectReader.shouldUseSchemaValidation()) {
                schema = "org/eclipse/persistence/eclipselink_persistence_map_2.3.xsd";
            }
            XMLPlatform xmlPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            XMLParser parser = XMLProjectReader.createXMLParser(xmlPlatform, true, false, schema);
            try {
                document = parser.parse(new StringReader(writer.toString()));
            }
            catch (Exception parseException) {
                try {
                    if (XMLProjectReader.shouldUseSchemaValidation()) {
                        schema = "org/eclipse/persistence/eclipselink_persistence_map_1.0.xsd";
                    }
                    parser = XMLProjectReader.createXMLParser(xmlPlatform, true, false, schema);
                    document = parser.parse(new StringReader(writer.toString()));
                }
                catch (Exception exception) {
                    try {
                        if (XMLProjectReader.shouldUseSchemaValidation()) {
                            schema = "org/eclipse/persistence/toplink-object-persistence_11_1_1.xsd";
                        }
                        parser = XMLProjectReader.createXMLParser(xmlPlatform, true, false, schema);
                        document = parser.parse(new StringReader(writer.toString()));
                    }
                    catch (Exception exception2) {
                        throw parseException;
                    }
                    String version = document.getDocumentElement().getAttribute("version");
                    if (version == null || version.indexOf("1.0") == -1) {
                        throw parseException;
                    }
                }
            }
        }
        catch (Exception exception) {
            throw XMLMarshalException.unmarshalException(exception);
        }
        String version = document.getDocumentElement().getAttribute("version");
        if (version != null) {
            if (version.indexOf("10.1.3") != -1) {
                return XMLProjectReader.read1013Format(document, classLoader);
            }
            if (version.indexOf("11.1.1") != -1) {
                return XMLProjectReader.read1111Format(document, classLoader);
            }
            if (version.indexOf("TopLink") != -1) {
                return XMLProjectReader.read1111Format(document, classLoader);
            }
        }
        if (project == null) {
            project = new EclipseLinkObjectPersistenceRuntimeXMLProject();
        }
        return XMLProjectReader.readObjectPersistenceRuntimeFormat(document, classLoader, project.clone());
    }

    private static XMLParser createXMLParser(XMLPlatform xmlPlatform, boolean namespaceAware, boolean whitespacePreserving, String schema) {
        XMLParser parser = xmlPlatform.newXMLParser();
        parser.setNamespaceAware(namespaceAware);
        parser.setWhitespacePreserving(whitespacePreserving);
        if (schema != null) {
            parser.setValidationMode(3);
            XMLSchemaResolver xmlSchemaResolver = new XMLSchemaResolver();
            URL eclipselinkSchemaURL = xmlSchemaResolver.resolveURL(schema);
            parser.setEntityResolver(xmlSchemaResolver);
            parser.setXMLSchema(eclipselinkSchemaURL);
        }
        return parser;
    }

    public static Project read(String fileOrResourceName, ClassLoader classLoader) {
        if (fileOrResourceName.toLowerCase().indexOf(".mwp") != -1) {
            throw ValidationException.invalidFileName(fileOrResourceName);
        }
        InputStream fileStream = null;
        fileStream = classLoader == null ? new ConversionManager().getLoader().getResourceAsStream(fileOrResourceName) : classLoader.getResourceAsStream(fileOrResourceName);
        if (fileStream == null) {
            File file = new File(fileOrResourceName);
            if (!file.exists()) {
                throw ValidationException.projectXMLNotFound(fileOrResourceName, null);
            }
            try {
                fileStream = new FileInputStream(fileOrResourceName);
            }
            catch (FileNotFoundException exception) {
                throw ValidationException.projectXMLNotFound(fileOrResourceName, exception);
            }
        }
        InputStreamReader reader = null;
        try {
            Project project;
            try {
                reader = new InputStreamReader(fileStream, "UTF-8");
            }
            catch (UnsupportedEncodingException exception) {
                throw ValidationException.fatalErrorOccurred(exception);
            }
            Project project2 = project = XMLProjectReader.read(reader, classLoader);
            return project2;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException exception) {
                throw ValidationException.fileError(exception);
            }
        }
    }

    public static Project read1013Format(Document document, ClassLoader classLoader) {
        ObjectPersistenceRuntimeXMLProject opmProject = new ObjectPersistenceRuntimeXMLProject();
        return XMLProjectReader.readObjectPersistenceRuntimeFormat(document, classLoader, opmProject);
    }

    public static Project read1111Format(Document document, ClassLoader classLoader) {
        ObjectPersistenceRuntimeXMLProject_11_1_1 opmProject = new ObjectPersistenceRuntimeXMLProject_11_1_1();
        return XMLProjectReader.readObjectPersistenceRuntimeFormat(document, classLoader, opmProject);
    }

    public static Project readObjectPersistenceRuntimeFormat(Document document, ClassLoader classLoader, Project opmProject) {
        XMLLogin xmlLogin = new XMLLogin();
        xmlLogin.setDatasourcePlatform(new DOMPlatform());
        opmProject.setDatasourceLogin(xmlLogin);
        if (classLoader != null) {
            xmlLogin.getDatasourcePlatform().getConversionManager().setLoader(classLoader);
        }
        XMLContext context = new XMLContext(opmProject);
        context.getSession(Project.class).getEventManager().addListener(new MissingDescriptorListener());
        XMLUnmarshaller unmarshaller = context.createUnmarshaller();
        Project project = (Project)unmarshaller.unmarshal(document);
        if (classLoader != null && project.getDatasourceLogin() != null) {
            project.getDatasourceLogin().getDatasourcePlatform().getConversionManager().setLoader(classLoader);
        }
        return project;
    }

    public static Project read(Reader reader) {
        return XMLProjectReader.read(reader, null);
    }

    private static class XMLSchemaResolver
    implements EntityResolver {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            if (XMLProjectReader.OPM_SCHEMA.equals(systemId)) {
                URL url = this.resolveURL("org/eclipse/persistence/object-persistence_1_0.xsd");
                if (url == null) {
                    return null;
                }
                return new InputSource(url.openStream());
            }
            return null;
        }

        public URL resolveURL(String resource) {
            return this.getClass().getClassLoader().getResource(resource);
        }
    }
}

