/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model;

import com.jamesmurty.utils.XMLBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.jets3t.service.ServiceException;

public abstract class StorageBucketLoggingStatus {
    private String targetBucketName = null;
    private String logfilePrefix = null;

    public StorageBucketLoggingStatus() {
    }

    public StorageBucketLoggingStatus(String targetBucketName, String logfilePrefix) {
        this.targetBucketName = targetBucketName;
        this.logfilePrefix = logfilePrefix;
    }

    public boolean isLoggingEnabled() {
        return this.targetBucketName != null && this.logfilePrefix != null;
    }

    public String getLogfilePrefix() {
        return this.logfilePrefix;
    }

    public void setLogfilePrefix(String logfilePrefix) {
        this.logfilePrefix = logfilePrefix;
    }

    public String getTargetBucketName() {
        return this.targetBucketName;
    }

    public void setTargetBucketName(String targetBucketName) {
        this.targetBucketName = targetBucketName;
    }

    public String toString() {
        String result2 = "LoggingStatus enabled=" + this.isLoggingEnabled();
        if (this.isLoggingEnabled()) {
            result2 = result2 + ", targetBucketName=" + this.getTargetBucketName() + ", logfilePrefix=" + this.getLogfilePrefix();
        }
        return result2;
    }

    public String toXml() throws ServiceException {
        try {
            return this.toXMLBuilder().asString();
        }
        catch (Exception e) {
            throw new ServiceException("Failed to build XML document for ACL", e);
        }
    }

    public abstract XMLBuilder toXMLBuilder() throws ParserConfigurationException, FactoryConfigurationError, TransformerException;
}

