/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.model.cloudfront;

import java.util.Arrays;
import org.jets3t.service.model.cloudfront.LoggingStatus;
import org.jets3t.service.model.cloudfront.Origin;
import org.jets3t.service.model.cloudfront.S3Origin;
import org.jets3t.service.model.cloudfront.StreamingDistributionConfig;

public class DistributionConfig {
    private Origin origin = null;
    private String callerReference = null;
    private String[] cnames = new String[0];
    private String comment = null;
    private boolean enabled = false;
    private String etag = null;
    private LoggingStatus loggingStatus = null;
    private boolean trustedSignerSelf = false;
    private String[] trustedSignerAwsAccountNumbers = new String[0];
    private String[] requiredProtocols = new String[0];
    private String defaultRootObject = null;

    public DistributionConfig(Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus, boolean trustedSignerSelf, String[] trustedSignerAwsAccountNumbers, String[] requiredProtocols, String defaultRootObject) {
        this.origin = origin;
        this.callerReference = callerReference;
        this.cnames = cnames;
        this.comment = comment;
        this.enabled = enabled;
        this.loggingStatus = loggingStatus;
        this.trustedSignerSelf = trustedSignerSelf;
        this.trustedSignerAwsAccountNumbers = trustedSignerAwsAccountNumbers;
        this.requiredProtocols = requiredProtocols;
        this.defaultRootObject = defaultRootObject;
    }

    public DistributionConfig(Origin origin, String callerReference, String[] cnames, String comment, boolean enabled, LoggingStatus loggingStatus) {
        this(origin, callerReference, cnames, comment, enabled, loggingStatus, false, null, null, null);
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public String getCallerReference() {
        return this.callerReference;
    }

    public String[] getCNAMEs() {
        return this.cnames;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getEtag() {
        return this.etag;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public LoggingStatus getLoggingStatus() {
        return this.loggingStatus;
    }

    public boolean isLoggingEnabled() {
        return this.loggingStatus != null;
    }

    public boolean isPrivate() {
        return this.getOrigin() instanceof S3Origin && ((S3Origin)this.getOrigin()).getOriginAccessIdentity() != null;
    }

    public String[] getTrustedSignerAwsAccountNumbers() {
        return this.trustedSignerAwsAccountNumbers;
    }

    public boolean isTrustedSignerSelf() {
        return this.trustedSignerSelf;
    }

    public boolean hasTrustedSignerAwsAccountNumbers() {
        return this.getTrustedSignerAwsAccountNumbers() != null && this.getTrustedSignerAwsAccountNumbers().length > 0;
    }

    public boolean isUrlSigningRequired() {
        return this.isTrustedSignerSelf() || this.hasTrustedSignerAwsAccountNumbers();
    }

    public boolean isStreamingDistributionConfig() {
        return this instanceof StreamingDistributionConfig;
    }

    public void setRequiredProtocols(String[] protocols2) {
        this.requiredProtocols = protocols2;
    }

    public String[] getRequiredProtocols() {
        return this.requiredProtocols;
    }

    public boolean isHttpsProtocolRequired() {
        return this.requiredProtocols != null && this.requiredProtocols.length > 0 && "https".equals(this.requiredProtocols[0]);
    }

    public void setHttpsProtocolRequired(boolean value2) {
        this.requiredProtocols = value2 ? new String[]{"https"} : new String[0];
    }

    public String getDefaultRootObject() {
        return this.defaultRootObject;
    }

    public String toString() {
        return (this.isStreamingDistributionConfig() ? "StreamingDistributionConfig" : "DistributionConfig") + ": origin=" + this.origin + ", callerReference=" + this.callerReference + ", comment=" + this.comment + ", enabled=" + this.enabled + (this.isPrivate() ? ", Private:originAccessIdentity=" + ((S3Origin)this.getOrigin()).getOriginAccessIdentity() : ", Public") + (this.isUrlSigningRequired() ? ", TrustedSigners:self=" + this.isTrustedSignerSelf() + (this.hasTrustedSignerAwsAccountNumbers() ? ":awsAccountNumbers=" + Arrays.asList(this.getTrustedSignerAwsAccountNumbers()) : "") : "") + (this.etag != null ? ", etag=" + this.etag : "") + (!this.isLoggingEnabled() ? "" : ", LoggingStatus: bucket=" + this.loggingStatus.getBucket() + ", prefix=" + this.loggingStatus.getPrefix()) + (this.getRequiredProtocols() == null || this.getRequiredProtocols().length == 0 ? "" : ", RequiredProtocols=" + Arrays.asList(this.getRequiredProtocols())) + ", CNAMEs=" + Arrays.asList(this.cnames) + ", DefaultRootObject=" + this.defaultRootObject;
    }
}

