/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.mortbay.util.TypeUtil;

public class QuotedStringTokenizer
extends StringTokenizer {
    private static final String __delim = "\t\n\r";
    private String _string;
    private String _delim = "\t\n\r";
    private boolean _returnQuotes = false;
    private boolean _returnDelimiters = false;
    private StringBuffer _token;
    private boolean _hasToken = false;
    private int _i = 0;
    private int _lastStart = 0;
    private boolean _double = true;
    private boolean _single = true;

    public QuotedStringTokenizer(String str, String delim, boolean returnDelimiters, boolean returnQuotes) {
        super("");
        this._string = str;
        if (delim != null) {
            this._delim = delim;
        }
        this._returnDelimiters = returnDelimiters;
        this._returnQuotes = returnQuotes;
        if (this._delim.indexOf(39) >= 0 || this._delim.indexOf(34) >= 0) {
            throw new Error("Can't use quotes as delimiters: " + this._delim);
        }
        this._token = new StringBuffer(this._string.length() > 1024 ? 512 : this._string.length() / 2);
    }

    public QuotedStringTokenizer(String str, String delim, boolean returnDelimiters) {
        this(str, delim, returnDelimiters, false);
    }

    public QuotedStringTokenizer(String str, String delim) {
        this(str, delim, false, false);
    }

    public QuotedStringTokenizer(String str) {
        this(str, null, false, false);
    }

    public boolean hasMoreTokens() {
        if (this._hasToken) {
            return true;
        }
        this._lastStart = this._i;
        int state = 0;
        boolean escape = false;
        block6: while (this._i < this._string.length()) {
            char c = this._string.charAt(this._i++);
            switch (state) {
                case 0: {
                    if (this._delim.indexOf(c) >= 0) {
                        if (!this._returnDelimiters) continue block6;
                        this._token.append(c);
                        this._hasToken = true;
                        return true;
                    }
                    if (c == '\'' && this._single) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = 2;
                        continue block6;
                    }
                    if (c == '\"' && this._double) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = 3;
                        continue block6;
                    }
                    this._token.append(c);
                    this._hasToken = true;
                    state = 1;
                    continue block6;
                }
                case 1: {
                    this._hasToken = true;
                    if (this._delim.indexOf(c) >= 0) {
                        if (this._returnDelimiters) {
                            --this._i;
                        }
                        return this._hasToken;
                    }
                    if (c == '\'' && this._single) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = 2;
                        continue block6;
                    }
                    if (c == '\"' && this._double) {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = 3;
                        continue block6;
                    }
                    this._token.append(c);
                    continue block6;
                }
                case 2: {
                    this._hasToken = true;
                    if (escape) {
                        escape = false;
                        this._token.append(c);
                        continue block6;
                    }
                    if (c == '\'') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = 1;
                        continue block6;
                    }
                    if (c == '\\') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        escape = true;
                        continue block6;
                    }
                    this._token.append(c);
                    continue block6;
                }
                case 3: {
                    this._hasToken = true;
                    if (escape) {
                        escape = false;
                        this._token.append(c);
                        continue block6;
                    }
                    if (c == '\"') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        state = 1;
                        continue block6;
                    }
                    if (c == '\\') {
                        if (this._returnQuotes) {
                            this._token.append(c);
                        }
                        escape = true;
                        continue block6;
                    }
                    this._token.append(c);
                    continue block6;
                }
            }
        }
        return this._hasToken;
    }

    public String nextToken() throws NoSuchElementException {
        if (!this.hasMoreTokens() || this._token == null) {
            throw new NoSuchElementException();
        }
        String t = this._token.toString();
        this._token.setLength(0);
        this._hasToken = false;
        return t;
    }

    public String nextToken(String delim) throws NoSuchElementException {
        this._delim = delim;
        this._i = this._lastStart;
        this._token.setLength(0);
        this._hasToken = false;
        return this.nextToken();
    }

    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    public Object nextElement() throws NoSuchElementException {
        return this.nextToken();
    }

    public int countTokens() {
        return -1;
    }

    public static String quote(String s2, String delim) {
        if (s2 == null) {
            return null;
        }
        if (s2.length() == 0) {
            return "\"\"";
        }
        for (int i = 0; i < s2.length(); ++i) {
            char c = s2.charAt(i);
            if (c != '\\' && c != '\"' && c != '\'' && !Character.isWhitespace(c) && delim.indexOf(c) < 0) continue;
            StringBuffer b = new StringBuffer(s2.length() + 8);
            QuotedStringTokenizer.quote(b, s2);
            return b.toString();
        }
        return s2;
    }

    public static String quote(String s2) {
        if (s2 == null) {
            return null;
        }
        if (s2.length() == 0) {
            return "\"\"";
        }
        StringBuffer b = new StringBuffer(s2.length() + 8);
        QuotedStringTokenizer.quote(b, s2);
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quote(StringBuffer buf, String s2) {
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            char c;
            int i;
            buf.append('\"');
            char[] chars = null;
            block21: for (i = 0; i < s2.length(); ++i) {
                c = s2.charAt(i);
                switch (c) {
                    case '\"': {
                        chars = s2.toCharArray();
                        buf.append(chars, 0, i);
                        buf.append("\\\"");
                        break block21;
                    }
                    case '\\': {
                        chars = s2.toCharArray();
                        buf.append(chars, 0, i);
                        buf.append("\\\\");
                        break block21;
                    }
                    case '\n': {
                        chars = s2.toCharArray();
                        buf.append(chars, 0, i);
                        buf.append("\\n");
                        break block21;
                    }
                    case '\r': {
                        chars = s2.toCharArray();
                        buf.append(chars, 0, i);
                        buf.append("\\r");
                        break block21;
                    }
                    case '\t': {
                        chars = s2.toCharArray();
                        buf.append(chars, 0, i);
                        buf.append("\\t");
                        break block21;
                    }
                    case '\f': {
                        chars = s2.toCharArray();
                        buf.append(chars, 0, i);
                        buf.append("\\f");
                        break block21;
                    }
                    case '\b': {
                        chars = s2.toCharArray();
                        buf.append(chars, 0, i);
                        buf.append("\\b");
                        break block21;
                    }
                    default: {
                        continue block21;
                    }
                }
            }
            if (chars == null) {
                buf.append(s2);
            } else {
                ++i;
                while (i < s2.length()) {
                    c = s2.charAt(i);
                    switch (c) {
                        case '\"': {
                            buf.append("\\\"");
                            break;
                        }
                        case '\\': {
                            buf.append("\\\\");
                            break;
                        }
                        case '\n': {
                            buf.append("\\n");
                            break;
                        }
                        case '\r': {
                            buf.append("\\r");
                            break;
                        }
                        case '\t': {
                            buf.append("\\t");
                            break;
                        }
                        case '\f': {
                            buf.append("\\f");
                            break;
                        }
                        case '\b': {
                            buf.append("\\b");
                            break;
                        }
                        default: {
                            buf.append(c);
                            break;
                        }
                    }
                    ++i;
                }
            }
            buf.append('\"');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void quoteIfNeeded(StringBuffer buf, String s2) {
        StringBuffer stringBuffer = buf;
        synchronized (stringBuffer) {
            char c;
            int i;
            int e = -1;
            block15: for (i = 0; i < s2.length(); ++i) {
                c = s2.charAt(i);
                switch (c) {
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': 
                    case '\"': 
                    case '%': 
                    case '+': 
                    case ';': 
                    case '=': 
                    case '\\': {
                        e = i;
                        buf.append('\"');
                        for (int j = 0; j < e; ++j) {
                            buf.append(s2.charAt(j));
                        }
                        break block15;
                    }
                    default: {
                        continue block15;
                    }
                }
            }
            if (e < 0) {
                buf.append(s2);
                return;
            }
            block17: for (i = e; i < s2.length(); ++i) {
                c = s2.charAt(i);
                switch (c) {
                    case '\"': {
                        buf.append("\\\"");
                        continue block17;
                    }
                    case '\\': {
                        buf.append("\\\\");
                        continue block17;
                    }
                    case '\n': {
                        buf.append("\\n");
                        continue block17;
                    }
                    case '\r': {
                        buf.append("\\r");
                        continue block17;
                    }
                    case '\t': {
                        buf.append("\\t");
                        continue block17;
                    }
                    case '\f': {
                        buf.append("\\f");
                        continue block17;
                    }
                    case '\b': {
                        buf.append("\\b");
                        continue block17;
                    }
                    default: {
                        buf.append(c);
                        continue block17;
                    }
                }
            }
            buf.append('\"');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String unquote(String s2) {
        StringBuffer b;
        char last2;
        if (s2 == null) {
            return null;
        }
        if (s2.length() < 2) {
            return s2;
        }
        char first = s2.charAt(0);
        if (first != (last2 = s2.charAt(s2.length() - 1)) || first != '\"' && first != '\'') {
            return s2;
        }
        StringBuffer stringBuffer = b = new StringBuffer(s2.length() - 2);
        synchronized (stringBuffer) {
            boolean escape = false;
            for (int i = 1; i < s2.length() - 1; ++i) {
                char c = s2.charAt(i);
                if (escape) {
                    escape = false;
                    switch (c) {
                        case 'n': {
                            b.append('\n');
                            break;
                        }
                        case 'r': {
                            b.append('\r');
                            break;
                        }
                        case 't': {
                            b.append('\t');
                            break;
                        }
                        case 'f': {
                            b.append('\f');
                            break;
                        }
                        case 'b': {
                            b.append('\b');
                            break;
                        }
                        case 'u': {
                            b.append((char)((TypeUtil.convertHexDigit((byte)s2.charAt(i++)) << 24) + (TypeUtil.convertHexDigit((byte)s2.charAt(i++)) << 16) + (TypeUtil.convertHexDigit((byte)s2.charAt(i++)) << 8) + TypeUtil.convertHexDigit((byte)s2.charAt(i++))));
                            break;
                        }
                        default: {
                            b.append(c);
                            break;
                        }
                    }
                    continue;
                }
                if (c == '\\') {
                    escape = true;
                    continue;
                }
                b.append(c);
            }
            return b.toString();
        }
    }

    public boolean getDouble() {
        return this._double;
    }

    public void setDouble(boolean d) {
        this._double = d;
    }

    public boolean getSingle() {
        return this._single;
    }

    public void setSingle(boolean single) {
        this._single = single;
    }
}

