/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.governanceenginesplugins.gaianrangerplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;

public class ApplyMasking {
    private static final String DEFAULT_CHAR_MASKING = "####";
    private static final int DEFAULT_INT_MASKING = 1111;
    private static final String DEFAULT_DATA_MASKING = "0001-01-01";
    private static final String YYYY_MM_DD = "yyyy-MM-dd";
    private static final String CHAR_MASKING_PROPERTY = "ranger.plugin.gaian.char.masking";
    private static final String INT_MASKING_PROPERTY = "ranger.plugin.gaian.int.masking";
    private static final String DATE_MASKING_PROPERTY = "ranger.plugin.gaian.date.masking";

    public static void redact(DataValueDescriptor dataValueDescriptor, Boolean isNullMasking, Properties properties) throws StandardException, ParseException {
        if (dataValueDescriptor == null) {
            return;
        }
        if (isNullMasking.booleanValue()) {
            ApplyMasking.maskedToNull(dataValueDescriptor);
        } else {
            ApplyMasking.customMasking(dataValueDescriptor, properties);
        }
    }

    private static void maskedToNull(DataValueDescriptor dataValueDescriptor) {
        dataValueDescriptor.setToNull();
    }

    private static void customMasking(DataValueDescriptor dataValueDescriptor, Properties properties) throws StandardException, ParseException {
        int jdbcType = TypeId.getBuiltInTypeId((String)dataValueDescriptor.getTypeName()).getJDBCTypeId();
        switch (jdbcType) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                dataValueDescriptor.setValue(ApplyMasking.getCharMaskingValue(properties));
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                dataValueDescriptor.setValue((Object)ApplyMasking.getDateMaskingValue(properties));
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                dataValueDescriptor.setValue(ApplyMasking.getIntMaskingValue(properties));
                break;
            }
            default: {
                dataValueDescriptor.setValue("Masked");
            }
        }
    }

    private static String getCharMaskingValue(Properties properties) {
        String property = ApplyMasking.getStringProperty(properties, CHAR_MASKING_PROPERTY);
        if (property != null) {
            return property;
        }
        return DEFAULT_CHAR_MASKING;
    }

    private static int getIntMaskingValue(Properties properties) {
        String property = ApplyMasking.getStringProperty(properties, INT_MASKING_PROPERTY);
        if (property != null) {
            return Integer.valueOf(property);
        }
        return 1111;
    }

    private static Date getDateMaskingValue(Properties properties) throws ParseException {
        SimpleDateFormat format2 = new SimpleDateFormat(YYYY_MM_DD);
        return format2.parse(ApplyMasking.getDateMasking(properties));
    }

    private static String getDateMasking(Properties properties) {
        String property = ApplyMasking.getStringProperty(properties, DATE_MASKING_PROPERTY);
        if (property != null) {
            return property;
        }
        return DEFAULT_DATA_MASKING;
    }

    private static String getStringProperty(Properties properties, String s2) {
        String property;
        if (properties != null && (property = properties.getProperty(s2)) != null) {
            return property;
        }
        return null;
    }
}

