/*
 * Decompiled with CFR 0.152.
 */
package org.odpi.openmetadata.adapters.governanceenginesplugins.gaianrangerplugin;

import com.ibm.gaiandb.Logger;
import com.ibm.gaiandb.Util;
import com.ibm.gaiandb.policyframework.SQLResultFilterX;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.odpi.openmetadata.adapters.governanceenginesplugins.gaianrangerplugin.ApplyMasking;
import org.odpi.openmetadata.adapters.governanceenginesplugins.gaianrangerplugin.GaianAuthorizationException;
import org.odpi.openmetadata.adapters.governanceenginesplugins.gaianrangerplugin.QueryContext;
import org.odpi.openmetadata.adapters.governanceenginesplugins.gaianrangerplugin.RangerGaianAuthorizer;
import org.odpi.openmetadata.adapters.governanceenginesplugins.gaianrangerplugin.RangerUser;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestTemplate;

public class RangerPolicyResultFilter
extends SQLResultFilterX {
    private static final Logger logger = new Logger("RangerPolicyResultFilter", 25);
    private QueryContext queryContext = new QueryContext();
    private RangerGaianAuthorizer rangerGaianAuthorizer = new RangerGaianAuthorizer();
    private boolean authorizeResult = true;

    public RangerPolicyResultFilter() {
        logger.logDetail("\nEntered RangerPolicyResultFilter() constructor");
    }

    private RangerUser getRangerUser(String url) {
        RestTemplate restTemplate = new RestTemplate();
        HttpEntity entity = new HttpEntity(this.getHttpHeaders());
        try {
            ResponseEntity<RangerUser> result2 = restTemplate.exchange(url, HttpMethod.GET, entity, RangerUser.class, new Object[0]);
            return (RangerUser)result2.getBody();
        }
        catch (HttpStatusCodeException exception) {
            return null;
        }
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
        if (this.rangerGaianAuthorizer.getRangerServerProperties() != null && this.rangerGaianAuthorizer.getRangerServerProperties().getServerAuthorization() != null) {
            String base64Credentials = this.rangerGaianAuthorizer.getRangerServerProperties().getServerAuthorization();
            headers.set("Authorization", base64Credentials);
        }
        return headers;
    }

    public boolean setForwardingNode(String nodeName) {
        logger.logDetail("Entered setForwardingNode(), forwardingNode: " + nodeName);
        return true;
    }

    public void close() {
        logger.logDetail("Entered close()");
    }

    public int nextQueriedDataSource(String dataSource, int[] columnMappings) {
        logger.logDetail("Entered nextQueriedDataSource() (unexpectedly), dataSource: " + dataSource + ", columnMappings: " + Util.intArrayAsString((int[])columnMappings));
        return -1;
    }

    public int setDataSourceWrapper(String wrapperID) {
        logger.logDetail("Entered setDataSourceWrapper() (unexpectedly), wrapperID: " + wrapperID);
        return -1;
    }

    public boolean filterRow(DataValueDescriptor[] row) {
        logger.logDetail("Entered filterRow() (unexpectedly), row: " + Arrays.asList(row));
        return true;
    }

    public boolean setUserCredentials(String credentialsStringBlock) {
        logger.logDetail("Entered setUserCredentials(), credentialsStringBlock: " + credentialsStringBlock);
        return true;
    }

    public int nextQueriedDataSource(String dataSourceID, String dataSourceDescription, int[] columnMappings) {
        logger.logDetail("Entered nextQueriedDataSource(), dataSourceID: " + dataSourceID + ", dataSourceDescription: " + dataSourceDescription + ", columnMappings: " + Util.intArrayAsString((int[])columnMappings));
        return -1;
    }

    public DataValueDescriptor[][] filterRowsBatch(String dataSourceID, DataValueDescriptor[][] rows) {
        logger.logDetail("Entered filterRowsBatch(), dataSourceID: " + dataSourceID + ", number of rows: " + rows.length);
        if (!this.authorizeResult) {
            logger.logDetail("filterRowsBatch: UnAuthorized query!");
            return new DataValueDescriptor[0][0];
        }
        this.rangerGaianAuthorizer.applyRowFilterAndColumnMasking(this.queryContext);
        if (rows.length == 0) {
            return rows;
        }
        int firstValidRow = this.getFirstValidRow(rows);
        if (firstValidRow == -1) {
            return rows;
        }
        Boolean isNullMasking = this.queryContext.getNullMasking();
        Properties properties = null;
        if (!isNullMasking.booleanValue()) {
            properties = this.loadProperties();
        }
        int resultSetColumnIndexOffset = 0;
        int querySetColumnIndex = 0;
        while (querySetColumnIndex < this.queryContext.getColumns().size() && querySetColumnIndex + resultSetColumnIndexOffset < rows[firstValidRow].length) {
            if (rows[firstValidRow][querySetColumnIndex + resultSetColumnIndexOffset].isNull()) {
                ++resultSetColumnIndexOffset;
                continue;
            }
            if (!this.queryContext.getColumnTransformers().get(querySetColumnIndex).equals(this.queryContext.getColumns().get(querySetColumnIndex))) {
                for (DataValueDescriptor[] row : rows) {
                    if (row == null) continue;
                    try {
                        ApplyMasking.redact(row[querySetColumnIndex + resultSetColumnIndexOffset], isNullMasking, properties);
                    }
                    catch (ParseException | StandardException e) {
                        logger.logException("GAIAN_RANGER-Exeption-1", e.getMessage(), e);
                    }
                }
            }
            ++querySetColumnIndex;
        }
        return rows;
    }

    public boolean setLogicalTable(String logicalTableName, ResultSetMetaData logicalTableResultSetMetaData) {
        logger.logDetail("Entered setLogicalTable(), logicalTable: " + logicalTableName + ", structure: " + logicalTableResultSetMetaData);
        try {
            this.queryContext.setTableName(logicalTableName);
            this.queryContext.setActionType("SELECT");
            this.queryContext.setSchema("Gaian");
            List<String> columns = this.getColumnNamesForLogicalTableResultSet(logicalTableResultSetMetaData);
            this.queryContext.setColumns(columns);
            this.queryContext.setResourceType("COLUMN");
            this.queryContext.setColumnTransformers(new ArrayList<String>());
            Set<String> users = this.getDefaultUserGroups();
            this.queryContext.setNullMasking(this.isNullMasking());
            this.queryContext.setUserGroups(users);
        }
        catch (SQLException e) {
            logger.logException(String.valueOf(e.getErrorCode()), e.getMessage(), (Throwable)e);
        }
        return this.authorizeResult;
    }

    public boolean setQueriedColumns(int[] queriedColumns) {
        logger.logDetail("Entered setQueriedColumns(), queriedColumns: " + Util.intArrayAsString((int[])queriedColumns));
        try {
            List<String> columns = this.getQueryColumns(queriedColumns);
            this.queryContext.setColumns(columns);
            this.queryContext.setNullMasking(this.isNullMasking());
            this.queryContext.setResourceType("COLUMN");
            logger.logDetail("This is the setQueriedColumns " + this.queryContext.toString());
            this.rangerGaianAuthorizer.init();
            this.authorizeResult = this.rangerGaianAuthorizer.isAuthorized(this.queryContext);
        }
        catch (GaianAuthorizationException e) {
            logger.logException("1", e.getMessage(), (Throwable)e);
        }
        return this.authorizeResult;
    }

    protected Object executeOperationImpl(String opID, Object ... args) {
        logger.logDetail("Entered executeOperation(), opID: " + opID + ", args: " + (null == args ? null : Arrays.asList(args)));
        boolean haveUser = false;
        if (null != opID && opID.equals("OP_ID_SET_AUTHENTICATED_DERBY_USER_RETURN_IS_QUERY_ALLOWED")) {
            if (args != null && args.length >= 1 && null != args[0]) {
                this.rangerGaianAuthorizer.init();
                this.setUserDetailsForQueryContext(args[0]);
                haveUser = true;
            }
            if (!haveUser) {
                this.queryContext.setUser("<UNKNOWN>");
                logger.logImportant("Unable to retrieve user. Ensure Table functions configured and used in Query. Defaulting to setting user to <UNKNOWN>");
            }
        }
        return null;
    }

    private Boolean isNullMasking() {
        String maskingPattern;
        if (RangerConfiguration.getInstance() != null && RangerConfiguration.getInstance().getProperties() != null && RangerConfiguration.getInstance().getProperties().getProperty("ranger.plugin.gaian.masking.pattern") != null && (maskingPattern = RangerConfiguration.getInstance().getProperties().getProperty("ranger.plugin.gaian.masking.pattern")) != null) {
            return maskingPattern.equalsIgnoreCase("NULL");
        }
        return Boolean.FALSE;
    }

    private Properties loadProperties() {
        return RangerConfiguration.getInstance().getProperties();
    }

    private void setUserDetailsForQueryContext(Object arg) {
        String gaianUser = arg.toString().toLowerCase();
        this.queryContext.setUser(gaianUser);
        logger.logInfo("Found user for query :" + gaianUser);
        Set<String> userGroups = this.getUserGroups(gaianUser);
        if (userGroups != null) {
            this.queryContext.setUserGroups(userGroups);
        }
    }

    private List<String> getQueryColumns(int[] queriedColumns) {
        ArrayList<String> columns = new ArrayList<String>(queriedColumns.length);
        for (int queriedColumn : queriedColumns) {
            columns.add(this.queryContext.getColumns().get(queriedColumn - 1));
        }
        return columns;
    }

    private List<String> getColumnNamesForLogicalTableResultSet(ResultSetMetaData logicalTableResultSetMetaData) throws SQLException {
        int count2 = logicalTableResultSetMetaData.getColumnCount();
        ArrayList<String> columns = new ArrayList<String>(count2);
        for (int i = 1; i <= count2; ++i) {
            String str = logicalTableResultSetMetaData.getColumnName(i);
            columns.add(str);
        }
        return columns;
    }

    private int getFirstValidRow(DataValueDescriptor[][] rows) {
        for (int i = 0; i < rows.length; ++i) {
            if (rows[i] == null) continue;
            return i;
        }
        return -1;
    }

    private Set<String> getDefaultUserGroups() {
        HashSet<String> users = new HashSet<String>(1);
        users.add("users");
        return users;
    }

    private Set<String> getUserGroups(String userName) {
        String userDetailsURL = this.getRangerURL(userName, "/service/xusers/users/userName/{0}");
        if (userDetailsURL == null) {
            return Collections.emptySet();
        }
        RangerUser userDetails = this.getRangerUser(userDetailsURL);
        if (userDetails != null) {
            logger.logInfo(userDetails.toString());
            return this.getUserGroupsByUserId(userDetails);
        }
        return Collections.emptySet();
    }

    private Set<String> getUserGroupsByUserId(RangerUser userDetails) {
        String userGroupsURL = this.getRangerURL(userDetails.getId(), "/service/xusers/secure/users/{0}");
        if (userGroupsURL == null) {
            return Collections.emptySet();
        }
        RangerUser userGroups = this.getRangerUser(userGroupsURL);
        if (userGroups != null) {
            logger.logInfo(userGroups.toString());
            return userGroups.getGroupNameList();
        }
        return Collections.emptySet();
    }

    private String getRangerURL(String userId, String rangerSpecificURL) {
        String rangerURL = this.getRangerServerURL();
        if (rangerURL == null) {
            return null;
        }
        String url = rangerURL + rangerSpecificURL;
        return MessageFormat.format(url, userId);
    }

    private String getRangerServerURL() {
        if (this.rangerGaianAuthorizer.getRangerServerProperties() == null || this.rangerGaianAuthorizer.getRangerServerProperties().getServerURL() == null) {
            return null;
        }
        String rangerURL = this.rangerGaianAuthorizer.getRangerServerProperties().getServerURL();
        logger.logDetail("RangerURL: " + rangerURL);
        return rangerURL;
    }
}

