/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.CollectionFactory;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.reader.UnicodeReader;

public abstract class YamlProcessor {
    private final Log logger = LogFactory.getLog(this.getClass());
    private ResolutionMethod resolutionMethod = ResolutionMethod.OVERRIDE;
    private Resource[] resources = new Resource[0];
    private List<DocumentMatcher> documentMatchers = Collections.emptyList();
    private boolean matchDefault = true;

    public void setDocumentMatchers(DocumentMatcher ... matchers) {
        this.documentMatchers = Arrays.asList(matchers);
    }

    public void setMatchDefault(boolean matchDefault) {
        this.matchDefault = matchDefault;
    }

    public void setResolutionMethod(ResolutionMethod resolutionMethod) {
        Assert.notNull((Object)resolutionMethod, "ResolutionMethod must not be null");
        this.resolutionMethod = resolutionMethod;
    }

    public void setResources(Resource ... resources) {
        this.resources = resources;
    }

    protected void process(MatchCallback callback) {
        Yaml yaml = this.createYaml();
        for (Resource resource : this.resources) {
            boolean found = this.process(callback, yaml, resource);
            if (this.resolutionMethod != ResolutionMethod.FIRST_FOUND || !found) continue;
            return;
        }
    }

    protected Yaml createYaml() {
        LoaderOptions options = new LoaderOptions();
        options.setAllowDuplicateKeys(false);
        return new Yaml(options);
    }

    private boolean process(MatchCallback callback, Yaml yaml, Resource resource) {
        int count2 = 0;
        try {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Loading from YAML: " + resource);
            }
            try (UnicodeReader reader = new UnicodeReader(resource.getInputStream());){
                for (Object object : yaml.loadAll((Reader)reader)) {
                    if (object == null || !this.process(this.asMap(object), callback)) continue;
                    ++count2;
                    if (this.resolutionMethod != ResolutionMethod.FIRST_FOUND) continue;
                    break;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Loaded " + count2 + " document" + (count2 > 1 ? "s" : "") + " from YAML resource: " + resource);
                }
            }
        }
        catch (IOException ex) {
            this.handleProcessError(resource, ex);
        }
        return count2 > 0;
    }

    private void handleProcessError(Resource resource, IOException ex) {
        if (this.resolutionMethod != ResolutionMethod.FIRST_FOUND && this.resolutionMethod != ResolutionMethod.OVERRIDE_AND_IGNORE) {
            throw new IllegalStateException(ex);
        }
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Could not load map from " + resource + ": " + ex.getMessage());
        }
    }

    private Map<String, Object> asMap(Object object) {
        LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>();
        if (!(object instanceof Map)) {
            result2.put("document", object);
            return result2;
        }
        Map map2 = (Map)object;
        map2.forEach((key, value2) -> {
            if (value2 instanceof Map) {
                value2 = this.asMap(value2);
            }
            if (key instanceof CharSequence) {
                result2.put(key.toString(), value2);
            } else {
                result2.put("[" + key.toString() + "]", value2);
            }
        });
        return result2;
    }

    private boolean process(Map<String, Object> map2, MatchCallback callback) {
        Properties properties = CollectionFactory.createStringAdaptingProperties();
        properties.putAll(this.getFlattenedMap(map2));
        if (this.documentMatchers.isEmpty()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Merging document (no matchers set): " + map2);
            }
            callback.process(properties, map2);
            return true;
        }
        MatchStatus result2 = MatchStatus.ABSTAIN;
        for (DocumentMatcher matcher : this.documentMatchers) {
            MatchStatus match = matcher.matches(properties);
            result2 = MatchStatus.getMostSpecific(match, result2);
            if (match != MatchStatus.FOUND) continue;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Matched document with document matcher: " + properties);
            }
            callback.process(properties, map2);
            return true;
        }
        if (result2 == MatchStatus.ABSTAIN && this.matchDefault) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Matched document with default matcher: " + map2);
            }
            callback.process(properties, map2);
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Unmatched document: " + map2);
        }
        return false;
    }

    protected final Map<String, Object> getFlattenedMap(Map<String, Object> source) {
        LinkedHashMap<String, Object> result2 = new LinkedHashMap<String, Object>();
        this.buildFlattenedMap(result2, source, null);
        return result2;
    }

    private void buildFlattenedMap(Map<String, Object> result2, Map<String, Object> source, @Nullable String path) {
        source.forEach((key, value2) -> {
            if (StringUtils.hasText(path)) {
                key = key.startsWith("[") ? path + key : path + '.' + key;
            }
            if (value2 instanceof String) {
                result2.put((String)key, value2);
            } else if (value2 instanceof Map) {
                Map map2 = (Map)value2;
                this.buildFlattenedMap(result2, map2, (String)key);
            } else if (value2 instanceof Collection) {
                Collection collection = (Collection)value2;
                if (collection.isEmpty()) {
                    result2.put((String)key, "");
                } else {
                    int count2 = 0;
                    for (Object object : collection) {
                        this.buildFlattenedMap(result2, Collections.singletonMap("[" + count2++ + "]", object), (String)key);
                    }
                }
            } else {
                result2.put((String)key, value2 != null ? value2 : "");
            }
        });
    }

    public static enum ResolutionMethod {
        OVERRIDE,
        OVERRIDE_AND_IGNORE,
        FIRST_FOUND;

    }

    public static enum MatchStatus {
        FOUND,
        NOT_FOUND,
        ABSTAIN;


        public static MatchStatus getMostSpecific(MatchStatus a, MatchStatus b) {
            return a.ordinal() < b.ordinal() ? a : b;
        }
    }

    public static interface DocumentMatcher {
        public MatchStatus matches(Properties var1);
    }

    public static interface MatchCallback {
        public void process(Properties var1, Map<String, Object> var2);
    }
}

