/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class CustomBooleanEditor
extends PropertyEditorSupport {
    public static final String VALUE_TRUE = "true";
    public static final String VALUE_FALSE = "false";
    public static final String VALUE_ON = "on";
    public static final String VALUE_OFF = "off";
    public static final String VALUE_YES = "yes";
    public static final String VALUE_NO = "no";
    public static final String VALUE_1 = "1";
    public static final String VALUE_0 = "0";
    @Nullable
    private final String trueString;
    @Nullable
    private final String falseString;
    private final boolean allowEmpty;

    public CustomBooleanEditor(boolean allowEmpty) {
        this(null, null, allowEmpty);
    }

    public CustomBooleanEditor(@Nullable String trueString, @Nullable String falseString, boolean allowEmpty) {
        this.trueString = trueString;
        this.falseString = falseString;
        this.allowEmpty = allowEmpty;
    }

    @Override
    public void setAsText(@Nullable String text) throws IllegalArgumentException {
        String input2;
        String string2 = input2 = text != null ? text.trim() : null;
        if (this.allowEmpty && !StringUtils.hasLength(input2)) {
            this.setValue(null);
        } else if (this.trueString != null && this.trueString.equalsIgnoreCase(input2)) {
            this.setValue(Boolean.TRUE);
        } else if (this.falseString != null && this.falseString.equalsIgnoreCase(input2)) {
            this.setValue(Boolean.FALSE);
        } else if (this.trueString == null && (VALUE_TRUE.equalsIgnoreCase(input2) || VALUE_ON.equalsIgnoreCase(input2) || VALUE_YES.equalsIgnoreCase(input2) || VALUE_1.equals(input2))) {
            this.setValue(Boolean.TRUE);
        } else if (this.falseString == null && (VALUE_FALSE.equalsIgnoreCase(input2) || VALUE_OFF.equalsIgnoreCase(input2) || VALUE_NO.equalsIgnoreCase(input2) || VALUE_0.equals(input2))) {
            this.setValue(Boolean.FALSE);
        } else {
            throw new IllegalArgumentException("Invalid boolean value [" + text + "]");
        }
    }

    @Override
    public String getAsText() {
        if (Boolean.TRUE.equals(this.getValue())) {
            return this.trueString != null ? this.trueString : VALUE_TRUE;
        }
        if (Boolean.FALSE.equals(this.getValue())) {
            return this.falseString != null ? this.falseString : VALUE_FALSE;
        }
        return "";
    }
}

