/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.propertyeditors;

import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class URIEditor
extends PropertyEditorSupport {
    @Nullable
    private final ClassLoader classLoader;
    private final boolean encode;

    public URIEditor() {
        this(true);
    }

    public URIEditor(boolean encode2) {
        this.classLoader = null;
        this.encode = encode2;
    }

    public URIEditor(@Nullable ClassLoader classLoader) {
        this(classLoader, true);
    }

    public URIEditor(@Nullable ClassLoader classLoader, boolean encode2) {
        this.classLoader = classLoader != null ? classLoader : ClassUtils.getDefaultClassLoader();
        this.encode = encode2;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasText(text)) {
            String uri = text.trim();
            if (this.classLoader != null && uri.startsWith("classpath:")) {
                ClassPathResource resource = new ClassPathResource(uri.substring("classpath:".length()), this.classLoader);
                try {
                    this.setValue(resource.getURI());
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("Could not retrieve URI for " + resource + ": " + ex.getMessage());
                }
            } else {
                try {
                    this.setValue(this.createURI(uri));
                }
                catch (URISyntaxException ex) {
                    throw new IllegalArgumentException("Invalid URI syntax: " + ex);
                }
            }
        } else {
            this.setValue(null);
        }
    }

    protected URI createURI(String value2) throws URISyntaxException {
        int colonIndex = value2.indexOf(58);
        if (this.encode && colonIndex != -1) {
            int fragmentIndex = value2.indexOf(35, colonIndex + 1);
            String scheme = value2.substring(0, colonIndex);
            String ssp = value2.substring(colonIndex + 1, fragmentIndex > 0 ? fragmentIndex : value2.length());
            String fragment = fragmentIndex > 0 ? value2.substring(fragmentIndex + 1) : null;
            return new URI(scheme, ssp, fragment);
        }
        return new URI(value2);
    }

    @Override
    public String getAsText() {
        URI value2 = (URI)this.getValue();
        return value2 != null ? value2.toString() : "";
    }
}

