/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.cookie.DefaultCookie;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collection;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.ZeroCopyHttpOutputMessage;
import org.springframework.http.client.reactive.AbstractClientHttpRequest;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.netty.NettyOutbound;
import reactor.netty.http.client.HttpClientRequest;

class ReactorClientHttpRequest
extends AbstractClientHttpRequest
implements ZeroCopyHttpOutputMessage {
    private final HttpMethod httpMethod;
    private final URI uri;
    private final HttpClientRequest request;
    private final NettyOutbound outbound;
    private final NettyDataBufferFactory bufferFactory;

    public ReactorClientHttpRequest(HttpMethod method, URI uri, HttpClientRequest request, NettyOutbound outbound) {
        this.httpMethod = method;
        this.uri = uri;
        this.request = request;
        this.outbound = outbound;
        this.bufferFactory = new NettyDataBufferFactory(outbound.alloc());
    }

    @Override
    public DataBufferFactory bufferFactory() {
        return this.bufferFactory;
    }

    @Override
    public HttpMethod getMethod() {
        return this.httpMethod;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
        return this.doCommit(() -> {
            if (body instanceof Mono) {
                Mono byteBufMono = Mono.from((Publisher)body).map(NettyDataBufferFactory::toByteBuf);
                return this.outbound.send((Publisher)byteBufMono).then();
            }
            Flux byteBufFlux = Flux.from((Publisher)body).map(NettyDataBufferFactory::toByteBuf);
            return this.outbound.send((Publisher)byteBufFlux).then();
        });
    }

    @Override
    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body) {
        Flux byteBufs = Flux.from(body).map(ReactorClientHttpRequest::toByteBufs);
        return this.doCommit(() -> this.lambda$writeAndFlushWith$1((Publisher)byteBufs));
    }

    private static Publisher<ByteBuf> toByteBufs(Publisher<? extends DataBuffer> dataBuffers) {
        return Flux.from(dataBuffers).map(NettyDataBufferFactory::toByteBuf);
    }

    @Override
    public Mono<Void> writeWith(Path file, long position, long count2) {
        return this.doCommit(() -> this.outbound.sendFile(file, position, count2).then());
    }

    @Override
    public Mono<Void> setComplete() {
        return this.doCommit(() -> ((NettyOutbound)this.outbound).then());
    }

    @Override
    protected void applyHeaders() {
        this.getHeaders().forEach((key, value2) -> this.request.requestHeaders().set(key, (Iterable)value2));
    }

    @Override
    protected void applyCookies() {
        this.getCookies().values().stream().flatMap(Collection::stream).map(cookie -> new DefaultCookie(cookie.getName(), cookie.getValue())).forEach(arg_0 -> ((HttpClientRequest)this.request).addCookie(arg_0));
    }

    private /* synthetic */ Publisher lambda$writeAndFlushWith$1(Publisher byteBufs) {
        return this.outbound.sendGroups(byteBufs).then();
    }
}

