/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.server;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

final class DefaultPathContainer
implements PathContainer {
    private static final MultiValueMap<String, String> EMPTY_PARAMS = new LinkedMultiValueMap<String, String>();
    private static final PathContainer EMPTY_PATH = new DefaultPathContainer("", Collections.emptyList());
    private static final Map<Character, DefaultSeparator> SEPARATORS = new HashMap<Character, DefaultSeparator>(2);
    private final String path;
    private final List<PathContainer.Element> elements;

    private DefaultPathContainer(String path, List<PathContainer.Element> elements) {
        this.path = path;
        this.elements = Collections.unmodifiableList(elements);
    }

    @Override
    public String value() {
        return this.path;
    }

    @Override
    public List<PathContainer.Element> elements() {
        return this.elements;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PathContainer)) {
            return false;
        }
        return this.value().equals(((PathContainer)other).value());
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return this.value();
    }

    static PathContainer createFromUrlPath(String path, PathContainer.Options options) {
        int begin;
        if (path.isEmpty()) {
            return EMPTY_PATH;
        }
        char separator = options.separator();
        DefaultSeparator separatorElement = SEPARATORS.get(Character.valueOf(separator));
        if (separatorElement == null) {
            throw new IllegalArgumentException("Unexpected separator: '" + separator + "'");
        }
        ArrayList<PathContainer.Element> elements = new ArrayList<PathContainer.Element>();
        if (path.charAt(0) == separator) {
            begin = 1;
            elements.add(separatorElement);
        } else {
            begin = 0;
        }
        while (begin < path.length()) {
            String segment;
            int end = path.indexOf(separator, begin);
            String string2 = segment = end != -1 ? path.substring(begin, end) : path.substring(begin);
            if (!segment.isEmpty()) {
                elements.add(options.shouldDecodeAndParseSegments() ? DefaultPathContainer.decodeAndParsePathSegment(segment) : new DefaultPathSegment(segment, separatorElement));
            }
            if (end == -1) break;
            elements.add(separatorElement);
            begin = end + 1;
        }
        return new DefaultPathContainer(path, elements);
    }

    private static PathContainer.PathSegment decodeAndParsePathSegment(String segment) {
        Charset charset = StandardCharsets.UTF_8;
        int index = segment.indexOf(59);
        if (index == -1) {
            String valueToMatch = StringUtils.uriDecode(segment, charset);
            return new DefaultPathSegment(segment, valueToMatch, EMPTY_PARAMS);
        }
        String valueToMatch = StringUtils.uriDecode(segment.substring(0, index), charset);
        String pathParameterContent = segment.substring(index);
        MultiValueMap<String, String> parameters = DefaultPathContainer.parsePathParams(pathParameterContent, charset);
        return new DefaultPathSegment(segment, valueToMatch, parameters);
    }

    private static MultiValueMap<String, String> parsePathParams(String input2, Charset charset) {
        LinkedMultiValueMap<String, String> result2 = new LinkedMultiValueMap<String, String>();
        int begin = 1;
        while (begin < input2.length()) {
            int end = input2.indexOf(59, begin);
            String param2 = end != -1 ? input2.substring(begin, end) : input2.substring(begin);
            DefaultPathContainer.parsePathParamValues(param2, charset, result2);
            if (end == -1) break;
            begin = end + 1;
        }
        return result2;
    }

    private static void parsePathParamValues(String input2, Charset charset, MultiValueMap<String, String> output) {
        if (StringUtils.hasText(input2)) {
            int index = input2.indexOf(61);
            if (index != -1) {
                String name = input2.substring(0, index);
                String value2 = input2.substring(index + 1);
                for (String v : StringUtils.commaDelimitedListToStringArray(value2)) {
                    if (!StringUtils.hasText(name = StringUtils.uriDecode(name, charset))) continue;
                    output.add(name, StringUtils.uriDecode(v, charset));
                }
            } else {
                String name = StringUtils.uriDecode(input2, charset);
                if (StringUtils.hasText(name)) {
                    output.add(input2, "");
                }
            }
        }
    }

    static PathContainer subPath(PathContainer container, int fromIndex, int toIndex) {
        List<PathContainer.Element> elements = container.elements();
        if (fromIndex == 0 && toIndex == elements.size()) {
            return container;
        }
        if (fromIndex == toIndex) {
            return EMPTY_PATH;
        }
        Assert.isTrue(fromIndex >= 0 && fromIndex < elements.size(), () -> "Invalid fromIndex: " + fromIndex);
        Assert.isTrue(toIndex >= 0 && toIndex <= elements.size(), () -> "Invalid toIndex: " + toIndex);
        Assert.isTrue(fromIndex < toIndex, () -> "fromIndex: " + fromIndex + " should be < toIndex " + toIndex);
        List<PathContainer.Element> subList = elements.subList(fromIndex, toIndex);
        String path = subList.stream().map(PathContainer.Element::value).collect(Collectors.joining(""));
        return new DefaultPathContainer(path, subList);
    }

    static {
        SEPARATORS.put(Character.valueOf('/'), new DefaultSeparator('/', "%2F"));
        SEPARATORS.put(Character.valueOf('.'), new DefaultSeparator('.', "%2E"));
    }

    private static class DefaultPathSegment
    implements PathContainer.PathSegment {
        private final String value;
        private final String valueToMatch;
        private final char[] valueToMatchAsChars;
        private final MultiValueMap<String, String> parameters;

        DefaultPathSegment(String value2, String valueToMatch, MultiValueMap<String, String> params) {
            this.value = value2;
            this.valueToMatch = valueToMatch;
            this.valueToMatchAsChars = valueToMatch.toCharArray();
            this.parameters = CollectionUtils.unmodifiableMultiValueMap(params);
        }

        DefaultPathSegment(String value2, DefaultSeparator separator) {
            this.value = value2;
            this.valueToMatch = value2.contains(separator.encodedSequence()) ? value2.replaceAll(separator.encodedSequence(), separator.value()) : value2;
            this.valueToMatchAsChars = this.valueToMatch.toCharArray();
            this.parameters = EMPTY_PARAMS;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String valueToMatch() {
            return this.valueToMatch;
        }

        @Override
        public char[] valueToMatchAsChars() {
            return this.valueToMatchAsChars;
        }

        @Override
        public MultiValueMap<String, String> parameters() {
            return this.parameters;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PathContainer.PathSegment)) {
                return false;
            }
            return this.value().equals(((PathContainer.PathSegment)other).value());
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public String toString() {
            return "[value='" + this.value + "']";
        }
    }

    private static class DefaultSeparator
    implements PathContainer.Separator {
        private final String separator;
        private final String encodedSequence;

        DefaultSeparator(char separator, String encodedSequence) {
            this.separator = String.valueOf(separator);
            this.encodedSequence = encodedSequence;
        }

        @Override
        public String value() {
            return this.separator;
        }

        public String encodedSequence() {
            return this.encodedSequence;
        }
    }
}

