/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.bind.support;

import java.beans.PropertyEditor;
import java.util.List;
import java.util.Map;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.core.MethodParameter;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.server.ServerWebInputException;

public class WebExchangeBindException
extends ServerWebInputException
implements BindingResult {
    private final BindingResult bindingResult;

    public WebExchangeBindException(MethodParameter parameter, BindingResult bindingResult) {
        super("Validation failure", parameter);
        this.bindingResult = bindingResult;
    }

    public final BindingResult getBindingResult() {
        return this.bindingResult;
    }

    public String getObjectName() {
        return this.bindingResult.getObjectName();
    }

    public void setNestedPath(String nestedPath) {
        this.bindingResult.setNestedPath(nestedPath);
    }

    public String getNestedPath() {
        return this.bindingResult.getNestedPath();
    }

    public void pushNestedPath(String subPath) {
        this.bindingResult.pushNestedPath(subPath);
    }

    public void popNestedPath() throws IllegalStateException {
        this.bindingResult.popNestedPath();
    }

    public void reject(String errorCode) {
        this.bindingResult.reject(errorCode);
    }

    public void reject(String errorCode, String defaultMessage) {
        this.bindingResult.reject(errorCode, defaultMessage);
    }

    public void reject(String errorCode, @Nullable Object[] errorArgs, @Nullable String defaultMessage) {
        this.bindingResult.reject(errorCode, errorArgs, defaultMessage);
    }

    public void rejectValue(@Nullable String field2, String errorCode) {
        this.bindingResult.rejectValue(field2, errorCode);
    }

    public void rejectValue(@Nullable String field2, String errorCode, String defaultMessage) {
        this.bindingResult.rejectValue(field2, errorCode, defaultMessage);
    }

    public void rejectValue(@Nullable String field2, String errorCode, @Nullable Object[] errorArgs, @Nullable String defaultMessage) {
        this.bindingResult.rejectValue(field2, errorCode, errorArgs, defaultMessage);
    }

    public void addAllErrors(Errors errors) {
        this.bindingResult.addAllErrors(errors);
    }

    public boolean hasErrors() {
        return this.bindingResult.hasErrors();
    }

    public int getErrorCount() {
        return this.bindingResult.getErrorCount();
    }

    public List<ObjectError> getAllErrors() {
        return this.bindingResult.getAllErrors();
    }

    public boolean hasGlobalErrors() {
        return this.bindingResult.hasGlobalErrors();
    }

    public int getGlobalErrorCount() {
        return this.bindingResult.getGlobalErrorCount();
    }

    public List<ObjectError> getGlobalErrors() {
        return this.bindingResult.getGlobalErrors();
    }

    @Nullable
    public ObjectError getGlobalError() {
        return this.bindingResult.getGlobalError();
    }

    public boolean hasFieldErrors() {
        return this.bindingResult.hasFieldErrors();
    }

    public int getFieldErrorCount() {
        return this.bindingResult.getFieldErrorCount();
    }

    public List<FieldError> getFieldErrors() {
        return this.bindingResult.getFieldErrors();
    }

    @Nullable
    public FieldError getFieldError() {
        return this.bindingResult.getFieldError();
    }

    public boolean hasFieldErrors(String field2) {
        return this.bindingResult.hasFieldErrors(field2);
    }

    public int getFieldErrorCount(String field2) {
        return this.bindingResult.getFieldErrorCount(field2);
    }

    public List<FieldError> getFieldErrors(String field2) {
        return this.bindingResult.getFieldErrors(field2);
    }

    @Nullable
    public FieldError getFieldError(String field2) {
        return this.bindingResult.getFieldError(field2);
    }

    @Nullable
    public Object getFieldValue(String field2) {
        return this.bindingResult.getFieldValue(field2);
    }

    @Nullable
    public Class<?> getFieldType(String field2) {
        return this.bindingResult.getFieldType(field2);
    }

    public Object getTarget() {
        return this.bindingResult.getTarget();
    }

    public Map<String, Object> getModel() {
        return this.bindingResult.getModel();
    }

    @Nullable
    public Object getRawFieldValue(String field2) {
        return this.bindingResult.getRawFieldValue(field2);
    }

    @Nullable
    public PropertyEditor findEditor(@Nullable String field2, @Nullable Class valueType) {
        return this.bindingResult.findEditor(field2, valueType);
    }

    @Nullable
    public PropertyEditorRegistry getPropertyEditorRegistry() {
        return this.bindingResult.getPropertyEditorRegistry();
    }

    public String[] resolveMessageCodes(String errorCode) {
        return this.bindingResult.resolveMessageCodes(errorCode);
    }

    public String[] resolveMessageCodes(String errorCode, String field2) {
        return this.bindingResult.resolveMessageCodes(errorCode, field2);
    }

    public void addError(ObjectError error) {
        this.bindingResult.addError(error);
    }

    public void recordFieldValue(String field2, Class<?> type, @Nullable Object value2) {
        this.bindingResult.recordFieldValue(field2, type, value2);
    }

    public void recordSuppressedField(String field2) {
        this.bindingResult.recordSuppressedField(field2);
    }

    public String[] getSuppressedFields() {
        return this.bindingResult.getSuppressedFields();
    }

    @Override
    public String getMessage() {
        MethodParameter parameter = this.getMethodParameter();
        Assert.state(parameter != null, "No MethodParameter");
        StringBuilder sb = new StringBuilder("Validation failed for argument at index ").append(parameter.getParameterIndex()).append(" in method: ").append(parameter.getExecutable().toGenericString()).append(", with ").append(this.bindingResult.getErrorCount()).append(" error(s): ");
        for (ObjectError error : this.bindingResult.getAllErrors()) {
            sb.append("[").append(error).append("] ");
        }
        return sb.toString();
    }

    public boolean equals(@Nullable Object other) {
        return this == other || this.bindingResult.equals(other);
    }

    public int hashCode() {
        return this.bindingResult.hashCode();
    }
}

